/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.integration;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.read.ListAppender;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.james.GuiceJamesServer;
import org.apache.james.modules.MailboxProbeImpl;
import org.apache.james.probe.DataProbe;
import org.apache.james.util.Port;
import org.apache.james.utils.DataProbeImpl;
import org.apache.james.utils.WebAdminGuiceProbe;
import org.apache.james.webadmin.WebAdminUtils;
import org.apache.james.webadmin.mdc.LoggingRequestFilter;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.LoggerFactory;

public abstract class WebAdminServerIntegrationTest {
    private static final String DOMAIN = "domain";
    protected static final String USERNAME = "username@domain";
    private static final String USERNAME_2 = "username2@domain";
    private static final String GROUP = "group@domain";
    private static final String SPECIFIC_DOMAIN = "/domains/domain";
    private static final String SPECIFIC_USER = "/users/username@domain";
    private static final String MAILBOX = "mailbox";
    private static final String SPECIFIC_MAILBOX = "/users/username@domain/mailboxes/mailbox";
    protected static final String ALIAS_1 = "alias1@domain";
    protected static final String ALIAS_2 = "alias2@domain";
    private DataProbe dataProbe;

    @BeforeEach
    void setUp(GuiceJamesServer guiceJamesServer) throws Exception {
        this.dataProbe = (DataProbe)guiceJamesServer.getProbe(DataProbeImpl.class);
        this.dataProbe.addDomain(DOMAIN);
        WebAdminGuiceProbe webAdminGuiceProbe = (WebAdminGuiceProbe)guiceJamesServer.getProbe(WebAdminGuiceProbe.class);
        RestAssured.requestSpecification = WebAdminUtils.buildRequestSpecification((Port)webAdminGuiceProbe.getWebAdminPort()).build();
    }

    @Test
    void postShouldAddTheGivenDomain() throws Exception {
        ((ValidatableResponse)((Response)RestAssured.when().put(SPECIFIC_DOMAIN, new Object[0])).then()).statusCode(204);
        Assertions.assertThat((List)this.dataProbe.listDomains()).contains((Object[])new String[]{DOMAIN});
    }

    @Test
    void mailQueueRoutesShouldBeExposed() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/mailQueues", new Object[0])).then()).statusCode(200)).body("", Matchers.containsInAnyOrder((Object[])new String[]{"spool", "outgoing"}), new Object[0]);
    }

    @Test
    void metricsRoutesShouldBeExposed() {
        String body = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/metrics", new Object[0])).then()).statusCode(200)).extract().body().asString();
        Assertions.assertThat((String)body).contains(new CharSequence[]{"outgoingMails_total 0.0"});
    }

    @Test
    void healthCheckShouldReturn200WhenCalledRepeatedly() {
        RestAssured.given().get("/healthcheck", new Object[0]);
        RestAssured.given().get("/healthcheck", new Object[0]);
        RestAssured.given().get("/healthcheck", new Object[0]);
        RestAssured.given().get("/healthcheck", new Object[0]);
        RestAssured.given().get("/healthcheck", new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.when().get("/healthcheck", new Object[0])).then()).statusCode(200);
    }

    @Test
    void mailRepositoriesRoutesShouldBeExposed() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("mailRepositories", new Object[0])).then()).statusCode(200)).body("repository", Matchers.containsInAnyOrder((Object[])new String[]{"var/mail/error", "var/mail/relay-denied", "var/mail/address-error", "var/mail/rrt-error"}), new Object[0]);
    }

    @Test
    void gettingANonExistingMailRepositoryShouldNotCreateIt() {
        RestAssured.given().get("mailRepositoriesfile%3A%2F%2Fvar%2Fmail%2Fcustom", new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("mailRepositories", new Object[0])).then()).statusCode(200)).body("repository", Matchers.containsInAnyOrder((Object[])new String[]{"var/mail/error", "var/mail/relay-denied", "var/mail/address-error", "var/mail/rrt-error"}), new Object[0]);
    }

    @Test
    void deleteShouldRemoveTheGivenDomain() throws Exception {
        ((ValidatableResponse)((Response)RestAssured.when().delete(SPECIFIC_DOMAIN, new Object[0])).then()).statusCode(204);
        Assertions.assertThat((List)this.dataProbe.listDomains()).doesNotContain((Object[])new String[]{DOMAIN});
    }

    @Test
    void postShouldAddTheUser() throws Exception {
        ((ValidatableResponse)((Response)RestAssured.given().body("{\"password\":\"password\"}").when().put(SPECIFIC_USER, new Object[0])).then()).statusCode(204);
        Assertions.assertThat((Object[])this.dataProbe.listUsers()).contains((Object[])new String[]{USERNAME});
    }

    @Test
    void putShouldNotLogThePassword() {
        ListAppender<ILoggingEvent> loggingEvents = WebAdminServerIntegrationTest.getListAppenderForClass(LoggingRequestFilter.class);
        RestAssured.with().body("{\"password\":\"password\"}").put(SPECIFIC_USER, new Object[0]);
        ((ListAssert)Assertions.assertThat((List)loggingEvents.list).hasSize(1)).allSatisfy(loggingEvent -> Assertions.assertThat((Map)loggingEvent.getMDCPropertyMap()).doesNotContainKey((Object)"request-body"));
    }

    @Test
    void deleteShouldRemoveTheUser() throws Exception {
        this.dataProbe.addUser(USERNAME, "anyPassword");
        ((ValidatableResponse)((Response)RestAssured.given().body("{\"username\":\"username@domain\",\"password\":\"password\"}").when().delete(SPECIFIC_USER, new Object[0])).then()).statusCode(204);
        Assertions.assertThat((Object[])this.dataProbe.listUsers()).doesNotContain((Object[])new String[]{USERNAME});
    }

    @Test
    void getUsersShouldDisplayUsers() throws Exception {
        this.dataProbe.addUser(USERNAME, "anyPassword");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/users", new Object[0])).then()).statusCode(200)).contentType("application/json")).body(Matchers.is((Object)"[{\"username\":\"username@domain\"}]"), new Matcher[0]);
    }

    @Test
    void putMailboxShouldAddAMailbox(GuiceJamesServer guiceJamesServer) throws Exception {
        this.dataProbe.addUser(USERNAME, "anyPassword");
        ((ValidatableResponse)((Response)RestAssured.when().put(SPECIFIC_MAILBOX, new Object[0])).then()).statusCode(204);
        Assertions.assertThat((Collection)((MailboxProbeImpl)guiceJamesServer.getProbe(MailboxProbeImpl.class)).listUserMailboxes(USERNAME)).containsExactly((Object[])new String[]{MAILBOX});
    }

    @Test
    void deleteMailboxShouldRemoveAMailbox(GuiceJamesServer guiceJamesServer) throws Exception {
        this.dataProbe.addUser(USERNAME, "anyPassword");
        ((MailboxProbeImpl)guiceJamesServer.getProbe(MailboxProbeImpl.class)).createMailbox("#private", USERNAME, MAILBOX);
        ((ValidatableResponse)((Response)RestAssured.when().delete(SPECIFIC_MAILBOX, new Object[0])).then()).statusCode(204);
        Assertions.assertThat((Collection)((MailboxProbeImpl)guiceJamesServer.getProbe(MailboxProbeImpl.class)).listUserMailboxes(USERNAME)).isEmpty();
    }

    @Test
    void addressGroupsEndpointShouldHandleRequests() throws Exception {
        RestAssured.with().put("address/groups/group@domain/username@domain", new Object[0]);
        RestAssured.with().put("address/groups/group@domain/username2@domain", new Object[0]);
        List members = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("address/groups/group@domain", new Object[0])).then()).statusCode(200)).contentType("application/json")).extract().jsonPath().getList(".");
        Assertions.assertThat((List)members).containsOnly((Object[])new String[]{USERNAME, USERNAME_2});
    }

    @Test
    void addressForwardsEndpointShouldListForwardAddresses() throws Exception {
        this.dataProbe.addUser(USERNAME, "anyPassword");
        this.dataProbe.addUser(USERNAME_2, "anyPassword");
        RestAssured.with().put("address/forwards/username@domain/targets/to1@domain.com", new Object[0]);
        RestAssured.with().put("address/forwards/username2@domain/targets/to2@domain.com", new Object[0]);
        List members = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("address/forwards", new Object[0])).then()).statusCode(200)).contentType("application/json")).extract().jsonPath().getList(".");
        Assertions.assertThat((List)members).containsOnly((Object[])new String[]{USERNAME, USERNAME_2});
    }

    @Test
    void addressAliasesEndpointShouldListAliasesAddresses() {
        RestAssured.with().put("address/aliases/username@domain/sources/alias1@domain", new Object[0]);
        RestAssured.with().put("address/aliases/username2@domain/sources/alias2@domain", new Object[0]);
        List members = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("address/aliases", new Object[0])).then()).statusCode(200)).contentType("application/json")).extract().jsonPath().getList(".");
        Assertions.assertThat((List)members).containsOnly((Object[])new String[]{USERNAME, USERNAME_2});
    }

    @Test
    void getUserDefaultIdentityShouldReturnNotFoundByDefault() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(String.format("/users/%s/identities?default=true", USERNAME), new Object[0])).then()).statusCode(404)).contentType("application/json")).body("message", Matchers.is((Object)"Default identity can not be found"), new Object[0]);
    }

    @Test
    void getIdentitiesOfInvalidUserShouldReturnBadRequest() {
        ((ValidatableResponse)((Response)RestAssured.given().urlEncodingEnabled(true).get(String.format("/users/%s/identities?default=true", "John Doe"), new Object[0])).then()).statusCode(400);
    }

    @Test
    void createIdentitiesForInvalidUserShouldReturnBadRequest() {
        ((ValidatableResponse)((Response)RestAssured.given().urlEncodingEnabled(true).body("{\n  \"name\": \"create name 1\",\n  \"email\": \"bob@domain.tld\",\n  \"textSignature\": \"create textSignature1\",\n  \"htmlSignature\": \"create htmlSignature1\",\n  \"sortOrder\": 99,\n  \"bcc\": [\n    {\n      \"name\": \"create bcc 1\",\n      \"email\": \"create_boss_bcc_1@domain.tld\"\n    }\n  ],\n  \"replyTo\": [\n    {\n      \"name\": \"create replyTo 1\",\n      \"email\": \"create_boss1@domain.tld\"\n    }\n  ]\n}").post(String.format("/users/%s/identities", "John Doe"), new Object[0])).then()).statusCode(400);
    }

    @Test
    void updateIdentitiesForInvalidUserShouldReturnBadRequest() {
        ((ValidatableResponse)((Response)RestAssured.given().urlEncodingEnabled(true).body("{\n  \"name\": \"create name 1\",\n  \"email\": \"bob@domain.tld\",\n  \"textSignature\": \"create textSignature1\",\n  \"htmlSignature\": \"create htmlSignature1\",\n  \"sortOrder\": 99,\n  \"bcc\": [\n    {\n      \"name\": \"create bcc 1\",\n      \"email\": \"create_boss_bcc_1@domain.tld\"\n    }\n  ],\n  \"replyTo\": [\n    {\n      \"name\": \"create replyTo 1\",\n      \"email\": \"create_boss1@domain.tld\"\n    }\n  ]\n}").put(String.format("/users/%s/identities/b1c924a3-5b86-44fa-a036-77825ec0e3e6", "John Doe"), new Object[0])).then()).statusCode(400);
    }

    @Test
    void validateHealthChecksShouldReturnOk() {
        ((ValidatableResponse)((Response)RestAssured.when().get("/healthcheck", new Object[0])).then()).statusCode(200);
    }

    @Test
    void jmapTasksShouldBeExposed() {
        String taskId = (String)((Response)RestAssured.with().queryParam("task", new Object[]{"recomputeFastViewProjectionItems"}).post("/mailboxes", new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("type", Matchers.is((Object)"RecomputeAllFastViewProjectionItemsTask"), new Object[0]);
    }

    @Test
    void jmapUserTasksShouldBeExposed() throws Exception {
        this.dataProbe.addUser(USERNAME, "anyPassword");
        String taskId = (String)((Response)RestAssured.with().queryParam("task", new Object[]{"recomputeFastViewProjectionItems"}).post("/users/username@domain/mailboxes", new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("type", Matchers.is((Object)"RecomputeUserFastViewProjectionItemsTask"), new Object[0]);
    }

    @Test
    void mailboxesExportTasksShouldBeExposed() throws Exception {
        this.dataProbe.addUser(USERNAME, "anyPassword");
        String taskId = (String)((Response)RestAssured.with().queryParam("task", new Object[]{"export"}).post("/users/username@domain/mailboxes", new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("type", Matchers.is((Object)"MailboxesExportTask"), new Object[0]);
    }

    @Test
    void createMissParentsTasksShouldBeExposed() {
        String taskId = (String)((Response)RestAssured.with().queryParam("task", new Object[]{"createMissingParents"}).post("/mailboxes", new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("type", Matchers.is((Object)"CreateMissingParentsTask"), new Object[0])).body("additionalInformation.created", Matchers.hasSize((int)0), new Object[0])).body("additionalInformation.totalCreated", Matchers.is((Object)0), new Object[0])).body("additionalInformation.failures", Matchers.empty(), new Object[0])).body("additionalInformation.totalFailure", Matchers.is((Object)0), new Object[0])).body("startedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("submitDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("completedDate", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0]);
    }

    @Test
    void recomputeQuotaTaskShouldBeExposed() throws Exception {
        this.dataProbe.addUser(USERNAME, "anyPassword");
        String taskId = (String)((Response)RestAssured.with().queryParam("task", new Object[]{"RecomputeCurrentQuotas"}).post("/quota/users", new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("taskId", Matchers.is((Object)taskId), new Object[0])).body("type", Matchers.is((Object)"recompute-current-quotas"), new Object[0])).body("additionalInformation.recomputeSingleQuotaComponentResults", Matchers.hasSize((int)3), new Object[0])).body("additionalInformation.recomputeSingleQuotaComponentResults", Matchers.hasItems((Matcher[])new Matcher[]{Matchers.both((Matcher)Matchers.hasEntry((Object)"quotaComponent", (Object)"MAILBOX")).and(Matchers.hasEntry((Object)"processedIdentifierCount", (Object)1)), Matchers.both((Matcher)Matchers.hasEntry((Object)"quotaComponent", (Object)"JMAP_UPLOADS")).and(Matchers.hasEntry((Object)"processedIdentifierCount", (Object)1)), Matchers.both((Matcher)Matchers.hasEntry((Object)"quotaComponent", (Object)"SIEVE")).and(Matchers.hasEntry((Object)"processedIdentifierCount", (Object)1))}), new Object[0]);
    }

    public static ListAppender<ILoggingEvent> getListAppenderForClass(Class clazz) {
        Logger logger = (Logger)LoggerFactory.getLogger((Class)clazz);
        ListAppender loggingEventListAppender = new ListAppender();
        loggingEventListAppender.start();
        logger.addAppender((Appender)loggingEventListAppender);
        return loggingEventListAppender;
    }
}

