/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.james.util.MDCBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Signal;
import reactor.util.context.Context;

public class ReactorUtils {
    public static final String MDC_KEY_PREFIX = "MDC-";

    public static <T> Mono<T> executeAndEmpty(Runnable runnable) {
        return Mono.fromRunnable((Runnable)runnable).then(Mono.empty());
    }

    public static InputStream toInputStream(Flux<ByteBuffer> byteArrays) {
        return new StreamInputStream(byteArrays.toIterable(1).iterator());
    }

    public static Flux<ByteBuffer> toChunks(InputStream inputStream, int bufferSize) {
        return Flux.generate(sink -> {
            try {
                byte[] buffer = new byte[bufferSize];
                int read = inputStream.read(buffer);
                if (read >= 0) {
                    sink.next((Object)ByteBuffer.wrap(buffer, 0, read));
                } else {
                    sink.complete();
                }
            }
            catch (IOException e) {
                sink.error((Throwable)e);
            }
        }).defaultIfEmpty((Object)ByteBuffer.wrap(new byte[0]));
    }

    private static int byteToInt(ByteBuffer buffer) {
        return buffer.get() & 0xFF;
    }

    public static Consumer<Signal<?>> logOnError(Consumer<Throwable> errorLogStatement) {
        return signal -> {
            if (!signal.isOnError()) {
                return;
            }
            try (Closeable mdc = ReactorUtils.retrieveMDCBuilder(signal).build();){
                errorLogStatement.accept(signal.getThrowable());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static Consumer<Signal<?>> log(Runnable logStatement) {
        return signal -> {
            try (Closeable mdc = ReactorUtils.retrieveMDCBuilder(signal).build();){
                logStatement.run();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static Context context(String keySuffix, MDCBuilder mdcBuilder) {
        return Context.of((Object)ReactorUtils.mdcKey(keySuffix), (Object)mdcBuilder);
    }

    private static String mdcKey(String value) {
        return MDC_KEY_PREFIX + value;
    }

    private static MDCBuilder retrieveMDCBuilder(Signal<?> signal) {
        return signal.getContext().stream().filter(entry -> entry.getKey() instanceof String).filter(entry -> entry.getValue() instanceof MDCBuilder).filter(entry -> ((String)entry.getKey()).startsWith(MDC_KEY_PREFIX)).map(entry -> (MDCBuilder)entry.getValue()).reduce(MDCBuilder.create(), MDCBuilder::addContext);
    }

    private static class StreamInputStream
    extends InputStream {
        private static final int NO_MORE_DATA = -1;
        private final Iterator<ByteBuffer> source;
        private Optional<ByteBuffer> currentItemByteStream;

        StreamInputStream(Iterator<ByteBuffer> source) {
            this.source = source;
            this.currentItemByteStream = Optional.empty();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.nextNonEmptyBuffer().map(buffer -> {
                int toRead = Math.min(len, buffer.remaining());
                buffer.get(b, off, toRead);
                return toRead;
            }).orElse(-1);
        }

        @Override
        public int read() {
            return this.nextNonEmptyBuffer().map(x$0 -> ReactorUtils.byteToInt(x$0)).orElse(-1);
        }

        private Optional<ByteBuffer> nextNonEmptyBuffer() {
            Boolean needsNewBuffer = this.currentItemByteStream.map(buffer -> !buffer.hasRemaining()).orElse(true);
            if (needsNewBuffer.booleanValue()) {
                if (this.source.hasNext()) {
                    this.currentItemByteStream = Optional.of(this.source.next());
                    return this.nextNonEmptyBuffer();
                }
                return Optional.empty();
            }
            return this.currentItemByteStream;
        }
    }
}

