/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util.streams;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;

public class JamesCollectors {
    public static <D> Collector<D, ?, Stream<Collection<D>>> chunker(int chunkSize) {
        return new ChunkCollector(chunkSize);
    }

    public static class ChunkCollector<D>
    implements Collector<D, Multimap<Integer, D>, Stream<Collection<D>>> {
        private final int chunkSize;
        private final AtomicInteger counter;

        private ChunkCollector(int chunkSize) {
            Preconditions.checkArgument((chunkSize > 0 ? 1 : 0) != 0, (Object)"ChunkSize should be strictly positive");
            this.chunkSize = chunkSize;
            this.counter = new AtomicInteger(-1);
        }

        @Override
        public Supplier<Multimap<Integer, D>> supplier() {
            return ArrayListMultimap::create;
        }

        @Override
        public BiConsumer<Multimap<Integer, D>, D> accumulator() {
            return (accumulator, value) -> accumulator.put((Object)(this.counter.incrementAndGet() / this.chunkSize), value);
        }

        @Override
        public BinaryOperator<Multimap<Integer, D>> combiner() {
            return (accumulator1, accumulator2) -> {
                accumulator1.putAll(accumulator2);
                return accumulator1;
            };
        }

        @Override
        public Function<Multimap<Integer, D>, Stream<Collection<D>>> finisher() {
            return accumulator -> accumulator.asMap().values().stream();
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return ImmutableSet.of();
        }
    }
}

