/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.task;

import java.util.Arrays;
import java.util.Optional;
import org.apache.james.task.TaskExecutionDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Task {
    public static final Logger LOGGER = LoggerFactory.getLogger(Task.class);
    public static final String TASK_ID = "taskId";
    public static final String TASK_TYPE = "taskType";
    public static final String TASK_DETAILS = "taskDetails";
    public static final String UNKNOWN = "unknown";

    public static Result combine(Result result1, Result result2) {
        if (result1 == Result.COMPLETED && result2 == Result.COMPLETED) {
            return Result.COMPLETED;
        }
        return Result.PARTIAL;
    }

    public Result run();

    default public String type() {
        return UNKNOWN;
    }

    default public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.empty();
    }

    public static enum Result {
        COMPLETED,
        PARTIAL;


        public Result onComplete(Operation ... operation) {
            try {
                if (this == COMPLETED) {
                    this.run(operation);
                }
                return this;
            }
            catch (Exception e) {
                LOGGER.error("Error while executing operation", (Throwable)e);
                return PARTIAL;
            }
        }

        public Result onFailure(Operation ... operation) {
            if (this == PARTIAL) {
                this.run(operation);
            }
            return this;
        }

        private void run(Operation ... operation) {
            Arrays.stream(operation).forEach(Operation::run);
        }
    }

    public static interface Operation {
        public void run();
    }
}

