/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.activemq;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.SecureRandom;
import javax.jms.JMSException;
import org.apache.activemq.blob.BlobDownloadStrategy;
import org.apache.activemq.blob.BlobTransferPolicy;
import org.apache.activemq.blob.BlobUploadStrategy;
import org.apache.activemq.command.ActiveMQBlobMessage;
import org.apache.commons.io.FileUtils;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.queue.activemq.ActiveMQSupport;

public class FileSystemBlobStrategy
implements BlobUploadStrategy,
BlobDownloadStrategy,
ActiveMQSupport {
    private final FileSystem fileSystem;
    private final BlobTransferPolicy policy;
    private final int splitCount;
    private final Object lock = new Object();
    private static final SecureRandom RANDOM = new SecureRandom();

    public FileSystemBlobStrategy(BlobTransferPolicy policy, FileSystem fileSystem, int splitCount) {
        this.fileSystem = fileSystem;
        this.policy = policy;
        this.splitCount = splitCount;
    }

    public URL uploadFile(ActiveMQBlobMessage message, File file) throws JMSException, IOException {
        return this.uploadStream(message, new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL uploadStream(ActiveMQBlobMessage message, InputStream in) throws JMSException, IOException {
        FileOutputStream out = null;
        try {
            File f = this.getFile(message);
            out = new FileOutputStream(f);
            byte[] buffer = new byte[this.policy.getBufferSize()];
            int c = in.read(buffer);
            while (c != -1) {
                out.write(buffer, 0, c);
                out.flush();
                c = in.read(buffer);
            }
            out.flush();
            URL uRL = f.toURI().toURL();
            return uRL;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFile(ActiveMQBlobMessage message) throws IOException, JMSException {
        File f = this.getFile(message);
        Object object = this.lock;
        synchronized (object) {
            FileUtils.forceDelete((File)f);
        }
    }

    public InputStream getInputStream(ActiveMQBlobMessage message) throws IOException, JMSException {
        return new FileInputStream(this.getFile(message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File getFile(ActiveMQBlobMessage message) throws JMSException, IOException {
        if (message.getURL() != null) {
            return this.fileSystem.getFile(message.getURL().toString());
        }
        String filename = message.getJMSMessageID().replaceAll("[:\\\\/*?|<>]", "_");
        int i = RANDOM.nextInt(this.splitCount) + 1;
        String queueUrl = this.policy.getUploadUrl() + "/" + i;
        File queueF = this.fileSystem.getFile(queueUrl);
        Object object = this.lock;
        synchronized (object) {
            FileUtils.forceMkdir((File)queueF);
        }
        return this.fileSystem.getFile(queueUrl + "/" + filename);
    }
}

