/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver;

import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.hook.AuthHook;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsersRepositoryAuthHook
implements AuthHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(UsersRepositoryAuthHook.class);
    private final UsersRepository users;

    @Inject
    public UsersRepositoryAuthHook(UsersRepository users) {
        this.users = users;
    }

    public HookResult doAuth(SMTPSession session, Username username, String password) {
        try {
            if (this.users.test(username, password)) {
                session.setUsername(username);
                session.setRelayingAllowed(true);
                return HookResult.builder().hookReturnCode(HookReturnCode.ok()).smtpDescription("Authentication Successful").build();
            }
        }
        catch (UsersRepositoryException e) {
            LOGGER.info("Unable to access UsersRepository", (Throwable)e);
        }
        return HookResult.DECLINED;
    }
}

