/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.pop3server.mailbox.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.time.Duration;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.ids.CassandraMessageId;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageDAOV3;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageIdToImapUidDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageMetadata;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.pop3server.mailbox.Pop3MetadataStore;
import org.apache.james.pop3server.mailbox.task.MessageInconsistenciesEntry;
import org.apache.james.task.Task;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MetaDataFixInconsistenciesService {
    static final Inconsistency NO_INCONSISTENCY = new Inconsistency(){

        @Override
        public Mono<Task.Result> fix(Context context, CassandraMessageIdToImapUidDAO imapUidDAO, Pop3MetadataStore pop3MetadataStore) {
            return Mono.just((Object)Task.Result.COMPLETED);
        }

        @Override
        public Mono<Inconsistency> confirm(CassandraMessageIdToImapUidDAO imapUidDAO, Pop3MetadataStore pop3MetadataStore) {
            return Mono.just((Object)this);
        }
    };
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaDataFixInconsistenciesService.class);
    private static final Duration PERIOD = Duration.ofSeconds(1L);
    private final CassandraMessageIdToImapUidDAO imapUidDAO;
    private final Pop3MetadataStore pop3MetadataStore;
    private final CassandraMessageDAOV3 cassandraMessageDAOV3;

    @Inject
    public MetaDataFixInconsistenciesService(CassandraMessageIdToImapUidDAO imapUidDAO, Pop3MetadataStore pop3MetadataStore, CassandraMessageDAOV3 cassandraMessageDAOV3) {
        this.imapUidDAO = imapUidDAO;
        this.pop3MetadataStore = pop3MetadataStore;
        this.cassandraMessageDAOV3 = cassandraMessageDAOV3;
    }

    public Mono<Task.Result> fixInconsistencies(Context context, RunningOptions runningOptions) {
        return Flux.concat((Publisher[])new Publisher[]{this.fixInconsistenciesInPop3MetaDataStore(context, runningOptions), this.fixInconsistenciesInImapUid(context, runningOptions)}).reduce((Object)Task.Result.COMPLETED, Task::combine);
    }

    private Flux<Task.Result> fixInconsistenciesInPop3MetaDataStore(Context context, RunningOptions runningOptions) {
        return Flux.from(this.pop3MetadataStore.listAllEntries()).transform(ReactorUtils.throttle().elements(runningOptions.getMessagesPerSecond()).per(PERIOD).forOperation(fullMetadata -> this.detectStaleEntriesInPop3MetaDataStore((Pop3MetadataStore.FullMetadata)fullMetadata).doOnNext(any -> context.incrementProcessedPop3MetaDataStoreEntries()).flatMap(inconsistency -> inconsistency.confirm(this.imapUidDAO, this.pop3MetadataStore)).flatMap(inconsistency -> inconsistency.fix(context, this.imapUidDAO, this.pop3MetadataStore))));
    }

    private Mono<Inconsistency> detectStaleEntriesInPop3MetaDataStore(Pop3MetadataStore.FullMetadata fullMetadata) {
        CassandraId mailboxId = (CassandraId)fullMetadata.getMailboxId();
        CassandraMessageId messageId = (CassandraMessageId)fullMetadata.getMessageId();
        return this.imapUidDAO.retrieve(messageId, Optional.of(mailboxId)).next().flatMap(any -> Mono.just((Object)NO_INCONSISTENCY)).switchIfEmpty(Mono.just((Object)new StalePOP3EntryConsistency((MailboxId)mailboxId, (MessageId)messageId))).onErrorResume(error -> Mono.just((Object)new FailToDetectInconsistency((MailboxId)mailboxId, (MessageId)messageId)));
    }

    private Flux<Task.Result> fixInconsistenciesInImapUid(Context context, RunningOptions runningOptions) {
        return this.imapUidDAO.retrieveAllMessages().map(CassandraMessageMetadata::getComposedMessageId).transform(ReactorUtils.throttle().elements(runningOptions.getMessagesPerSecond()).per(PERIOD).forOperation(metaData -> this.detectMissingEntriesInPop3MetaDataStore((ComposedMessageIdWithMetaData)metaData).doOnNext(any -> context.incrementProcessedImapUidEntries()).flatMap(inconsistency -> inconsistency.confirm(this.imapUidDAO, this.pop3MetadataStore)).flatMap(inconsistency -> inconsistency.fix(context, this.imapUidDAO, this.pop3MetadataStore))));
    }

    private Mono<Inconsistency> detectMissingEntriesInPop3MetaDataStore(ComposedMessageIdWithMetaData messageFromImapUid) {
        CassandraId mailboxId = (CassandraId)messageFromImapUid.getComposedMessageId().getMailboxId();
        CassandraMessageId messageId = (CassandraMessageId)messageFromImapUid.getComposedMessageId().getMessageId();
        return Flux.from(this.pop3MetadataStore.retrieve((MailboxId)mailboxId, (MessageId)messageId)).next().flatMap(any -> Mono.just((Object)NO_INCONSISTENCY)).switchIfEmpty(Mono.just((Object)new MissingPOP3EntryInconsistency((MailboxId)mailboxId, messageId, this.cassandraMessageDAOV3))).onErrorResume(error -> Mono.just((Object)new FailToDetectInconsistency((MailboxId)mailboxId, (MessageId)messageId)));
    }

    public static class Context {
        private final AtomicLong processedImapUidEntries;
        private final AtomicLong processedPop3MetaDataStoreEntries;
        private final AtomicLong stalePOP3Entries;
        private final AtomicLong missingPOP3Entries;
        private final ConcurrentLinkedDeque<MessageInconsistenciesEntry> fixedInconsistencies;
        private final ConcurrentLinkedDeque<MessageInconsistenciesEntry> errors;

        Context() {
            this(new AtomicLong(), new AtomicLong(), new AtomicLong(), new AtomicLong(), (Collection<MessageInconsistenciesEntry>)ImmutableList.of(), (Collection<MessageInconsistenciesEntry>)ImmutableList.of());
        }

        private Context(AtomicLong processedImapUidEntries, AtomicLong processedPop3MetaDataStoreEntries, AtomicLong stalePOP3Entries, AtomicLong missingPOP3Entries, Collection<MessageInconsistenciesEntry> fixedInconsistencies, Collection<MessageInconsistenciesEntry> errors) {
            this.processedImapUidEntries = processedImapUidEntries;
            this.processedPop3MetaDataStoreEntries = processedPop3MetaDataStoreEntries;
            this.stalePOP3Entries = stalePOP3Entries;
            this.missingPOP3Entries = missingPOP3Entries;
            this.fixedInconsistencies = new ConcurrentLinkedDeque<MessageInconsistenciesEntry>(fixedInconsistencies);
            this.errors = new ConcurrentLinkedDeque<MessageInconsistenciesEntry>(errors);
        }

        void incrementProcessedImapUidEntries() {
            this.processedImapUidEntries.incrementAndGet();
        }

        void incrementProcessedPop3MetaDataStoreEntries() {
            this.processedPop3MetaDataStoreEntries.incrementAndGet();
        }

        void incrementStalePOP3Entries() {
            this.stalePOP3Entries.getAndIncrement();
        }

        void incrementMissingPOP3Entries() {
            this.missingPOP3Entries.incrementAndGet();
        }

        void addFixedInconsistency(MessageInconsistenciesEntry messageInconsistenciesEntry) {
            this.fixedInconsistencies.add(messageInconsistenciesEntry);
        }

        void addErrors(MessageInconsistenciesEntry messageInconsistenciesEntry) {
            this.errors.add(messageInconsistenciesEntry);
        }

        Snapshot snapshot() {
            return new Snapshot(this.processedImapUidEntries.get(), this.processedPop3MetaDataStoreEntries.get(), this.stalePOP3Entries.get(), this.missingPOP3Entries.get(), (ImmutableList<MessageInconsistenciesEntry>)ImmutableList.copyOf(this.fixedInconsistencies), (ImmutableList<MessageInconsistenciesEntry>)ImmutableList.copyOf(this.errors));
        }

        static class Snapshot {
            private final long processedImapUidEntries;
            private final long processedPop3MetaDataStoreEntries;
            private final long stalePOP3Entries;
            private final long missingPOP3Entries;
            private final ImmutableList<MessageInconsistenciesEntry> fixedInconsistencies;
            private final ImmutableList<MessageInconsistenciesEntry> errors;

            public static Builder builder() {
                return new Builder();
            }

            public Snapshot(long processedImapUidEntries, long processedPop3MetaDataStoreEntries, long stalePOP3Entries, long missingPOP3Entries, ImmutableList<MessageInconsistenciesEntry> fixedInconsistencies, ImmutableList<MessageInconsistenciesEntry> errors) {
                this.processedImapUidEntries = processedImapUidEntries;
                this.processedPop3MetaDataStoreEntries = processedPop3MetaDataStoreEntries;
                this.stalePOP3Entries = stalePOP3Entries;
                this.missingPOP3Entries = missingPOP3Entries;
                this.fixedInconsistencies = fixedInconsistencies;
                this.errors = errors;
            }

            public final int hashCode() {
                return Objects.hash(this.processedPop3MetaDataStoreEntries, this.processedImapUidEntries, this.errors, this.fixedInconsistencies);
            }

            public final boolean equals(Object obj) {
                if (obj instanceof Snapshot) {
                    Snapshot snapshot = (Snapshot)obj;
                    return Objects.equals(this.processedPop3MetaDataStoreEntries, snapshot.processedPop3MetaDataStoreEntries) && Objects.equals(this.processedImapUidEntries, snapshot.processedImapUidEntries) && Objects.equals(this.fixedInconsistencies, snapshot.fixedInconsistencies) && Objects.equals(this.errors, snapshot.errors);
                }
                return false;
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("processedPop3MetaDataStoreEntries", this.processedPop3MetaDataStoreEntries).add("processedImapUidEntries", this.processedImapUidEntries).add("stalePOP3Entries", this.stalePOP3Entries).add("missingPOP3Entries", this.missingPOP3Entries).add("fixedInconsistencies", this.fixedInconsistencies).add("errors", this.errors).toString();
            }

            public long getProcessedImapUidEntries() {
                return this.processedImapUidEntries;
            }

            public long getProcessedPop3MetaDataStoreEntries() {
                return this.processedPop3MetaDataStoreEntries;
            }

            public long getStalePOP3Entries() {
                return this.stalePOP3Entries;
            }

            public long getMissingPOP3Entries() {
                return this.missingPOP3Entries;
            }

            public ImmutableList<MessageInconsistenciesEntry> getFixedInconsistencies() {
                return this.fixedInconsistencies;
            }

            public ImmutableList<MessageInconsistenciesEntry> getErrors() {
                return this.errors;
            }

            static class Builder {
                private Optional<Long> processedImapUidEntries = Optional.empty();
                private Optional<Long> processedPop3MetaDataStoreEntries = Optional.empty();
                private Optional<Long> stalePOP3Entries = Optional.empty();
                private Optional<Long> missingPOP3Entries = Optional.empty();
                private ImmutableList.Builder<MessageInconsistenciesEntry> fixedInconsistencies = ImmutableList.builder();
                private ImmutableList.Builder<MessageInconsistenciesEntry> errors = ImmutableList.builder();

                Builder() {
                }

                public Builder processedImapUidEntries(long count) {
                    this.processedImapUidEntries = Optional.of(count);
                    return this;
                }

                public Builder processedPop3MetaDataStoreEntries(long count) {
                    this.processedPop3MetaDataStoreEntries = Optional.of(count);
                    return this;
                }

                public Builder stalePOP3Entries(long count) {
                    this.stalePOP3Entries = Optional.of(count);
                    return this;
                }

                public Builder missingPOP3Entries(long count) {
                    this.missingPOP3Entries = Optional.of(count);
                    return this;
                }

                public Builder addFixedInconsistencies(MessageInconsistenciesEntry messageInconsistenciesEntry) {
                    this.fixedInconsistencies.add((Object)messageInconsistenciesEntry);
                    return this;
                }

                public Builder errors(MessageInconsistenciesEntry messageInconsistenciesEntry) {
                    this.errors.add((Object)messageInconsistenciesEntry);
                    return this;
                }

                public Snapshot build() {
                    return new Snapshot(this.processedImapUidEntries.orElse(0L), this.processedPop3MetaDataStoreEntries.orElse(0L), this.stalePOP3Entries.orElse(0L), this.missingPOP3Entries.orElse(0L), (ImmutableList<MessageInconsistenciesEntry>)this.fixedInconsistencies.build(), (ImmutableList<MessageInconsistenciesEntry>)this.errors.build());
                }
            }
        }
    }

    public static class RunningOptions {
        public static final RunningOptions DEFAULT = new RunningOptions(100);
        private final int messagesPerSecond;

        public static RunningOptions withMessageRatePerSecond(int messageRatePerSecond) {
            return new RunningOptions(messageRatePerSecond);
        }

        @JsonCreator
        public RunningOptions(@JsonProperty(value="messagesPerSecond") int messagesPerSecond) {
            Preconditions.checkArgument((messagesPerSecond > 0 ? 1 : 0) != 0, (Object)"'messagesPerSecond' must be strictly positive");
            this.messagesPerSecond = messagesPerSecond;
        }

        public int getMessagesPerSecond() {
            return this.messagesPerSecond;
        }
    }

    private static class StalePOP3EntryConsistency
    implements Inconsistency {
        private final MailboxId mailboxId;
        private final MessageId messageId;

        private StalePOP3EntryConsistency(MailboxId mailboxId, MessageId messageId) {
            this.mailboxId = mailboxId;
            this.messageId = messageId;
        }

        @Override
        public Mono<Task.Result> fix(Context context, CassandraMessageIdToImapUidDAO imapUidDAO, Pop3MetadataStore pop3MetadataStore) {
            return Mono.from(pop3MetadataStore.remove(this.mailboxId, this.messageId)).doOnSuccess(any -> this.notifySuccess(context)).thenReturn((Object)Task.Result.COMPLETED).onErrorResume(error -> {
                this.notifyFailure(context, (Throwable)error);
                return Mono.just((Object)Task.Result.PARTIAL);
            });
        }

        @Override
        public Mono<Inconsistency> confirm(CassandraMessageIdToImapUidDAO imapUidDAO, Pop3MetadataStore pop3MetadataStore) {
            Mono imapView = imapUidDAO.retrieve((CassandraMessageId)this.messageId, Optional.of((CassandraId)this.mailboxId)).next().map(any -> Presence.PRESENT).switchIfEmpty(Mono.just((Object)((Object)Presence.ABSENT)));
            Mono pop3View = Mono.from(pop3MetadataStore.retrieve(this.mailboxId, this.messageId)).map(any -> Presence.PRESENT).switchIfEmpty(Mono.just((Object)((Object)Presence.ABSENT)));
            return imapView.zipWith(pop3View).map(t2 -> {
                if (t2.getT1() == Presence.ABSENT && t2.getT2() == Presence.PRESENT) {
                    return this;
                }
                return NO_INCONSISTENCY;
            });
        }

        private void notifyFailure(Context context, Throwable e) {
            context.addErrors(MessageInconsistenciesEntry.builder().mailboxId(this.mailboxId.serialize()).messageId(this.messageId.serialize()));
            LOGGER.error("Failed to fix inconsistency for stale POP3 entry: {}", (Object)this.messageId, (Object)e);
        }

        private void notifySuccess(Context context) {
            context.incrementStalePOP3Entries();
            context.addFixedInconsistency(MessageInconsistenciesEntry.builder().mailboxId(this.mailboxId.serialize()).messageId(this.messageId.serialize()));
            LOGGER.info("Inconsistency fixed for stale POP3 entry: {}", (Object)this.messageId);
        }
    }

    private static class MissingPOP3EntryInconsistency
    implements Inconsistency {
        private final MailboxId mailboxId;
        private final CassandraMessageId messageId;
        private final CassandraMessageDAOV3 cassandraMessageDAOV3;

        private MissingPOP3EntryInconsistency(MailboxId mailboxId, CassandraMessageId messageId, CassandraMessageDAOV3 cassandraMessageDAOV3) {
            this.mailboxId = mailboxId;
            this.messageId = messageId;
            this.cassandraMessageDAOV3 = cassandraMessageDAOV3;
        }

        @Override
        public Mono<Task.Result> fix(Context context, CassandraMessageIdToImapUidDAO imapUidDAO, Pop3MetadataStore pop3MetadataStore) {
            return this.buildStatMetadata().flatMap(statMetadata -> Mono.from(pop3MetadataStore.add(this.mailboxId, (Pop3MetadataStore.StatMetadata)statMetadata))).doOnSuccess(any -> this.notifySuccess(context)).thenReturn((Object)Task.Result.COMPLETED).onErrorResume(error -> {
                this.notifyFailure(context, (Throwable)error);
                return Mono.just((Object)Task.Result.PARTIAL);
            });
        }

        @Override
        public Mono<Inconsistency> confirm(CassandraMessageIdToImapUidDAO imapUidDAO, Pop3MetadataStore pop3MetadataStore) {
            Mono imapView = imapUidDAO.retrieve(this.messageId, Optional.of((CassandraId)this.mailboxId)).next().map(any -> Presence.PRESENT).switchIfEmpty(Mono.just((Object)((Object)Presence.ABSENT)));
            Mono pop3View = Mono.from(pop3MetadataStore.retrieve(this.mailboxId, (MessageId)this.messageId)).map(any -> Presence.PRESENT).switchIfEmpty(Mono.just((Object)((Object)Presence.ABSENT)));
            return imapView.zipWith(pop3View).map(t2 -> {
                if (t2.getT1() == Presence.PRESENT && t2.getT2() == Presence.ABSENT) {
                    return this;
                }
                return NO_INCONSISTENCY;
            });
        }

        private Mono<Pop3MetadataStore.StatMetadata> buildStatMetadata() {
            return this.cassandraMessageDAOV3.retrieveMessage(this.messageId, MessageMapper.FetchType.METADATA).switchIfEmpty(Mono.error((Throwable)new MailboxException("Message not found: " + String.valueOf(this.messageId)))).map(messageRepresentation -> new Pop3MetadataStore.StatMetadata((MessageId)this.messageId, messageRepresentation.getSize()));
        }

        private void notifyFailure(Context context, Throwable e) {
            context.addErrors(MessageInconsistenciesEntry.builder().mailboxId(this.mailboxId.serialize()).messageId(this.messageId.serialize()));
            LOGGER.error("Failed to fix inconsistency for missing POP3 entry: {}", (Object)this.messageId, (Object)e);
        }

        private void notifySuccess(Context context) {
            context.incrementMissingPOP3Entries();
            context.addFixedInconsistency(MessageInconsistenciesEntry.builder().mailboxId(this.mailboxId.serialize()).messageId(this.messageId.serialize()));
            LOGGER.info("Inconsistency fixed for missing POP3 entry: {}", (Object)this.messageId);
        }
    }

    private static class FailToDetectInconsistency
    implements Inconsistency {
        private final MailboxId mailboxId;
        private final MessageId messageId;

        private FailToDetectInconsistency(MailboxId mailboxId, MessageId messageId) {
            this.mailboxId = mailboxId;
            this.messageId = messageId;
        }

        @Override
        public Mono<Task.Result> fix(Context context, CassandraMessageIdToImapUidDAO imapUidDAO, Pop3MetadataStore pop3MetadataStore) {
            context.addErrors(MessageInconsistenciesEntry.builder().mailboxId(this.mailboxId.serialize()).messageId(this.messageId.serialize()));
            LOGGER.error("Failed to detect inconsistency: {}", (Object)this.messageId);
            return Mono.just((Object)Task.Result.PARTIAL);
        }

        @Override
        public Mono<Inconsistency> confirm(CassandraMessageIdToImapUidDAO imapUidDAO, Pop3MetadataStore pop3MetadataStore) {
            return Mono.just((Object)this);
        }
    }

    static interface Inconsistency {
        public Mono<Task.Result> fix(Context var1, CassandraMessageIdToImapUidDAO var2, Pop3MetadataStore var3);

        public Mono<Inconsistency> confirm(CassandraMessageIdToImapUidDAO var1, Pop3MetadataStore var2);
    }

    private static enum Presence {
        PRESENT,
        ABSENT;

    }
}

