/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.pop3server.mailbox.task;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class MessageInconsistenciesEntry {
    private final String mailboxId;
    private final String messageId;

    public static Builder.RequireMailboxId builder() {
        return mailboxId -> messageId -> new MessageInconsistenciesEntry(mailboxId, messageId);
    }

    MessageInconsistenciesEntry(@JsonProperty(value="mailboxId") String mailboxId, @JsonProperty(value="messageId") String messageId) {
        this.mailboxId = mailboxId;
        this.messageId = messageId;
    }

    @JsonProperty(value="mailboxId")
    public String getMailboxId() {
        return this.mailboxId;
    }

    @JsonProperty(value="messageId")
    public String getMessageId() {
        return this.messageId;
    }

    public final boolean equals(Object o) {
        if (o instanceof MessageInconsistenciesEntry) {
            MessageInconsistenciesEntry that = (MessageInconsistenciesEntry)o;
            return Objects.equals(this.mailboxId, that.mailboxId) && Objects.equals(this.messageId, that.messageId);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.mailboxId, this.messageId);
    }

    public static interface Builder {

        @FunctionalInterface
        public static interface RequireMessageUid {
            public MessageInconsistenciesEntry messageUid(Long var1);
        }

        @FunctionalInterface
        public static interface RequireMessageId {
            public MessageInconsistenciesEntry messageId(String var1);
        }

        @FunctionalInterface
        public static interface RequireMailboxId {
            public RequireMessageId mailboxId(String var1);
        }
    }
}

