/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.pop3server.mailbox;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.reactivestreams.Publisher;

public interface Pop3MetadataStore {
    public Publisher<StatMetadata> stat(MailboxId var1);

    public Publisher<FullMetadata> listAllEntries();

    public Publisher<FullMetadata> retrieve(MailboxId var1, MessageId var2);

    public Publisher<Void> add(MailboxId var1, StatMetadata var2);

    public Publisher<Void> remove(MailboxId var1, MessageId var2);

    public Publisher<Void> clear(MailboxId var1);

    public static class FullMetadata
    extends StatMetadata {
        private final MailboxId mailboxId;

        public FullMetadata(MailboxId mailboxId, MessageId messageId, long size) {
            super(messageId, size);
            this.mailboxId = mailboxId;
        }

        public FullMetadata(MailboxId mailboxId, StatMetadata statMetadata) {
            super(statMetadata.getMessageId(), statMetadata.getSize());
            this.mailboxId = mailboxId;
        }

        public MailboxId getMailboxId() {
            return this.mailboxId;
        }

        @Override
        public final boolean equals(Object o) {
            if (o instanceof FullMetadata) {
                FullMetadata that = (FullMetadata)o;
                return this.getSize() == that.getSize() && Objects.equals(this.getMessageId(), that.getMessageId()) && Objects.equals(this.mailboxId, that.mailboxId);
            }
            return false;
        }

        @Override
        public final int hashCode() {
            return Objects.hash(this.mailboxId, this.getMessageId(), this.getSize());
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("mailboxId", (Object)this.mailboxId).add("messageId", (Object)this.getMessageId()).add("size", this.getSize()).toString();
        }
    }

    public static class StatMetadata {
        private final MessageId messageId;
        private final long size;

        public StatMetadata(MessageId messageId, long size) {
            this.messageId = messageId;
            this.size = size;
        }

        public MessageId getMessageId() {
            return this.messageId;
        }

        public long getSize() {
            return this.size;
        }

        public boolean equals(Object o) {
            if (o instanceof StatMetadata) {
                StatMetadata that = (StatMetadata)o;
                return this.size == that.size && Objects.equals(this.messageId, that.messageId);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.messageId, this.size);
        }

        public String toString() {
            return "StatMetadata{messageId=" + String.valueOf(this.messageId) + ", size=" + this.size + "}";
        }
    }
}

