/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.pop3server.mailbox;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.DeleteResult;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.pop3server.mailbox.MailboxAdapterFactory;
import org.apache.james.pop3server.mailbox.Pop3MetadataStore;
import org.apache.james.protocols.pop3.mailbox.Mailbox;
import org.apache.james.protocols.pop3.mailbox.MessageMetaData;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DistributedMailboxAdapter
implements Mailbox {
    private static final Logger LOGGER = LoggerFactory.getLogger(DistributedMailboxAdapter.class);
    private final Pop3MetadataStore metadataStore;
    private final MessageIdManager messageIdManager;
    private final MessageId.Factory messageIdFactory;
    private final MailboxManager mailboxManager;
    private final MailboxSession session;
    private final MessageManager mailbox;

    @Inject
    public DistributedMailboxAdapter(Pop3MetadataStore metadataStore, MessageIdManager messageIdManager, MessageId.Factory messageIdFactory, @Named(value="mailboxmanager") MailboxManager mailboxManager, MailboxSession session, MessageManager mailbox) {
        this.metadataStore = metadataStore;
        this.messageIdManager = messageIdManager;
        this.messageIdFactory = messageIdFactory;
        this.mailboxManager = mailboxManager;
        this.session = session;
        this.mailbox = mailbox;
    }

    public InputStream getMessage(String uid) throws IOException {
        try {
            MessageId messageId = this.messageIdFactory.fromString(uid);
            Iterator messages = this.messageIdManager.getMessage(messageId, FetchGroup.FULL_CONTENT, this.session).iterator();
            if (messages.hasNext()) {
                return ((MessageResult)messages.next()).getFullContent().getInputStream();
            }
            LOGGER.warn("Removing {} from {} POP3 projection for user {} at it is not backed by a MailboxMessage", new Object[]{uid, this.mailbox.getId().serialize(), this.session.getUser().asString()});
            Mono.from(this.metadataStore.remove(this.mailbox.getId(), messageId)).block();
            throw new IOException("Message does not exist for uid " + uid);
        }
        catch (MailboxException e) {
            throw new IOException("Unable to retrieve message body for uid " + uid, e);
        }
    }

    public List<MessageMetaData> getMessages() {
        return (List)Flux.from(this.metadataStore.stat(this.mailbox.getId())).map(message -> new MessageMetaData(message.getMessageId().serialize(), message.getSize())).collect(ImmutableList.toImmutableList()).block();
    }

    public void remove(String ... uids) {
        ImmutableList messageIds = (ImmutableList)Stream.of(uids).map(arg_0 -> ((MessageId.Factory)this.messageIdFactory).fromString(arg_0)).collect(ImmutableList.toImmutableList());
        Mono.from((Publisher)this.messageIdManager.deleteReactive((List)messageIds, (List)ImmutableList.of((Object)this.mailbox.getId()), this.session)).flatMapIterable(DeleteResult::getDestroyed).concatMap(messageId -> Mono.from(this.metadataStore.remove(this.mailbox.getId(), (MessageId)messageId))).blockLast();
    }

    public String getIdentifier() throws IOException {
        try {
            this.mailboxManager.startProcessingRequest(this.session);
            long validity = this.mailbox.getMailboxEntity().getUidValidity().asLong();
            String string = Long.toString(validity);
            return string;
        }
        catch (MailboxException e) {
            throw new IOException("Unable to retrieve indentifier for mailbox", e);
        }
        finally {
            this.mailboxManager.endProcessingRequest(this.session);
        }
    }

    public void close() {
        this.mailboxManager.endProcessingRequest(this.session);
    }

    public static class Factory
    implements MailboxAdapterFactory {
        private final Pop3MetadataStore metadataStore;
        private final MessageIdManager messageIdManager;
        private final MessageId.Factory messageIdFactory;
        private final MailboxManager mailboxManager;

        @Inject
        public Factory(Pop3MetadataStore metadataStore, MessageIdManager messageIdManager, MessageId.Factory messageIdFactory, @Named(value="mailboxmanager") MailboxManager mailboxManager) {
            this.metadataStore = metadataStore;
            this.messageIdManager = messageIdManager;
            this.messageIdFactory = messageIdFactory;
            this.mailboxManager = mailboxManager;
        }

        public Mailbox create(MessageManager manager, MailboxSession session) {
            return new DistributedMailboxAdapter(this.metadataStore, this.messageIdManager, this.messageIdFactory, this.mailboxManager, session, manager);
        }
    }
}

