/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jwt;

import com.google.common.collect.ImmutableList;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.JwtParserBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.Locator;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.io.CompressionAlgorithm;
import io.jsonwebtoken.lang.NestedCollection;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.jwt.DefaultPublicKeyProvider;
import org.apache.james.jwt.JwtConfiguration;
import org.apache.james.jwt.PublicKeyProvider;
import org.apache.james.jwt.PublicKeyReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtTokenVerifier {
    static boolean allowZipJWT = Optional.ofNullable(System.getProperty("james.jwt.zip.allow")).map(Boolean::parseBoolean).orElse(false);
    private static final List<SecureCompressionAlgorithm> SECURE_COMPRESSION_ALGORITHMS = Jwts.ZIP.get().values().stream().map(c -> new SecureCompressionAlgorithm(c.getId(), (CompressionAlgorithm)c)).toList();
    private static final Logger LOGGER = LoggerFactory.getLogger(JwtTokenVerifier.class);
    private final JwtParser kidJwtParser = this.toImmutableJwtParser((Locator<Key>)((Locator)jwtHeaders -> {
        String kid = Objects.requireNonNull((String)jwtHeaders.get((Object)"kid"));
        return pubKeyProvider.get(kid).orElse(null);
    }));
    private final List<JwtParser> jwtParsers;

    public static JwtTokenVerifier create(JwtConfiguration jwtConfiguration) {
        DefaultPublicKeyProvider publicKeyProvider = new DefaultPublicKeyProvider(jwtConfiguration, new PublicKeyReader());
        return new JwtTokenVerifier(publicKeyProvider);
    }

    public JwtTokenVerifier(PublicKeyProvider pubKeyProvider) {
        this.jwtParsers = (List)pubKeyProvider.get().stream().map(key -> this.toImmutableJwtParser((Locator<Key>)((Locator)jwtHeaders -> key))).collect(ImmutableList.toImmutableList());
    }

    public Optional<String> verifyAndExtractLogin(String token) {
        return this.verifyAndExtractClaim(token, "sub", String.class).filter(s -> !s.isEmpty());
    }

    public <T> Optional<T> verifyAndExtractClaim(String token, String claimName, Class<T> returnType) {
        try {
            return this.verifyAndExtractClaim(token, claimName, returnType, this.kidJwtParser);
        }
        catch (NullPointerException npe) {
            return this.jwtParsers.stream().flatMap(parser -> this.verifyAndExtractClaim(token, claimName, returnType, (JwtParser)parser).stream()).findFirst();
        }
    }

    private <T> Optional<T> verifyAndExtractClaim(String token, String claimName, Class<T> returnType, JwtParser parser) {
        try {
            Jws jws = parser.parseSignedClaims((CharSequence)token);
            Object claim = ((Claims)jws.getPayload()).get(claimName, returnType);
            if (claim == null) {
                throw new MalformedJwtException("'" + claimName + "' field in token is mandatory");
            }
            return Optional.of(claim);
        }
        catch (JwtException e) {
            LOGGER.info("Failed Jwt verification", (Throwable)e);
            return Optional.empty();
        }
    }

    public boolean hasAttribute(String attributeName, Object expectedValue, String token) {
        try {
            return this.verifyAndExtractClaim(token, attributeName, Object.class).map(expectedValue::equals).orElse(false);
        }
        catch (JwtException e) {
            LOGGER.info("Jwt validation failed for claim {} to {}", new Object[]{attributeName, expectedValue, e});
            return false;
        }
    }

    private JwtParser toImmutableJwtParser(Locator<Key> keyLocator) {
        return ((JwtParserBuilder)((NestedCollection)Jwts.parser().keyLocator(keyLocator).zip().add(SECURE_COMPRESSION_ALGORITHMS)).and()).build();
    }

    private static class SecureCompressionAlgorithm
    implements CompressionAlgorithm {
        String id;
        CompressionAlgorithm delegate;

        public SecureCompressionAlgorithm(String id, CompressionAlgorithm delegate) {
            this.id = id;
            this.delegate = delegate;
        }

        private void validate() {
            if (!allowZipJWT) {
                throw new RuntimeException("Rejecting a ZIP JWT. Usage of ZIPPED JWT can result in excessive memory usage with malicious JWT tokens. To activate support for ZIPPedJWT please run James with the -Djames.jwt.zip.allow=true system property.");
            }
        }

        public String getId() {
            return this.id;
        }

        public OutputStream compress(OutputStream out) {
            this.validate();
            return this.delegate.compress(out);
        }

        public InputStream decompress(InputStream in) {
            this.validate();
            return this.delegate.decompress(in);
        }
    }

    public static interface Factory {
        public JwtTokenVerifier create();
    }
}

