/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.message;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.james.mime4j.decoder.CodecUtil;
import org.apache.james.mime4j.message.AbstractBody;
import org.apache.james.mime4j.message.BinaryBody;
import org.apache.james.mime4j.message.Entity;
import org.apache.james.mime4j.message.storage.TempFile;
import org.apache.james.mime4j.message.storage.TempPath;
import org.apache.james.mime4j.message.storage.TempStorage;

class TempFileBinaryBody
extends AbstractBody
implements BinaryBody {
    private Entity parent = null;
    private TempFile tempFile = null;

    public TempFileBinaryBody(InputStream is) throws IOException {
        TempPath tempPath = TempStorage.getInstance().getRootTempPath();
        this.tempFile = tempPath.createTempFile("attachment", ".bin");
        OutputStream out = this.tempFile.getOutputStream();
        CodecUtil.copy(is, out);
        out.close();
    }

    public Entity getParent() {
        return this.parent;
    }

    public void setParent(Entity parent) {
        this.parent = parent;
    }

    public InputStream getInputStream() throws IOException {
        return this.tempFile.getInputStream();
    }

    public void writeTo(OutputStream out, int mode) throws IOException {
        InputStream inputStream = this.getInputStream();
        CodecUtil.copy(inputStream, out);
    }
}

