/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.message;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.james.mime4j.message.AbstractBody;
import org.apache.james.mime4j.message.TextBody;
import org.apache.james.mime4j.util.CharsetUtil;
import org.apache.james.mime4j.util.TempFile;
import org.apache.james.mime4j.util.TempPath;
import org.apache.james.mime4j.util.TempStorage;

class TempFileTextBody
extends AbstractBody
implements TextBody {
    private static Log log = LogFactory.getLog((Class)TempFileTextBody.class);
    private String mimeCharset = null;
    private TempFile tempFile = null;

    public TempFileTextBody(InputStream is) throws IOException {
        this(is, null);
    }

    public TempFileTextBody(InputStream is, String mimeCharset) throws IOException {
        this.mimeCharset = mimeCharset;
        TempPath tempPath = TempStorage.getInstance().getRootTempPath();
        this.tempFile = tempPath.createTempFile("attachment", ".txt");
        OutputStream out = this.tempFile.getOutputStream();
        IOUtils.copy((InputStream)is, (OutputStream)out);
        out.close();
    }

    public Reader getReader() throws UnsupportedEncodingException, IOException {
        String javaCharset = null;
        if (this.mimeCharset != null) {
            javaCharset = CharsetUtil.toJavaCharset(this.mimeCharset);
        }
        if (javaCharset == null) {
            javaCharset = "ISO-8859-1";
            if (log.isWarnEnabled()) {
                if (this.mimeCharset == null) {
                    log.warn((Object)("No MIME charset specified. Using " + javaCharset + " instead."));
                } else {
                    log.warn((Object)("MIME charset '" + this.mimeCharset + "' has no " + "corresponding Java charset. Using " + javaCharset + " instead."));
                }
            }
        }
        return new InputStreamReader(this.tempFile.getInputStream(), javaCharset);
    }

    public void writeTo(OutputStream out) throws IOException {
        IOUtils.copy((InputStream)this.tempFile.getInputStream(), (OutputStream)out);
    }
}

