/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.utils.search;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.CharBuffer;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.List;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.stream.EntityState;
import org.apache.james.mime4j.stream.MimeConfig;
import org.apache.james.mime4j.stream.MimeTokenStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageMatcher {
    private final Logger logger;
    private final List<CharSequence> searchContents;
    private final List<String> contentTypes;
    private final boolean isCaseInsensitive;
    private final boolean includeHeaders;
    private final boolean ignoringMime;

    public static MessageMatcherBuilder builder() {
        return new MessageMatcherBuilder();
    }

    private MessageMatcher(List<CharSequence> searchContents, boolean isCaseInsensitive, boolean includeHeaders, boolean ignoringMime, List<String> contentTypes, Logger logger) {
        this.contentTypes = ImmutableList.copyOf(contentTypes);
        this.searchContents = ImmutableList.copyOf(searchContents);
        this.isCaseInsensitive = isCaseInsensitive;
        this.includeHeaders = includeHeaders;
        this.ignoringMime = ignoringMime;
        this.logger = logger;
    }

    public boolean messageMatches(InputStream input) throws IOException, MimeException {
        for (CharSequence charSequence : this.searchContents) {
            if (charSequence == null) continue;
            CharBuffer buffer = this.createBuffer(charSequence);
            if (!(this.ignoringMime ? !this.isFoundIn(new InputStreamReader(input), buffer) : !this.matchBufferInMailBeingMimeAware(input, buffer))) continue;
            return false;
        }
        return true;
    }

    private boolean matchBufferInMailBeingMimeAware(InputStream input, CharBuffer buffer) throws IOException, MimeException {
        try {
            MimeConfig config = MimeConfig.custom().setMaxLineLen(-1).setMaxHeaderLen(-1).build();
            MimeTokenStream parser = new MimeTokenStream(config);
            parser.parse(input);
            while (parser.next() != EntityState.T_END_OF_STREAM) {
                EntityState state = parser.getState();
                switch (state) {
                    case T_PREAMBLE: 
                    case T_EPILOGUE: 
                    case T_BODY: {
                        if (!this.contentTypes.isEmpty() && !this.contentTypes.contains(parser.getBodyDescriptor().getMimeType()) || !this.checkBody(buffer, parser)) break;
                        return true;
                    }
                    case T_FIELD: {
                        if (!this.includeHeaders || !this.checkHeader(buffer, parser)) break;
                        return true;
                    }
                }
            }
        }
        catch (IllegalCharsetNameException e) {
            this.handle(e);
        }
        catch (UnsupportedCharsetException e) {
            this.handle(e);
        }
        catch (IllegalStateException e) {
            this.handle(e);
        }
        return false;
    }

    private boolean checkHeader(CharBuffer buffer, MimeTokenStream parser) throws IOException {
        String value = parser.getField().getBody();
        StringReader reader = new StringReader(value);
        return this.isFoundIn(reader, buffer);
    }

    private boolean checkBody(CharBuffer buffer, MimeTokenStream parser) throws IOException {
        Reader reader = parser.getReader();
        return this.isFoundIn(reader, buffer);
    }

    private CharBuffer createBuffer(CharSequence searchContent) {
        CharBuffer buffer;
        if (this.isCaseInsensitive) {
            int length = searchContent.length();
            buffer = CharBuffer.allocate(length);
            for (int i = 0; i < length; ++i) {
                char next = searchContent.charAt(i);
                char upperCase = Character.toUpperCase(next);
                buffer.put(upperCase);
            }
            buffer.flip();
        } else {
            buffer = CharBuffer.wrap(searchContent);
        }
        return buffer;
    }

    protected void handle(Exception e) throws IOException, MimeException {
        this.logger.warn("Cannot read MIME body.");
        this.logger.debug("Failed to read body.", (Throwable)e);
    }

    public boolean isFoundIn(Reader reader, CharBuffer buffer) throws IOException {
        int read;
        while ((read = reader.read()) != -1) {
            if (!this.matches(buffer, this.computeNextChar(this.isCaseInsensitive, (char)read))) continue;
            return true;
        }
        return false;
    }

    private char computeNextChar(boolean isCaseInsensitive, char read) {
        if (isCaseInsensitive) {
            return Character.toUpperCase(read);
        }
        return read;
    }

    private boolean matches(CharBuffer buffer, char next) {
        if (buffer.hasRemaining()) {
            boolean partialMatch = buffer.position() > 0;
            char matching = buffer.get();
            if (next != matching) {
                buffer.rewind();
                if (partialMatch) {
                    return this.matches(buffer, next);
                }
            }
        } else {
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MessageMatcherBuilder {
        private List<CharSequence> searchContents = ImmutableList.of();
        private List<String> contentTypes = ImmutableList.of();
        private boolean isCaseInsensitive = false;
        private boolean includeHeaders = false;
        private boolean ignoringMime = false;
        private Logger logger = LoggerFactory.getLogger(MessageMatcher.class);

        public MessageMatcherBuilder searchContents(List<CharSequence> searchContents) {
            this.searchContents = searchContents;
            return this;
        }

        public MessageMatcherBuilder contentTypes(List<String> contentTypes) {
            this.contentTypes = contentTypes;
            return this;
        }

        public MessageMatcherBuilder caseInsensitive(boolean isCaseInsensitive) {
            this.isCaseInsensitive = isCaseInsensitive;
            return this;
        }

        public MessageMatcherBuilder includeHeaders(boolean includeHeaders) {
            this.includeHeaders = includeHeaders;
            return this;
        }

        public MessageMatcherBuilder logger(Logger logger) {
            this.logger = logger;
            return this;
        }

        public MessageMatcherBuilder ignoringMime(boolean ignoringMime) {
            this.ignoringMime = ignoringMime;
            return this;
        }

        public MessageMatcher build() {
            return new MessageMatcher(this.searchContents, this.isCaseInsensitive, this.includeHeaders, this.ignoringMime, this.contentTypes, this.logger);
        }
    }
}

