/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.spamassassin;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.james.core.MailAddress;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.spamassassin.SpamAssassinConfiguration;
import org.apache.james.spamassassin.SpamAssassinInvoker;
import org.apache.james.spamassassin.SpamAssassinResult;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.util.AuditTrail;
import org.apache.james.util.Host;
import org.apache.mailet.Attribute;
import org.apache.mailet.Mail;
import org.apache.mailet.PerRecipientHeaders;
import org.apache.mailet.base.GenericMailet;

public class SpamAssassin
extends GenericMailet {
    private final MetricFactory metricFactory;
    private final UsersRepository usersRepository;
    private final Host spamAssassinHost;

    @Inject
    public SpamAssassin(MetricFactory metricFactory, UsersRepository usersRepository, SpamAssassinConfiguration spamAssassinConfiguration) {
        this.metricFactory = metricFactory;
        this.usersRepository = usersRepository;
        this.spamAssassinHost = spamAssassinConfiguration.getHost();
    }

    public void service(Mail mail) throws MessagingException {
        MimeMessage message = mail.getMessage();
        SpamAssassinInvoker sa = new SpamAssassinInvoker(this.metricFactory, this.spamAssassinHost.getHostName(), this.spamAssassinHost.getPort());
        mail.getRecipients().forEach(Throwing.consumer(recipient -> this.querySpamAssassin(mail, message, sa, (MailAddress)recipient)).sneakyThrow());
    }

    private void querySpamAssassin(Mail mail, MimeMessage message, SpamAssassinInvoker sa, MailAddress recipient) throws MessagingException, UsersRepositoryException {
        SpamAssassinResult result = sa.scanMail(message, this.usersRepository.getUsername(recipient));
        AuditTrail.entry().protocol("mailetcontainer").action("SpamAssassin").parameters((Supplier)Throwing.supplier(() -> ImmutableMap.of((Object)"mailId", (Object)mail.getName(), (Object)"mimeMessageId", (Object)Optional.ofNullable(mail.getMessage()).map(Throwing.function(MimeMessage::getMessageID)).orElse(""), (Object)"sender", (Object)mail.getMaybeSender().asString(), (Object)"recipient", (Object)recipient.asString(), (Object)"spamAssassinHits", (Object)result.getHits(), (Object)"status", (Object)result.getStatus().name()))).log("Mail scanned with SpamAssassin.");
        for (Attribute attribute : result.getHeadersAsAttributes()) {
            mail.addSpecificHeaderForRecipient(PerRecipientHeaders.Header.builder().name(attribute.getName().asString()).value((String)attribute.getValue().value()).build(), recipient);
        }
    }

    public String getMailetInfo() {
        return "Checks message against SpamAssassin";
    }
}

