/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.spamassassin;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;

public class SpamAssassinResult {
    public static final AttributeName STATUS_MAIL = AttributeName.of((String)"org.apache.james.spamassassin.status");
    public static final AttributeName FLAG_MAIL = AttributeName.of((String)"org.apache.james.spamassassin.flag");
    public static final String NO_RESULT = "?";
    private final SpamStatus status;
    private final String hits;
    private final String requiredHits;
    private final List<Attribute> headersAsAttributes;

    public static SpamAssassinResult empty() {
        return SpamAssassinResult.asHam().hits(NO_RESULT).requiredHits(NO_RESULT).build();
    }

    public static Builder asSpam() {
        return new Builder(true);
    }

    public static Builder asHam() {
        return new Builder(false);
    }

    private SpamAssassinResult(SpamStatus status, String hits, String requiredHits, List<Attribute> headersAsAttributes) {
        this.status = status;
        this.hits = hits;
        this.requiredHits = requiredHits;
        this.headersAsAttributes = headersAsAttributes;
    }

    public String getHits() {
        return this.hits;
    }

    public String getRequiredHits() {
        return this.requiredHits;
    }

    public List<Attribute> getHeadersAsAttributes() {
        return this.headersAsAttributes;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("status", (Object)this.status).add("hits", (Object)this.hits).add("requiredHits", (Object)this.requiredHits).add("headersAsAttributes", this.headersAsAttributes).toString();
    }

    static enum SpamStatus {
        Spam,
        Ham;

    }

    public static class Builder {
        private String hits;
        private String requiredHits;
        private final boolean isSpam;

        private Builder(boolean isSpam) {
            this.isSpam = isSpam;
        }

        public Builder hits(String hits) {
            this.hits = hits;
            return this;
        }

        public Builder requiredHits(String requiredHits) {
            this.requiredHits = requiredHits;
            return this;
        }

        public SpamAssassinResult build() {
            Preconditions.checkNotNull((Object)this.hits);
            Preconditions.checkNotNull((Object)this.requiredHits);
            ImmutableList.Builder headersAsAttributes = ImmutableList.builder();
            if (this.isSpam) {
                headersAsAttributes.add((Object)new Attribute(FLAG_MAIL, AttributeValue.of((String)"YES")));
                headersAsAttributes.add((Object)new Attribute(STATUS_MAIL, AttributeValue.of((String)("Yes, hits=" + this.hits + " required=" + this.requiredHits))));
            } else {
                headersAsAttributes.add((Object)new Attribute(FLAG_MAIL, AttributeValue.of((String)"NO")));
                headersAsAttributes.add((Object)new Attribute(STATUS_MAIL, AttributeValue.of((String)("No, hits=" + this.hits + " required=" + this.requiredHits))));
            }
            SpamStatus status = this.isSpam ? SpamStatus.Spam : SpamStatus.Ham;
            return new SpamAssassinResult(status, this.hits, this.requiredHits, (List)headersAsAttributes.build());
        }
    }
}

