/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rspamd.task;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Clock;
import java.util.Optional;
import org.apache.james.json.DTOModule;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.rspamd.client.RspamdClientConfiguration;
import org.apache.james.rspamd.client.RspamdHttpClient;
import org.apache.james.rspamd.task.FeedSpamToRspamdTask;
import org.apache.james.rspamd.task.RunningOptions;
import org.apache.james.server.task.json.dto.TaskDTO;
import org.apache.james.server.task.json.dto.TaskDTOModule;
import org.apache.james.user.api.UsersRepository;

public class FeedSpamToRspamdTaskDTO
implements TaskDTO {
    private final String type;
    private final Long periodInSecond;
    private final int messagesPerSecond;
    private final double samplingProbability;
    private final Optional<Boolean> classifiedAsSpam;
    private final int rspamdTimeoutInSeconds;

    public static TaskDTOModule<FeedSpamToRspamdTask, FeedSpamToRspamdTaskDTO> module(MailboxManager mailboxManager, UsersRepository usersRepository, MessageIdManager messageIdManager, MailboxSessionMapperFactory mapperFactory, RspamdHttpClient rspamdHttpClient, Clock clock, RspamdClientConfiguration rspamdConfiguration) {
        return (TaskDTOModule)DTOModule.forDomainObject(FeedSpamToRspamdTask.class).convertToDTO(FeedSpamToRspamdTaskDTO.class).toDomainObjectConverter(dto -> new FeedSpamToRspamdTask(mailboxManager, usersRepository, messageIdManager, mapperFactory, rspamdHttpClient, new RunningOptions(Optional.ofNullable(dto.getPeriodInSecond()), dto.getMessagesPerSecond(), dto.getSamplingProbability(), dto.getClassifiedAsSpam()), clock, rspamdConfiguration)).toDTOConverter((domain, type) -> new FeedSpamToRspamdTaskDTO(type, domain.getRunningOptions().getPeriodInSecond().orElse(null), domain.getRunningOptions().getMessagesPerSecond(), (int)domain.getRunningOptions().getRspamdTimeout().toSeconds(), domain.getRunningOptions().getSamplingProbability(), domain.getRunningOptions().getClassifiedAsSpam())).typeName(FeedSpamToRspamdTask.TASK_TYPE.asString()).withFactory(TaskDTOModule::new);
    }

    public FeedSpamToRspamdTaskDTO(@JsonProperty(value="type") String type, @JsonProperty(value="periodInSecond") Long periodInSecond, @JsonProperty(value="messagesPerSecond") int messagesPerSecond, @JsonProperty(value="rspamdTimeoutInSeconds") int rspamdTimeoutInSeconds, @JsonProperty(value="samplingProbability") double samplingProbability, @JsonProperty(value="classifiedAsSpam") Optional<Boolean> classifiedAsSpam) {
        this.type = type;
        this.periodInSecond = periodInSecond;
        this.messagesPerSecond = messagesPerSecond;
        this.rspamdTimeoutInSeconds = rspamdTimeoutInSeconds;
        this.samplingProbability = samplingProbability;
        this.classifiedAsSpam = classifiedAsSpam;
    }

    public String getType() {
        return this.type;
    }

    public Long getPeriodInSecond() {
        return this.periodInSecond;
    }

    public int getMessagesPerSecond() {
        return this.messagesPerSecond;
    }

    public int getRspamdTimeoutInSeconds() {
        return this.rspamdTimeoutInSeconds;
    }

    public double getSamplingProbability() {
        return this.samplingProbability;
    }

    public Optional<Boolean> getClassifiedAsSpam() {
        return this.classifiedAsSpam;
    }
}

