/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rspamd;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import jakarta.inject.Inject;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.core.MailAddress;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.rspamd.client.RspamdClientConfiguration;
import org.apache.james.rspamd.client.RspamdHttpClient;
import org.apache.james.rspamd.model.AnalysisResult;
import org.apache.james.util.AuditTrail;
import org.apache.james.util.ReactorUtils;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.PerRecipientHeaders;
import org.apache.mailet.ProcessingState;
import org.apache.mailet.base.GenericMailet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RspamdScanner
extends GenericMailet {
    private static final Logger LOGGER = LoggerFactory.getLogger(RspamdScanner.class);
    public static final AttributeName FLAG_MAIL = AttributeName.of((String)"org.apache.james.rspamd.flag");
    public static final AttributeName STATUS_MAIL = AttributeName.of((String)"org.apache.james.rspamd.status");
    private final RspamdClientConfiguration configuration;
    private RspamdHttpClient rspamdHttpClient;
    private boolean rewriteSubject;
    private boolean perUserBayes;
    private Optional<String> virusProcessor;
    private Optional<String> rejectSpamProcessor;

    @Inject
    public RspamdScanner(RspamdHttpClient rspamdHttpClient, RspamdClientConfiguration configuration) {
        this.rspamdHttpClient = rspamdHttpClient;
        this.configuration = configuration;
        this.perUserBayes = configuration.usePerUserBayes();
    }

    public void init() {
        this.rewriteSubject = this.getInitParameter("rewriteSubject", false);
        this.virusProcessor = this.getInitParameterAsOptional("virusProcessor");
        this.rejectSpamProcessor = this.getInitParameterAsOptional("rejectSpamProcessor");
        this.perUserBayes = this.getInitParameter("perUserBayes", this.configuration.usePerUserBayes());
        this.getInitParameterAsOptional("rspamdUrl").ifPresent(Throwing.consumer(url -> {
            this.rspamdHttpClient = new RspamdHttpClient(new RspamdClientConfiguration(new URL((String)url), this.getInitParameter("rspamdPassword", this.configuration.getPassword()), this.getInitParameterAsOptional("rspamdTimeout").map(Integer::parseInt).or(this.configuration::getTimeout), this.perUserBayes));
        }));
    }

    public void service(Mail mail) throws MessagingException {
        if (this.perUserBayes) {
            this.scanPerUser(mail);
        } else {
            this.scanAll(mail);
        }
    }

    private void scanPerUser(Mail mail) {
        Flux.fromIterable((Iterable)mail.getRecipients()).flatMap((Function)Throwing.function(rcpt -> this.rspamdHttpClient.checkV2(mail, RspamdHttpClient.Options.forMailAddress(rcpt)).map(result -> Pair.of((Object)rcpt, (Object)result))), 16).concatMap(rcptAndResult -> Mono.fromRunnable(() -> this.handleScanResult(mail, (Pair<MailAddress, AnalysisResult>)rcptAndResult)).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER)).blockLast();
    }

    private void handleScanResult(Mail mail, Pair<MailAddress, AnalysisResult> rcptAndResult) {
        AuditTrail.entry().protocol("mailetcontainer").action("RspamdScanner").parameters((Supplier)Throwing.supplier(() -> ImmutableMap.of((Object)"mailId", (Object)mail.getName(), (Object)"mimeMessageId", (Object)Optional.ofNullable(mail.getMessage()).map(Throwing.function(MimeMessage::getMessageID)).orElse(""), (Object)"sender", (Object)mail.getMaybeSender().asString(), (Object)"recipient", (Object)((MailAddress)rcptAndResult.getKey()).asString(), (Object)"rspamDAction", (Object)((AnalysisResult)rcptAndResult.getValue()).getAction().name(), (Object)"virus", (Object)((AnalysisResult)rcptAndResult.getValue()).getVirusNote().orElse(""), (Object)"rspamDRequiredScore", (Object)Float.toString(((AnalysisResult)rcptAndResult.getValue()).getRequiredScore()), (Object)"rspamRewrittenSubject", (Object)((AnalysisResult)rcptAndResult.getValue()).getDesiredRewriteSubject().orElse(""), (Object)"rspamDScore", (Object)Float.toString(((AnalysisResult)rcptAndResult.getValue()).getScore())))).log("Mail scanned with RSpamD.");
        if (AnalysisResult.Action.REJECT == ((AnalysisResult)rcptAndResult.getValue()).getAction()) {
            this.rejectSpamProcessor.ifPresent(processor -> this.processorPerUser(mail, (MailAddress)rcptAndResult.getKey(), (String)processor, "Rejected due to high spam score"));
        }
        this.appendRspamdResultHeader(mail, (MailAddress)rcptAndResult.getKey(), (AnalysisResult)rcptAndResult.getRight());
        if (((AnalysisResult)rcptAndResult.getRight()).getVirusNote().isPresent()) {
            this.virusProcessor.ifPresent(processor -> this.processorPerUser(mail, (MailAddress)rcptAndResult.getKey(), (String)processor, ((AnalysisResult)rcptAndResult.getRight()).getVirusNote().get()));
        }
    }

    private void processorPerUser(Mail mail, MailAddress rcpt, String processor, String error) {
        Mail copy = null;
        try {
            copy = mail.duplicate();
            copy.setRecipients((Collection)ImmutableList.of((Object)rcpt));
            this.getMailetContext().sendMail(copy, processor);
        }
        catch (MessagingException e) {
            throw new RuntimeException("Error when processor per user", e);
        }
        finally {
            if (copy != null) {
                mail.setRecipients((Collection)Sets.difference((Set)ImmutableSet.copyOf((Collection)mail.getRecipients()), (Set)ImmutableSet.of((Object)rcpt)));
                LifecycleUtil.dispose((Object)copy);
            }
        }
        if (this.virusProcessor.equals(Optional.of(processor))) {
            LOGGER.info("Detected a mail containing virus. Sending mail {} to {}", (Object)mail, this.virusProcessor);
            mail.setState(processor);
        }
    }

    private void scanAll(Mail mail) throws MessagingException {
        AnalysisResult rspamdResult = (AnalysisResult)this.rspamdHttpClient.checkV2(mail).block();
        Preconditions.checkNotNull((Object)rspamdResult);
        if (rspamdResult.getAction() == AnalysisResult.Action.REJECT) {
            this.rejectSpamProcessor.ifPresent(arg_0 -> ((Mail)mail).setState(arg_0));
        }
        mail.getRecipients().forEach(recipient -> this.appendRspamdResultHeader(mail, (MailAddress)recipient, rspamdResult));
        if (this.rewriteSubject) {
            rspamdResult.getDesiredRewriteSubject().ifPresent((Consumer<String>)Throwing.consumer(desiredRewriteSubject -> mail.getMessage().setSubject(desiredRewriteSubject)));
        }
        rspamdResult.getVirusNote().ifPresent(virusNote -> {
            LOGGER.info("Detected a mail containing virus. Sending mail {} to {}", (Object)mail, this.virusProcessor);
            mail.setErrorMessage(virusNote);
            this.virusProcessor.ifPresent(arg_0 -> ((Mail)mail).setState(arg_0));
        });
    }

    private void appendRspamdResultHeader(Mail mail, MailAddress recipient, AnalysisResult rspamdResult) {
        for (Attribute attribute : this.getHeadersAsAttributes(rspamdResult)) {
            mail.addSpecificHeaderForRecipient(PerRecipientHeaders.Header.builder().name(attribute.getName().asString()).value((String)attribute.getValue().value()).build(), recipient);
        }
    }

    private List<Attribute> getHeadersAsAttributes(AnalysisResult rspamdResult) {
        String defaultFlagMailAttributeValue = "NO";
        String defaultStatusMailAttributeValue = "No";
        if (rspamdResult.getAction().equals((Object)AnalysisResult.Action.REJECT) || rspamdResult.getAction().equals((Object)AnalysisResult.Action.ADD_HEADER) || rspamdResult.getAction().equals((Object)AnalysisResult.Action.REWRITE_SUBJECT)) {
            defaultFlagMailAttributeValue = "YES";
            defaultStatusMailAttributeValue = "Yes";
        }
        return ImmutableList.of((Object)new Attribute(FLAG_MAIL, AttributeValue.of((String)defaultFlagMailAttributeValue)), (Object)new Attribute(STATUS_MAIL, AttributeValue.of((String)(defaultStatusMailAttributeValue + ", actions=" + rspamdResult.getAction().getDescription() + " score=" + rspamdResult.getScore() + " requiredScore=" + rspamdResult.getRequiredScore()))));
    }

    public Collection<ProcessingState> requiredProcessingState() {
        return (Collection)Stream.of(this.virusProcessor, this.rejectSpamProcessor).flatMap(Optional::stream).map(ProcessingState::new).collect(ImmutableList.toImmutableList());
    }
}

