/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.helper;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.james.mpt.api.Continuation;

public class ByteBufferOutputStream
extends OutputStream {
    private final ByteBuffer buffer = ByteBuffer.allocate(160384);
    private final Continuation continuation;
    private boolean matchPlus = false;
    private boolean matchCR = false;
    private boolean matchLF = false;

    public ByteBufferOutputStream(Continuation continuation) {
        this.continuation = continuation;
    }

    public void write(String message) throws IOException {
        StandardCharsets.US_ASCII.newEncoder().encode(CharBuffer.wrap(message), this.buffer, true);
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer.put((byte)b);
        if (this.matchPlus && this.matchLF) {
            this.matchPlus = false;
            this.matchCR = false;
            this.matchLF = false;
            this.continuation.doContinue();
        } else if (b == 10) {
            this.matchLF = true;
            this.matchPlus = false;
            this.matchCR = false;
        } else if (b == 43 && this.matchLF) {
            this.matchPlus = true;
            this.matchCR = false;
        } else {
            this.matchPlus = false;
            this.matchCR = false;
            this.matchLF = false;
        }
    }

    public String nextLine() throws Exception {
        this.buffer.flip();
        int last = 0;
        while (this.buffer.hasRemaining()) {
            byte next = this.buffer.get();
            if (last == 13 && next == 10) break;
            last = next;
        }
        ByteBuffer readOnlyBuffer = this.buffer.asReadOnlyBuffer();
        readOnlyBuffer.flip();
        int limit = readOnlyBuffer.limit() - 2;
        if (limit < 0) {
            limit = 0;
        }
        readOnlyBuffer.limit(limit);
        String result = StandardCharsets.US_ASCII.decode(readOnlyBuffer).toString();
        this.buffer.compact();
        return result;
    }
}

