/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;

public class ImapFeatures {
    private final ImmutableSet<Feature> supportedFeatures;

    public static ImapFeatures of(Feature ... features) {
        return new ImapFeatures((ImmutableSet<Feature>)ImmutableSet.copyOf((Object[])features));
    }

    private ImapFeatures(ImmutableSet<Feature> supportedFeatures) {
        this.supportedFeatures = supportedFeatures;
    }

    public Set<Feature> supportedFeatures() {
        return this.supportedFeatures;
    }

    public boolean supports(Feature ... features) {
        Preconditions.checkNotNull((Object)features);
        return this.supportedFeatures.containsAll((Collection)ImmutableSet.copyOf((Object[])features));
    }

    public static enum Feature {
        NAMESPACE_SUPPORT,
        MOVE_SUPPORT,
        USER_FLAGS_SUPPORT,
        QUOTA_SUPPORT,
        ANNOTATION_SUPPORT,
        MOD_SEQ_SEARCH;

    }
}

