/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.james.core.quota.QuotaLimitValue;
import org.apache.james.core.quota.QuotaUsageValue;

public class Quota<T extends QuotaLimitValue<T>, U extends QuotaUsageValue<U, T>> {
    private final T limit;
    private final ImmutableMap<Scope, T> limitByScope;
    private final U used;

    public static List<Scope> allScopes() {
        return Arrays.asList(Scope.User, Scope.Domain, Scope.Global);
    }

    public static <T extends QuotaLimitValue<T>, U extends QuotaUsageValue<U, T>> Builder<T, U> builder() {
        return new Builder();
    }

    private Quota(U used, T max, ImmutableMap<Scope, T> limitByScope) {
        this.used = used;
        this.limit = max;
        this.limitByScope = limitByScope;
    }

    public T getLimit() {
        return this.limit;
    }

    public U getUsed() {
        return this.used;
    }

    public double getRatio() {
        if (this.limit.isUnlimited()) {
            return 0.0;
        }
        return Double.valueOf(this.used.asLong()) / Double.valueOf(this.limit.asLong());
    }

    public ImmutableMap<Scope, T> getLimitByScope() {
        return this.limitByScope;
    }

    public Quota<T, U> addValueToQuota(U value) {
        return new Quota<T, QuotaUsageValue>(this.used.add(value), this.limit, this.limitByScope);
    }

    public boolean isOverQuota() {
        return this.isOverQuotaWithAdditionalValue(0L);
    }

    public boolean isOverQuotaWithAdditionalValue(long additionalValue) {
        Preconditions.checkArgument((additionalValue >= 0L ? 1 : 0) != 0);
        return this.limit.isLimited() && this.used.add(additionalValue).exceedLimit(this.limit);
    }

    public String toString() {
        return this.used + "/" + this.limit;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Quota)) {
            return false;
        }
        Quota other = (Quota)o;
        return Objects.equal(this.used, other.getUsed()) && Objects.equal(this.limit, other.getLimit());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.used, this.limit});
    }

    /* synthetic */ Quota(QuotaUsageValue x0, QuotaLimitValue x1, ImmutableMap x2, 1 x3) {
        this(x0, x1, x2);
    }

    public static class Builder<T extends QuotaLimitValue<T>, U extends QuotaUsageValue<U, T>> {
        private final ImmutableMap.Builder<Scope, T> limitsByScope = ImmutableMap.builder();
        private T computedLimit;
        private U used;

        private Builder() {
        }

        public Builder<T, U> computedLimit(T limit) {
            this.computedLimit = limit;
            return this;
        }

        public Builder<T, U> used(U used) {
            this.used = used;
            return this;
        }

        public Builder<T, U> limitsByScope(Map<Scope, T> limits) {
            this.limitsByScope.putAll(limits);
            return this;
        }

        public Builder<T, U> limitForScope(T limit, Scope scope) {
            this.limitsByScope.put((Object)scope, limit);
            return this;
        }

        public Quota<T, U> build() {
            Preconditions.checkState((this.used != null ? 1 : 0) != 0);
            Preconditions.checkState((this.computedLimit != null ? 1 : 0) != 0);
            return new Quota((QuotaUsageValue)this.used, (QuotaLimitValue)this.computedLimit, this.limitsByScope.build(), null);
        }
    }

    public static enum Scope {
        Domain,
        Global,
        User;

    }
}

