/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.events;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.james.mailbox.events.Event;
import org.apache.james.mailbox.events.Group;
import org.apache.james.mailbox.events.GroupAlreadyRegistered;
import org.apache.james.mailbox.events.MailboxListener;
import org.apache.james.mailbox.events.Registration;
import org.apache.james.mailbox.events.RegistrationKey;
import reactor.core.publisher.Mono;

public interface EventBus {
    public static final int EXECUTION_RATE = 10;

    public Registration register(MailboxListener var1, RegistrationKey var2);

    public Registration register(MailboxListener var1, Group var2) throws GroupAlreadyRegistered;

    public Mono<Void> dispatch(Event var1, Set<RegistrationKey> var2);

    public Mono<Void> reDeliver(Group var1, Event var2);

    default public Mono<Void> dispatch(Event event, RegistrationKey key) {
        return this.dispatch(event, (Set<RegistrationKey>)ImmutableSet.of((Object)key));
    }

    default public Registration register(MailboxListener.GroupMailboxListener groupMailboxListener) {
        return this.register((MailboxListener)groupMailboxListener, groupMailboxListener.getDefaultGroup());
    }

    public static interface Metrics {
        public static String timerName(MailboxListener mailboxListener) {
            return "mailbox-listener-" + mailboxListener.getClass().getSimpleName();
        }
    }

    public static interface StructuredLoggingFields {
        public static final String EVENT_ID = "eventId";
        public static final String EVENT_CLASS = "eventClass";
        public static final String LISTENER_CLASS = "listenerClass";
        public static final String USER = "user";
        public static final String GROUP = "group";
        public static final String REGISTRATION_KEYS = "registrationKeys";
        public static final String REGISTRATION_KEY = "registrationKey";
    }
}

