/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.acl;

import java.util.ArrayList;
import java.util.Map;
import org.apache.james.core.Username;
import org.apache.james.mailbox.acl.GroupMembershipResolver;
import org.apache.james.mailbox.acl.MailboxACLResolver;
import org.apache.james.mailbox.exception.UnsupportedRightException;
import org.apache.james.mailbox.model.MailboxACL;

public class UnionMailboxACLResolver
implements MailboxACLResolver {
    public static final MailboxACL DEFAULT_GLOBAL_GROUP_ACL = MailboxACL.OWNER_FULL_EXCEPT_ADMINISTRATION_ACL;
    public static final MailboxACL DEFAULT_GLOBAL_USER_ACL = MailboxACL.OWNER_FULL_ACL;
    private static final int POSITIVE_INDEX = 0;
    private static final int NEGATIVE_INDEX = 1;
    private final MailboxACL groupGlobalACL;
    private final MailboxACL userGlobalACL;

    public UnionMailboxACLResolver() {
        this.userGlobalACL = DEFAULT_GLOBAL_USER_ACL;
        this.groupGlobalACL = DEFAULT_GLOBAL_GROUP_ACL;
    }

    public UnionMailboxACLResolver(MailboxACL userGlobalACL, MailboxACL groupGlobalACL) {
        if (userGlobalACL == null) {
            throw new NullPointerException("Missing userGlobalACL.");
        }
        if (groupGlobalACL == null) {
            throw new NullPointerException("Missing groupGlobalACL.");
        }
        this.userGlobalACL = userGlobalACL;
        this.groupGlobalACL = groupGlobalACL;
    }

    protected static boolean applies(MailboxACL.EntryKey aclKey, MailboxACL.EntryKey queryKey, GroupMembershipResolver groupMembershipResolver, String resourceOwner, boolean resourceOwnerIsGroup) {
        String aclKeyName = aclKey.getName();
        MailboxACL.NameType aclKeyNameType = aclKey.getNameType();
        if (MailboxACL.SpecialName.anybody.name().equals(aclKeyName)) {
            return true;
        }
        if (queryKey != null) {
            String queryUserOrGroupName = queryKey.getName();
            switch (queryKey.getNameType()) {
                case user: {
                    switch (aclKeyNameType) {
                        case special: {
                            if (MailboxACL.SpecialName.authenticated.name().equals(aclKeyName)) {
                                return true;
                            }
                            if (MailboxACL.SpecialName.owner.name().equals(aclKeyName)) {
                                return !resourceOwnerIsGroup && queryUserOrGroupName.equals(resourceOwner) || resourceOwnerIsGroup && groupMembershipResolver.isMember(Username.of((String)queryUserOrGroupName), resourceOwner);
                            }
                            throw new IllegalStateException("Unexpected " + MailboxACL.SpecialName.class.getName() + "." + aclKeyName);
                        }
                        case user: {
                            return aclKeyName.equals(queryUserOrGroupName);
                        }
                        case group: {
                            return groupMembershipResolver.isMember(Username.of((String)queryUserOrGroupName), aclKeyName);
                        }
                    }
                    throw new IllegalStateException("Unexpected " + MailboxACL.NameType.class.getName() + "." + (Object)((Object)aclKeyNameType));
                }
                case group: {
                    switch (aclKeyNameType) {
                        case special: {
                            if (MailboxACL.SpecialName.authenticated.name().equals(aclKeyName)) {
                                return true;
                            }
                            if (MailboxACL.SpecialName.owner.name().equals(aclKeyName)) {
                                return resourceOwnerIsGroup && queryUserOrGroupName.equals(resourceOwner);
                            }
                            throw new IllegalStateException("Unexpected " + MailboxACL.SpecialName.class.getName() + "." + aclKeyName);
                        }
                        case user: {
                            return false;
                        }
                        case group: {
                            return aclKeyName.equals(queryUserOrGroupName);
                        }
                    }
                    throw new IllegalStateException("Unexpected " + MailboxACL.NameType.class.getName() + "." + (Object)((Object)aclKeyNameType));
                }
                case special: {
                    switch (aclKeyNameType) {
                        case special: {
                            if (aclKeyName.equals(queryUserOrGroupName)) {
                                return true;
                            }
                            return MailboxACL.SpecialName.owner.name().equals(queryUserOrGroupName) && MailboxACL.SpecialName.authenticated.name().equals(aclKeyName);
                        }
                        case user: 
                        case group: {
                            return false;
                        }
                    }
                    throw new IllegalStateException("Unexpected " + MailboxACL.NameType.class.getName() + "." + (Object)((Object)aclKeyNameType));
                }
            }
            throw new IllegalStateException("Unexpected " + MailboxACL.NameType.class.getName() + "." + (Object)((Object)queryKey.getNameType()));
        }
        return false;
    }

    @Override
    public MailboxACL applyGlobalACL(MailboxACL resourceACL, boolean resourceOwnerIsGroup) throws UnsupportedRightException {
        return resourceOwnerIsGroup ? resourceACL.union(this.groupGlobalACL) : resourceACL.union(this.userGlobalACL);
    }

    @Override
    public MailboxACL.Rfc4314Rights[] listRights(MailboxACL.EntryKey queryKey, GroupMembershipResolver groupMembershipResolver, String resourceOwner, boolean resourceOwnerIsGroup) throws UnsupportedRightException {
        MailboxACL.Rfc4314Rights[] positiveNegativePair = new MailboxACL.Rfc4314Rights[]{MailboxACL.NO_RIGHTS, MailboxACL.NO_RIGHTS};
        MailboxACL userACL = resourceOwnerIsGroup ? this.groupGlobalACL : this.userGlobalACL;
        this.resolveRights(queryKey, groupMembershipResolver, userACL.getEntries(), resourceOwner, resourceOwnerIsGroup, positiveNegativePair);
        if (queryKey.isNegative()) {
            return UnionMailboxACLResolver.toListRightsArray(positiveNegativePair[1]);
        }
        return UnionMailboxACLResolver.toListRightsArray(positiveNegativePair[0].except(positiveNegativePair[1]));
    }

    private static MailboxACL.Rfc4314Rights[] toListRightsArray(MailboxACL.Rfc4314Rights implicitRights) throws UnsupportedRightException {
        ArrayList<MailboxACL.Rfc4314Rights> result = new ArrayList<MailboxACL.Rfc4314Rights>();
        result.add(implicitRights);
        for (MailboxACL.Right right : MailboxACL.FULL_RIGHTS.list()) {
            if (implicitRights.contains(right)) continue;
            result.add(new MailboxACL.Rfc4314Rights(right));
        }
        return result.toArray(new MailboxACL.Rfc4314Rights[result.size()]);
    }

    @Override
    public MailboxACL.Rfc4314Rights resolveRights(Username requestUser, GroupMembershipResolver groupMembershipResolver, MailboxACL resourceACL, String resourceOwner, boolean resourceOwnerIsGroup) throws UnsupportedRightException {
        MailboxACL.Rfc4314Rights[] positiveNegativePair = new MailboxACL.Rfc4314Rights[]{MailboxACL.NO_RIGHTS, MailboxACL.NO_RIGHTS};
        MailboxACL.EntryKey queryKey = requestUser == null ? null : MailboxACL.EntryKey.createUserEntryKey(requestUser);
        MailboxACL userACL = resourceOwnerIsGroup ? this.groupGlobalACL : this.userGlobalACL;
        this.resolveRights(queryKey, groupMembershipResolver, userACL.getEntries(), resourceOwner, resourceOwnerIsGroup, positiveNegativePair);
        if (resourceACL != null) {
            this.resolveRights(queryKey, groupMembershipResolver, resourceACL.getEntries(), resourceOwner, resourceOwnerIsGroup, positiveNegativePair);
        }
        return positiveNegativePair[0].except(positiveNegativePair[1]);
    }

    private void resolveRights(MailboxACL.EntryKey queryKey, GroupMembershipResolver groupMembershipResolver, Map<MailboxACL.EntryKey, MailboxACL.Rfc4314Rights> entries, String resourceOwner, boolean resourceOwnerIsGroup, MailboxACL.Rfc4314Rights[] positiveNegativePair) throws UnsupportedRightException {
        if (entries != null) {
            for (Map.Entry<MailboxACL.EntryKey, MailboxACL.Rfc4314Rights> entry : entries.entrySet()) {
                MailboxACL.EntryKey key = entry.getKey();
                if (!UnionMailboxACLResolver.applies(key, queryKey, groupMembershipResolver, resourceOwner, resourceOwnerIsGroup)) continue;
                if (key.isNegative()) {
                    positiveNegativePair[1] = positiveNegativePair[1].union(entry.getValue());
                    continue;
                }
                positiveNegativePair[0] = positiveNegativePair[0].union(entry.getValue());
            }
        }
    }
}

