/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.mail.Flags;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.UnsupportedRightException;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxCounters;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MessageResultIterator;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.model.UidValidity;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.message.DefaultMessageWriter;

public interface MessageManager {
    public long getMessageCount(MailboxSession var1) throws MailboxException;

    public MailboxCounters getMailboxCounters(MailboxSession var1) throws MailboxException;

    @Deprecated
    public boolean isWriteable(MailboxSession var1) throws MailboxException;

    public boolean isModSeqPermanent(MailboxSession var1);

    public Stream<MessageUid> search(SearchQuery var1, MailboxSession var2) throws MailboxException;

    public Iterator<MessageUid> expunge(MessageRange var1, MailboxSession var2) throws MailboxException;

    public void delete(List<MessageUid> var1, MailboxSession var2) throws MailboxException;

    public Map<MessageUid, Flags> setFlags(Flags var1, FlagsUpdateMode var2, MessageRange var3, MailboxSession var4) throws MailboxException;

    public ComposedMessageId appendMessage(InputStream var1, Date var2, MailboxSession var3, boolean var4, Flags var5) throws MailboxException;

    public ComposedMessageId appendMessage(AppendCommand var1, MailboxSession var2) throws MailboxException;

    public MessageResultIterator getMessages(MessageRange var1, FetchGroup var2, MailboxSession var3) throws MailboxException;

    public Mailbox getMailboxEntity() throws MailboxException;

    public EnumSet<MailboxManager.MessageCapabilities> getSupportedMessageCapabilities();

    public MailboxId getId();

    public MailboxPath getMailboxPath() throws MailboxException;

    public Flags getApplicableFlags(MailboxSession var1) throws MailboxException;

    public MetaData getMetaData(boolean var1, MailboxSession var2, MetaData.FetchGroup var3) throws MailboxException;

    public MailboxACL getResolvedAcl(MailboxSession var1) throws UnsupportedRightException;

    public static interface MetaData {
        public List<MessageUid> getRecent();

        public long countRecent();

        public Flags getPermanentFlags();

        public UidValidity getUidValidity();

        public MessageUid getUidNext();

        public ModSeq getHighestModSeq();

        public long getMessageCount();

        public long getUnseenCount();

        public MessageUid getFirstUnseen();

        public boolean isWriteable();

        public boolean isModSeqPermanent();

        public MailboxACL getACL();

        public static enum FetchGroup {
            NO_UNSEEN,
            UNSEEN_COUNT,
            FIRST_UNSEEN,
            NO_COUNT;

        }
    }

    public static class AppendCommand {
        private final InputStream msgIn;
        private final Date internalDate;
        private final boolean isRecent;
        private final Flags flags;

        public static AppendCommand from(Message.Builder builder) throws IOException {
            return AppendCommand.builder().build(builder);
        }

        public static AppendCommand from(Message message) throws IOException {
            return AppendCommand.builder().build(message);
        }

        public static AppendCommand from(InputStream message) {
            return AppendCommand.builder().build(message);
        }

        public static Builder builder() {
            return new Builder();
        }

        private AppendCommand(InputStream msgIn, Date internalDate, boolean isRecent, Flags flags) {
            this.msgIn = msgIn;
            this.internalDate = internalDate;
            this.isRecent = isRecent;
            this.flags = flags;
        }

        public InputStream getMsgIn() {
            return this.msgIn;
        }

        public Date getInternalDate() {
            return this.internalDate;
        }

        public boolean isRecent() {
            return this.isRecent;
        }

        public Flags getFlags() {
            return this.flags;
        }

        public static class Builder {
            private Optional<Date> internalDate = Optional.empty();
            private Optional<Boolean> isRecent = Optional.empty();
            private Optional<Flags> flags = Optional.empty();

            private Builder() {
            }

            public Builder withFlags(Flags flags) {
                this.flags = Optional.of(flags);
                return this;
            }

            public Builder withInternalDate(Date date) {
                this.internalDate = Optional.of(date);
                return this;
            }

            public Builder isRecent(boolean recent) {
                this.isRecent = Optional.of(recent);
                return this;
            }

            public Builder recent() {
                return this.isRecent(true);
            }

            public Builder notRecent() {
                return this.isRecent(false);
            }

            public AppendCommand build(InputStream msgIn) {
                return new AppendCommand(msgIn, this.internalDate.orElse(new Date()), this.isRecent.orElse(true), this.flags.orElse(new Flags()));
            }

            public AppendCommand build(byte[] msgIn) {
                return this.build(new ByteArrayInputStream(msgIn));
            }

            public AppendCommand build(String msgIn) {
                return this.build(msgIn.getBytes(StandardCharsets.UTF_8));
            }

            public AppendCommand build(Message message) throws IOException {
                return this.build(DefaultMessageWriter.asBytes((Message)message));
            }

            public AppendCommand build(Message.Builder messageBuilder) throws IOException {
                return this.build(messageBuilder.build());
            }
        }
    }

    public static enum FlagsUpdateMode {
        ADD,
        REMOVE,
        REPLACE;

    }
}

