/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor.fetch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.mail.Flags;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.message.BodyFetchElement;
import org.apache.james.imap.api.message.FetchData;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.message.response.FetchResponse;
import org.apache.james.imap.processor.fetch.ContentBodyElement;
import org.apache.james.imap.processor.fetch.EmptyContent;
import org.apache.james.imap.processor.fetch.EnvelopeBuilder;
import org.apache.james.imap.processor.fetch.HeaderBodyElement;
import org.apache.james.imap.processor.fetch.MessageResultUtils;
import org.apache.james.imap.processor.fetch.MimeBodyElement;
import org.apache.james.imap.processor.fetch.MimeDescriptorStructure;
import org.apache.james.imap.processor.fetch.MimePathImpl;
import org.apache.james.imap.processor.fetch.PartialFetchBodyElement;
import org.apache.james.mailbox.Content;
import org.apache.james.mailbox.Headers;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageRange;
import org.apache.james.mailbox.MessageRangeException;
import org.apache.james.mailbox.MessageResult;
import org.apache.james.mailbox.MimeDescriptor;
import org.apache.james.mime4j.field.address.parser.ParseException;

public final class FetchResponseBuilder {
    private final EnvelopeBuilder envelopeBuilder;
    private int msn;
    private Long uid;
    private Flags flags;
    private Date internalDate;
    private Long size;
    private List<FetchResponse.BodyElement> elements;
    private FetchResponse.Envelope envelope;
    private FetchResponse.Structure body;
    private FetchResponse.Structure bodystructure;

    public FetchResponseBuilder(EnvelopeBuilder envelopeBuilder) {
        this.envelopeBuilder = envelopeBuilder;
    }

    public void reset(int msn) {
        this.msn = msn;
        this.uid = null;
        this.flags = null;
        this.internalDate = null;
        this.size = null;
        this.body = null;
        this.bodystructure = null;
        this.elements = null;
    }

    public void setUid(long uid) {
        this.uid = uid;
    }

    public void setFlags(Flags flags) {
        this.flags = flags;
    }

    public FetchResponse build() {
        FetchResponse result = new FetchResponse(this.msn, this.flags, this.uid, this.internalDate, this.size, this.envelope, this.body, this.bodystructure, this.elements);
        return result;
    }

    public FetchResponse build(FetchData fetch, MessageResult result, MessageManager mailbox, ImapSession session, boolean useUids) throws MessageRangeException, ParseException, MailboxException {
        long resultUid;
        SelectedMailbox selected = session.getSelected();
        int resultMsn = selected.msn(resultUid = result.getUid());
        if (resultMsn == -1) {
            throw new MessageRangeException("No such message found with uid " + resultUid);
        }
        this.reset(resultMsn);
        MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession((ImapSession)session);
        boolean ensureFlagsResponse = false;
        Flags resultFlags = result.getFlags();
        if (fetch.isSetSeen() && !resultFlags.contains(Flags.Flag.SEEN)) {
            mailbox.setFlags(new Flags(Flags.Flag.SEEN), true, false, MessageRange.one((long)resultUid), mailboxSession);
            resultFlags.add(Flags.Flag.SEEN);
            ensureFlagsResponse = true;
        }
        if (fetch.isFlags() || ensureFlagsResponse) {
            if (selected.isRecent(resultUid)) {
                resultFlags.add(Flags.Flag.RECENT);
            }
            this.setFlags(resultFlags);
        }
        if (fetch.isInternalDate()) {
            this.setInternalDate(result.getInternalDate());
        }
        if (fetch.isSize()) {
            this.setSize(result.getSize());
        }
        if (fetch.isEnvelope()) {
            this.envelope = this.buildEnvelope(result);
        }
        if (fetch.isBody() || fetch.isBodyStructure()) {
            MimeDescriptor descriptor = result.getMimeDescriptor();
            if (fetch.isBody()) {
                this.body = new MimeDescriptorStructure(false, descriptor, this.envelopeBuilder);
            }
            if (fetch.isBodyStructure()) {
                this.bodystructure = new MimeDescriptorStructure(true, descriptor, this.envelopeBuilder);
            }
        }
        if (fetch.isUid()) {
            this.setUid(resultUid);
        }
        Collection elements = fetch.getBodyElements();
        this.elements = new ArrayList<FetchResponse.BodyElement>();
        for (BodyFetchElement fetchElement : elements) {
            FetchResponse.BodyElement element = this.bodyFetch(result, fetchElement);
            if (element == null) continue;
            this.elements.add(element);
        }
        return this.build();
    }

    private FetchResponse.Envelope buildEnvelope(MessageResult result) throws MailboxException, ParseException {
        return this.envelopeBuilder.buildEnvelope((Headers)result);
    }

    private void setSize(long size) {
        this.size = size;
    }

    public void setInternalDate(Date internalDate) {
        this.internalDate = internalDate;
    }

    private FetchResponse.BodyElement bodyFetch(MessageResult messageResult, BodyFetchElement fetchElement) throws MailboxException {
        Long firstOctet = fetchElement.getFirstOctet();
        Long numberOfOctets = fetchElement.getNumberOfOctets();
        String name = fetchElement.getResponseName();
        int specifier = fetchElement.getSectionType();
        int[] path = fetchElement.getPath();
        Collection names = fetchElement.getFieldNames();
        boolean isBase = path == null || path.length == 0;
        FetchResponse.BodyElement fullResult = this.bodyContent(messageResult, name, specifier, path, names, isBase);
        FetchResponse.BodyElement result = this.wrapIfPartialFetch(firstOctet, numberOfOctets, fullResult);
        return result;
    }

    private FetchResponse.BodyElement bodyContent(MessageResult messageResult, String name, int specifier, int[] path, Collection<String> names, boolean isBase) throws MailboxException {
        FetchResponse.BodyElement fullResult;
        switch (specifier) {
            case 5: {
                fullResult = this.content(messageResult, name, path, isBase);
                break;
            }
            case 3: {
                fullResult = this.fields(messageResult, name, path, names, isBase);
                break;
            }
            case 4: {
                fullResult = this.fieldsNot(messageResult, name, path, names, isBase);
                break;
            }
            case 1: {
                fullResult = this.mimeHeaders(messageResult, name, path, isBase);
                break;
            }
            case 2: {
                fullResult = this.headers(messageResult, name, path, isBase);
                break;
            }
            case 0: {
                fullResult = this.text(messageResult, name, path, isBase);
                break;
            }
            default: {
                fullResult = null;
            }
        }
        return fullResult;
    }

    private FetchResponse.BodyElement wrapIfPartialFetch(Long firstOctet, Long numberOfOctets, FetchResponse.BodyElement fullResult) {
        FetchResponse.BodyElement result;
        if (firstOctet == null) {
            result = fullResult;
        } else {
            long numberOfOctetsAsLong = numberOfOctets == null ? Long.MAX_VALUE : numberOfOctets;
            long firstOctetAsLong = firstOctet;
            result = new PartialFetchBodyElement(fullResult, firstOctetAsLong, numberOfOctetsAsLong);
        }
        return result;
    }

    private FetchResponse.BodyElement text(MessageResult messageResult, String name, int[] path, boolean isBase) throws MailboxException {
        Content body;
        if (isBase) {
            body = messageResult.getBody();
        } else {
            MimePathImpl mimePath = new MimePathImpl(path);
            body = messageResult.getBody((MessageResult.MimePath)mimePath);
        }
        if (body == null) {
            body = new EmptyContent();
        }
        ContentBodyElement result = new ContentBodyElement(name, body);
        return result;
    }

    private FetchResponse.BodyElement mimeHeaders(MessageResult messageResult, String name, int[] path, boolean isBase) throws MailboxException {
        Iterator<MessageResult.Header> headers = this.getMimeHeaders(messageResult, path, isBase);
        List<MessageResult.Header> lines = MessageResultUtils.getAll(headers);
        MimeBodyElement result = new MimeBodyElement(name, lines);
        return result;
    }

    private HeaderBodyElement headerBodyElement(MessageResult messageResult, String name, List<MessageResult.Header> lines, int[] path, boolean isBase) throws MailboxException {
        HeaderBodyElement result = new HeaderBodyElement(name, lines);
        if (result.size() == 2L) {
            if (isBase) {
                if (messageResult.getSize() - result.size() <= 0L) {
                    result.noBody();
                }
            } else if (this.content(messageResult, name, path, isBase).size() <= 0L) {
                result.noBody();
            }
        }
        return result;
    }

    private FetchResponse.BodyElement headers(MessageResult messageResult, String name, int[] path, boolean isBase) throws MailboxException {
        Iterator<MessageResult.Header> headers = this.getHeaders(messageResult, path, isBase);
        List<MessageResult.Header> lines = MessageResultUtils.getAll(headers);
        return this.headerBodyElement(messageResult, name, lines, path, isBase);
    }

    private FetchResponse.BodyElement fieldsNot(MessageResult messageResult, String name, int[] path, Collection<String> names, boolean isBase) throws MailboxException {
        Iterator<MessageResult.Header> headers = this.getHeaders(messageResult, path, isBase);
        List<MessageResult.Header> lines = MessageResultUtils.getNotMatching(names, headers);
        return this.headerBodyElement(messageResult, name, lines, path, isBase);
    }

    private FetchResponse.BodyElement fields(MessageResult messageResult, String name, int[] path, Collection<String> names, boolean isBase) throws MailboxException {
        Iterator<MessageResult.Header> headers = this.getHeaders(messageResult, path, isBase);
        List<MessageResult.Header> lines = MessageResultUtils.getMatching(names, headers);
        return this.headerBodyElement(messageResult, name, lines, path, isBase);
    }

    private Iterator<MessageResult.Header> getHeaders(MessageResult messageResult, int[] path, boolean isBase) throws MailboxException {
        Iterator headers;
        if (isBase) {
            headers = messageResult.headers();
        } else {
            MimePathImpl mimePath = new MimePathImpl(path);
            headers = messageResult.iterateHeaders((MessageResult.MimePath)mimePath);
        }
        return headers;
    }

    private Iterator<MessageResult.Header> getMimeHeaders(MessageResult messageResult, int[] path, boolean isBase) throws MailboxException {
        MimePathImpl mimePath = new MimePathImpl(path);
        Iterator headers = messageResult.iterateMimeHeaders((MessageResult.MimePath)mimePath);
        return headers;
    }

    private FetchResponse.BodyElement content(MessageResult messageResult, String name, int[] path, boolean isBase) throws MailboxException {
        Content full;
        if (isBase) {
            full = messageResult.getFullContent();
        } else {
            MimePathImpl mimePath = new MimePathImpl(path);
            full = messageResult.getMimeBody((MessageResult.MimePath)mimePath);
        }
        if (full == null) {
            full = new EmptyContent();
        }
        ContentBodyElement result = new ContentBodyElement(name, full);
        return result;
    }
}

