/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.StatusDataItems;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.StatusRequest;
import org.apache.james.imap.message.response.MailboxStatusResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxPath;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.slf4j.Logger;

public class StatusProcessor
extends AbstractMailboxProcessor<StatusRequest> {
    public StatusProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory) {
        super(StatusRequest.class, next, mailboxManager, factory);
    }

    @Override
    protected void doProcess(StatusRequest request, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        MailboxPath mailboxPath = this.buildFullPath(session, request.getMailboxName());
        StatusDataItems statusDataItems = request.getStatusDataItems();
        Logger logger = session.getLog();
        MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession((ImapSession)session);
        try {
            if (logger != null && logger.isDebugEnabled()) {
                logger.debug("Status called on mailbox named " + mailboxPath + " (" + mailboxPath + ")");
            }
            MailboxManager mailboxManager = this.getMailboxManager();
            MessageManager mailbox = mailboxManager.getMailbox(mailboxPath, ImapSessionUtils.getMailboxSession((ImapSession)session));
            MessageManager.MetaData.FetchGroup fetchGroup = statusDataItems.isUnseen() ? MessageManager.MetaData.FetchGroup.UNSEEN_COUNT : MessageManager.MetaData.FetchGroup.NO_UNSEEN;
            MessageManager.MetaData metaData = mailbox.getMetaData(false, mailboxSession, fetchGroup);
            Long messages = this.messages(statusDataItems, metaData);
            Long recent = this.recent(statusDataItems, metaData);
            Long uidNext = this.uidNext(statusDataItems, metaData);
            Long uidValidity = this.uidValidity(statusDataItems, metaData);
            Long unseen = this.unseen(statusDataItems, metaData);
            MailboxStatusResponse response = new MailboxStatusResponse(messages, recent, uidNext, uidValidity, unseen, request.getMailboxName());
            responder.respond((ImapResponseMessage)response);
            this.unsolicitedResponses(session, responder, false);
            this.okComplete(command, tag, responder);
        }
        catch (MailboxException e) {
            session.getLog().debug("Status failed", (Throwable)e);
            this.no(command, tag, responder, HumanReadableText.SEARCH_FAILED);
        }
    }

    private Long unseen(StatusDataItems statusDataItems, MessageManager.MetaData metaData) throws MailboxException {
        Long unseen = statusDataItems.isUnseen() ? Long.valueOf(metaData.getUnseenCount()) : null;
        return unseen;
    }

    private Long uidValidity(StatusDataItems statusDataItems, MessageManager.MetaData metaData) throws MailboxException {
        Long uidValidity;
        if (statusDataItems.isUidValidity()) {
            long uidValidityValue = metaData.getUidValidity();
            uidValidity = uidValidityValue;
        } else {
            uidValidity = null;
        }
        return uidValidity;
    }

    private Long uidNext(StatusDataItems statusDataItems, MessageManager.MetaData metaData) throws MailboxException {
        Long uidNext;
        if (statusDataItems.isUidNext()) {
            long uidNextValue = metaData.getUidNext();
            uidNext = uidNextValue;
        } else {
            uidNext = null;
        }
        return uidNext;
    }

    private Long recent(StatusDataItems statusDataItems, MessageManager.MetaData metaData) throws MailboxException {
        Long recent = statusDataItems.isRecent() ? Long.valueOf(metaData.countRecent()) : null;
        return recent;
    }

    private Long messages(StatusDataItems statusDataItems, MessageManager.MetaData metaData) throws MailboxException {
        Long messages = statusDataItems.isMessages() ? Long.valueOf(metaData.getMessageCount()) : null;
        return messages;
    }
}

