/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.RenameRequest;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxExistsException;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxNotFoundException;
import org.apache.james.mailbox.MailboxPath;
import org.apache.james.mailbox.MailboxSession;

public class RenameProcessor
extends AbstractMailboxProcessor<RenameRequest> {
    public RenameProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory) {
        super(RenameRequest.class, next, mailboxManager, factory);
    }

    @Override
    protected void doProcess(RenameRequest request, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        MailboxPath existingPath = this.buildFullPath(session, request.getExistingName());
        MailboxPath newPath = this.buildFullPath(session, request.getNewName());
        try {
            MailboxManager mailboxManager = this.getMailboxManager();
            MailboxSession mailboxsession = ImapSessionUtils.getMailboxSession((ImapSession)session);
            mailboxManager.renameMailbox(existingPath, newPath, mailboxsession);
            if (existingPath.getName().equalsIgnoreCase("INBOX") && !mailboxManager.mailboxExists(existingPath, mailboxsession)) {
                mailboxManager.createMailbox(existingPath, mailboxsession);
            }
            this.okComplete(command, tag, responder);
            this.unsolicitedResponses(session, responder, false);
        }
        catch (MailboxExistsException e) {
            session.getLog().debug("Rename failed", (Throwable)e);
            this.no(command, tag, responder, HumanReadableText.FAILURE_MAILBOX_EXISTS);
        }
        catch (MailboxNotFoundException e) {
            session.getLog().debug("Rename failed", (Throwable)e);
            this.no(command, tag, responder, HumanReadableText.MAILBOX_NOT_FOUND);
        }
        catch (MailboxException e) {
            session.getLog().debug("Rename failed", (Throwable)e);
            this.no(command, tag, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING);
        }
    }
}

