/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapSessionState;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapLineHandler;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.message.request.IdleRequest;
import org.apache.james.imap.message.response.ContinuationResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.imap.processor.base.ImapStateAwareMailboxListener;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;

public class IdleProcessor
extends AbstractMailboxProcessor<IdleRequest>
implements CapabilityImplementingProcessor {
    private final ScheduledExecutorService heartbeatExecutor;
    public static final long DEFAULT_HEARTBEAT_INTERVAL_IN_SECONDS = 120L;
    public static final TimeUnit DEFAULT_HEARTBEAT_INTERVAL_UNIT = TimeUnit.SECONDS;
    public static final int DEFAULT_SCHEDULED_POOL_CORE_SIZE = 5;
    private static final String DONE = "DONE";
    private final TimeUnit heartbeatIntervalUnit;
    private final long heartbeatInterval;

    public IdleProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory) {
        this(next, mailboxManager, factory, 120L, DEFAULT_HEARTBEAT_INTERVAL_UNIT, Executors.newScheduledThreadPool(5));
    }

    public IdleProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, long heartbeatInterval, TimeUnit heartbeatIntervalUnit, ScheduledExecutorService heartbeatExecutor) {
        super(IdleRequest.class, next, mailboxManager, factory);
        this.heartbeatInterval = heartbeatInterval;
        this.heartbeatIntervalUnit = heartbeatIntervalUnit;
        this.heartbeatExecutor = heartbeatExecutor;
    }

    @Override
    protected void doProcess(IdleRequest message, final ImapSession session, final String tag, final ImapCommand command, final ImapProcessor.Responder responder) {
        final AtomicBoolean closed = new AtomicBoolean(false);
        try {
            responder.respond((ImapResponseMessage)new ContinuationResponse(HumanReadableText.IDLING));
            this.unsolicitedResponses(session, responder, false);
            MailboxManager mailboxManager = this.getMailboxManager();
            MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession((ImapSession)session);
            SelectedMailbox sm = session.getSelected();
            if (sm != null) {
                mailboxManager.addListener(sm.getPath(), (MailboxListener)new IdleMailboxListener(closed, session, responder), mailboxSession);
            }
            session.pushLineHandler(new ImapLineHandler(){

                public void onLine(ImapSession session, byte[] data) {
                    String line = data.length > 2 ? new String(data, 0, data.length - 2) : "";
                    closed.set(true);
                    session.popLineHandler();
                    if (!IdleProcessor.DONE.equals(line.toUpperCase(Locale.US))) {
                        StatusResponse response = IdleProcessor.this.getStatusResponseFactory().taggedBad(tag, command, HumanReadableText.INVALID_COMMAND);
                        responder.respond((ImapResponseMessage)response);
                    } else {
                        IdleProcessor.this.okComplete(command, tag, responder);
                    }
                }
            });
            if (this.heartbeatInterval > 0L) {
                this.heartbeatExecutor.schedule(new Runnable(){

                    @Override
                    public void run() {
                        if (session.getState() != ImapSessionState.LOGOUT && !closed.get()) {
                            StatusResponse response = IdleProcessor.this.getStatusResponseFactory().untaggedOk(HumanReadableText.HEARTBEAT);
                            responder.respond((ImapResponseMessage)response);
                            IdleProcessor.this.heartbeatExecutor.schedule(this, IdleProcessor.this.heartbeatInterval, IdleProcessor.this.heartbeatIntervalUnit);
                        }
                    }
                }, this.heartbeatInterval, this.heartbeatIntervalUnit);
            }
        }
        catch (MailboxException e) {
            closed.set(true);
            session.getLog().debug("Idle failed", (Throwable)e);
            this.no(command, tag, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING);
        }
    }

    @Override
    public List<String> getImplementedCapabilities(ImapSession session) {
        return Arrays.asList("IDLE");
    }

    private class IdleMailboxListener
    extends ImapStateAwareMailboxListener {
        private final AtomicBoolean closed;
        private final ImapProcessor.Responder responder;

        public IdleMailboxListener(AtomicBoolean closed, ImapSession session, ImapProcessor.Responder responder) {
            super(session);
            this.closed = closed;
            this.responder = responder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void event(MailboxListener.Event event) {
            ImapSession imapSession = this.session;
            synchronized (imapSession) {
                if (this.isClosed()) {
                    return;
                }
                if (event instanceof MailboxListener.Added || event instanceof MailboxListener.Expunged || event instanceof MailboxListener.FlagsUpdated) {
                    IdleProcessor.this.unsolicitedResponses(this.session, this.responder, false);
                }
            }
        }

        @Override
        protected boolean isListenerClosed() {
            return this.closed.get();
        }
    }
}

