/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import java.io.IOException;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.base.AbstractChainedImapEncoder;
import org.apache.james.imap.message.response.MyRightsResponse;
import org.apache.james.mailbox.model.MailboxACL;

public class MyRightsResponseEncoder
extends AbstractChainedImapEncoder {
    public MyRightsResponseEncoder(ImapEncoder next) {
        super(next);
    }

    @Override
    protected void doEncode(ImapMessage acceptableMessage, ImapResponseComposer composer, ImapSession session) throws IOException {
        MyRightsResponse aclResponse = (MyRightsResponse)acceptableMessage;
        MailboxACL.MailboxACLRights myRights = aclResponse.getMyRights();
        composer.untagged();
        composer.commandName("MYRIGHTS");
        String mailboxName = aclResponse.getMailboxName();
        composer.mailbox(mailboxName == null ? "" : mailboxName);
        composer.quote(myRights == null ? "" : myRights.serialize());
        composer.end();
    }

    @Override
    public boolean isAcceptable(ImapMessage message) {
        return message instanceof MyRightsResponse;
    }
}

