/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.crowdsec.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.google.common.collect.ImmutableList;
import io.netty.handler.codec.http.HttpHeaderNames;
import jakarta.inject.Inject;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.http.entity.ContentType;
import org.apache.james.crowdsec.client.CrowdsecClientConfiguration;
import org.apache.james.crowdsec.model.CrowdsecDecision;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;

public class CrowdsecHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrowdsecHttpClient.class);
    private static final String GET_DECISION = "/decisions";
    private final HttpClient httpClient;
    private final ObjectMapper mapper;
    private final CrowdsecClientConfiguration crowdsecConfiguration;

    @Inject
    public CrowdsecHttpClient(CrowdsecClientConfiguration configuration) {
        this.httpClient = this.buildReactorNettyHttpClient(configuration);
        this.mapper = new ObjectMapper().registerModule((Module)new Jdk8Module());
        this.crowdsecConfiguration = configuration;
    }

    public Mono<List<CrowdsecDecision>> getCrowdsecDecisions() {
        return ((HttpClient.ResponseReceiver)this.httpClient.get().uri(GET_DECISION)).responseSingle((response, body) -> {
            switch (response.status().code()) {
                case 200: {
                    return body.asString().map(this::parseCrowdsecDecisions);
                }
                case 403: {
                    return Mono.error((Throwable)new RuntimeException("Invalid api-key bouncer"));
                }
            }
            return Mono.error((Throwable)new RuntimeException("Request failed with status code " + response.status().code()));
        }).timeout(this.crowdsecConfiguration.getTimeout()).onErrorResume(TimeoutException.class, e -> Mono.fromRunnable(() -> LOGGER.warn("Timeout while questioning to CrowdSec. May need to check the CrowdSec configuration.")).thenReturn((Object)ImmutableList.of()));
    }

    private List<CrowdsecDecision> parseCrowdsecDecisions(String json) {
        if (CrowdsecHttpClient.noCrowdsecDecision(json)) {
            return ImmutableList.of();
        }
        try {
            return (List)this.mapper.readValue(json, (TypeReference)new TypeReference<List<CrowdsecDecision>>(this){});
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean noCrowdsecDecision(String json) {
        return json.equals("null");
    }

    private HttpClient buildReactorNettyHttpClient(CrowdsecClientConfiguration configuration) {
        return HttpClient.create().disableRetry(true).responseTimeout(configuration.getTimeout()).baseUrl(configuration.getUrl().toString()).headers(headers -> headers.add("X-Api-Key", (Object)configuration.getApiKey())).headers(headers -> headers.add((CharSequence)HttpHeaderNames.ACCEPT, (Object)ContentType.APPLICATION_JSON.getMimeType()));
    }
}

