/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.spi.util;

import java.nio.file.Path;
import java.util.Objects;
import org.apache.jackrabbit.vault.validation.spi.NodeContext;
import org.jetbrains.annotations.NotNull;

public final class NodeContextImpl
implements NodeContext {
    @NotNull
    private final String nodePath;
    @NotNull
    private final Path filePath;
    @NotNull
    private final Path basePath;
    private final int line;
    private final int column;

    public NodeContextImpl(@NotNull String nodePath, @NotNull Path filePath, @NotNull Path basePath) {
        this(nodePath, filePath, basePath, 0, 0);
    }

    public NodeContextImpl(@NotNull String nodePath, @NotNull Path filePath, @NotNull Path basePath, int line, int column) {
        this.nodePath = nodePath;
        this.filePath = filePath;
        this.basePath = basePath;
        this.line = line;
        this.column = column;
    }

    @Override
    @NotNull
    public String getNodePath() {
        return this.nodePath;
    }

    @Override
    @NotNull
    public Path getFilePath() {
        return this.filePath;
    }

    @Override
    @NotNull
    public Path getBasePath() {
        return this.basePath;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    public int hashCode() {
        return Objects.hash(this.basePath, this.column, this.filePath, this.line, this.nodePath);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeContextImpl other = (NodeContextImpl)obj;
        return Objects.equals(this.basePath, other.basePath) && this.column == other.column && Objects.equals(this.filePath, other.filePath) && this.line == other.line && Objects.equals(this.nodePath, other.nodePath);
    }

    public String toString() {
        return "NodeContextImpl [nodePath=" + this.nodePath + ", filePath=" + this.filePath + ", basePath=" + this.basePath + ", line=" + this.line + ", column=" + this.column + "]";
    }
}

