/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.spi.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.vault.fs.api.FilterSet;
import org.apache.jackrabbit.vault.fs.api.PathFilter;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.filter.DefaultPathFilter;
import org.apache.jackrabbit.vault.validation.spi.FilterValidator;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessage;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessageSeverity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OverlappingFilterValidator
implements FilterValidator {
    static final String MESSAGE_OVERLAPPING_FILTER_ROOTS = "Filter root '%s' in package '%s' potentially overlapping with filter root '%s' in package '%s' (prior checking include/exclude patterns)";
    static final String MESSAGE_OVERLAPPING_FILTERS = "Filter root '%s' with include pattern %s in package '%s' potentially overlapping with filter '%s' in package '%s'";
    private static final Pattern PATTERN_OPTIONAL_GROUP = Pattern.compile("\\(.*\\)\\?");
    private static final Pattern PATTERN_ESCAPED_CHARACTER = Pattern.compile("\\\\([^\\(])");
    private static final String PATTERN_ALLOW_ALL = ".*";
    private final NavigableMap<String, List<PathFilterSet>> filtersPerPackages = new TreeMap<String, List<PathFilterSet>>();
    private final ValidationMessageSeverity severityForOverlappingSingleNodePatterns;
    private final ValidationMessageSeverity defaultSeverity;

    public OverlappingFilterValidator(ValidationMessageSeverity defaultSeverity, ValidationMessageSeverity severityForOverlappingSingleNodePatterns) {
        this.defaultSeverity = defaultSeverity;
        this.severityForOverlappingSingleNodePatterns = severityForOverlappingSingleNodePatterns;
    }

    @Override
    @Nullable
    public Collection<ValidationMessage> done() {
        return this.validateFilters(this.filtersPerPackages);
    }

    private Collection<ValidationMessage> validateFilters(NavigableMap<String, List<PathFilterSet>> filtersPerPackages) {
        Map.Entry filtersPerPackage;
        String higherKey;
        ArrayList<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();
        Iterator iterator = filtersPerPackages.entrySet().iterator();
        while (iterator.hasNext() && (higherKey = filtersPerPackages.higherKey((String)(filtersPerPackage = iterator.next()).getKey())) != null) {
            validationMessages.addAll(this.validateFiltersOfSinglePackage((List)filtersPerPackage.getValue(), (String)filtersPerPackage.getKey(), filtersPerPackages.tailMap(higherKey)));
        }
        return validationMessages;
    }

    private Collection<ValidationMessage> validateFiltersOfSinglePackage(List<PathFilterSet> filtersOfPackage, String packagePath, SortedMap<String, List<PathFilterSet>> otherPackageFiltersPerPackages) {
        ArrayList<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();
        for (int index = 0; index < filtersOfPackage.size(); ++index) {
            PathFilterSet set1 = filtersOfPackage.get(index);
            for (Map.Entry<String, List<PathFilterSet>> otherPackageFiltersPerPackage : otherPackageFiltersPerPackages.entrySet()) {
                Optional<PathFilterSet> set2 = otherPackageFiltersPerPackage.getValue().stream().filter(new NestedPathPredicate(set1)).findAny();
                if (!set2.isPresent()) continue;
                validationMessages.add(new ValidationMessage(ValidationMessageSeverity.DEBUG, String.format(MESSAGE_OVERLAPPING_FILTER_ROOTS, set1.getRoot(), packagePath, set2.get().getRoot(), otherPackageFiltersPerPackage.getKey()) + " (prior checking includes/excludes)"));
                validationMessages.addAll(this.validateFilterSets(set1, packagePath, set2.get(), otherPackageFiltersPerPackage.getKey()));
            }
        }
        return validationMessages;
    }

    private Collection<ValidationMessage> validateFilterSets(PathFilterSet filterSet1, String packagePathFilterSet1, PathFilterSet filterSet2, String packagePathFilterSet2) {
        Collection<ValidationMessage> messages = this.validateIncludesInFilterSet1AreExcludedInFilterSet2(filterSet1, packagePathFilterSet1, filterSet2, packagePathFilterSet2);
        if (messages.isEmpty()) {
            messages = this.validateIncludesInFilterSet1AreExcludedInFilterSet2(filterSet2, packagePathFilterSet2, filterSet1, packagePathFilterSet1);
        }
        return messages;
    }

    private Collection<ValidationMessage> validateIncludesInFilterSet1AreExcludedInFilterSet2(PathFilterSet includeFilterSet, String packagePathIncludeFilterSet, PathFilterSet excludeFilterSet, String packagePathExcludeFilterSet) {
        LinkedList<ValidationMessage> messages = new LinkedList<ValidationMessage>();
        for (PathFilter includeFilter : OverlappingFilterValidator.getIncludeFilters(includeFilterSet.getEntries())) {
            String testPattern = OverlappingFilterValidator.getNormalizedPattern(includeFilter, includeFilterSet.getRoot());
            if (OverlappingFilterValidator.isExcluded(testPattern, excludeFilterSet)) continue;
            boolean isSingleNodeFilterPattern = OverlappingFilterValidator.isSingleNodeFilterPattern(testPattern);
            ValidationMessageSeverity severity = isSingleNodeFilterPattern ? this.severityForOverlappingSingleNodePatterns : this.defaultSeverity;
            messages.add(new ValidationMessage(severity, String.format(MESSAGE_OVERLAPPING_FILTERS, includeFilterSet.getRoot(), OverlappingFilterValidator.getPatternLabel(includeFilter), packagePathIncludeFilterSet, excludeFilterSet, packagePathExcludeFilterSet)));
        }
        return messages;
    }

    static List<FilterSet.Entry<PathFilter>> getNormalizedEntries(List<FilterSet.Entry<PathFilter>> entries) {
        ArrayList<FilterSet.Entry<PathFilter>> normalizedPathFilter = new ArrayList<FilterSet.Entry<PathFilter>>();
        if (entries.isEmpty()) {
            return PathFilterSet.INCLUDE_ALL.getEntries();
        }
        if (entries.get(0).isInclude()) {
            normalizedPathFilter.add((FilterSet.Entry)PathFilterSet.EXCLUDE_ALL.getEntries().get(0));
        } else {
            normalizedPathFilter.add((FilterSet.Entry)PathFilterSet.INCLUDE_ALL.getEntries().get(0));
        }
        normalizedPathFilter.addAll(entries);
        return normalizedPathFilter;
    }

    static List<PathFilter> getIncludeFilters(List<FilterSet.Entry<PathFilter>> entries) {
        if (entries.isEmpty()) {
            return Collections.singletonList(PathFilter.ALL);
        }
        return entries.stream().filter(FilterSet.Entry::isInclude).map(FilterSet.Entry::getFilter).collect(Collectors.toList());
    }

    static boolean isSingleNodeFilterPattern(String pattern) {
        return !pattern.endsWith(PATTERN_ALLOW_ALL);
    }

    static boolean isExcluded(String testPattern, PathFilterSet filterSet) {
        List<FilterSet.Entry<PathFilter>> entries = OverlappingFilterValidator.getNormalizedEntries(filterSet.getEntries());
        Collections.reverse(entries);
        Optional<FilterSet.Entry<PathFilter>> entry = entries.stream().filter(new PatternMatchPredicate(testPattern, filterSet.getRoot())).findFirst();
        return entry.map(e -> !e.isInclude()).orElse(true);
    }

    static String getUnescapedPattern(String pattern) {
        return PATTERN_ESCAPED_CHARACTER.matcher(pattern).replaceAll("$1");
    }

    static String getNormalizedPattern(PathFilter filter, String rootPath) {
        String pattern;
        if (filter instanceof DefaultPathFilter) {
            pattern = ((DefaultPathFilter)DefaultPathFilter.class.cast(filter)).getPattern();
        } else if (filter == PathFilter.ALL) {
            pattern = Pattern.quote(rootPath.endsWith("/") ? rootPath : rootPath + "/");
            pattern = pattern + PATTERN_ALLOW_ALL;
        } else {
            throw new IllegalArgumentException("Unsupported filter type " + filter);
        }
        Matcher matcher = PATTERN_OPTIONAL_GROUP.matcher(pattern);
        pattern = matcher.replaceAll("");
        if (pattern.startsWith(PATTERN_ALLOW_ALL)) {
            pattern = Pattern.quote(rootPath) + pattern.substring(PATTERN_ALLOW_ALL.length(), pattern.length());
        }
        return OverlappingFilterValidator.removeQeQuoting(pattern);
    }

    static String getPatternLabel(PathFilter filter) {
        StringBuilder pattern = new StringBuilder();
        if (filter instanceof DefaultPathFilter) {
            pattern.append("'").append(((DefaultPathFilter)DefaultPathFilter.class.cast(filter)).getPattern()).append("'");
        } else if (filter == PathFilter.ALL) {
            pattern.append("(implicit) ALL");
        } else {
            throw new IllegalArgumentException("Unsupported filter type " + filter);
        }
        return pattern.toString();
    }

    static String removeQeQuoting(String pattern) {
        int pLen = pattern.length();
        int[] temp = pattern.codePoints().toArray();
        int i = 0;
        while (i < pLen - 1) {
            if (temp[i] != 92) {
                ++i;
                continue;
            }
            if (temp[i + 1] == 81) break;
            i += 2;
        }
        if (i >= pLen - 1) {
            return pattern;
        }
        int j = i;
        int[] newtemp = new int[j + 3 * (pLen - (i += 2)) + 2];
        System.arraycopy(temp, 0, newtemp, 0, j);
        boolean inQuote = true;
        boolean beginQuote = true;
        while (i < pLen) {
            int c;
            if (!ASCII.isAscii(c = temp[i++]) || ASCII.isAlpha(c) || c == 47) {
                newtemp[j++] = c;
            } else if (ASCII.isDigit(c)) {
                if (beginQuote) {
                    newtemp[j++] = 92;
                    newtemp[j++] = 120;
                    newtemp[j++] = 51;
                }
                newtemp[j++] = c;
            } else if (c != 92) {
                if (inQuote) {
                    newtemp[j++] = 92;
                }
                newtemp[j++] = c;
            } else if (inQuote) {
                if (temp[i] == 69) {
                    ++i;
                    inQuote = false;
                } else {
                    newtemp[j++] = 92;
                    newtemp[j++] = 92;
                }
            } else {
                if (temp[i] == 81) {
                    ++i;
                    inQuote = true;
                    beginQuote = true;
                    continue;
                }
                newtemp[j++] = c;
                if (i != pLen) {
                    newtemp[j++] = temp[i++];
                }
            }
            beginQuote = false;
        }
        return new String(newtemp, 0, j);
    }

    public void addFilter(@NotNull WorkspaceFilter filter, String pathInContainer) {
        this.filtersPerPackages.put(pathInContainer, filter.getFilterSets());
    }

    @Override
    @Nullable
    public Collection<ValidationMessage> validate(@NotNull WorkspaceFilter filter) {
        return null;
    }

    static final class ASCII {
        static final int UPPER = 256;
        static final int LOWER = 512;
        static final int DIGIT = 1024;
        static final int SPACE = 2048;
        static final int PUNCT = 4096;
        static final int CNTRL = 8192;
        static final int BLANK = 16384;
        static final int HEX = 32768;
        static final int UNDER = 65536;
        static final int ASCII = 65280;
        static final int ALPHA = 768;
        static final int ALNUM = 1792;
        static final int GRAPH = 5888;
        static final int WORD = 67328;
        static final int XDIGIT = 32768;
        private static final int[] ctype = new int[]{8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 26624, 10240, 10240, 10240, 10240, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 8192, 18432, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 33792, 33793, 33794, 33795, 33796, 33797, 33798, 33799, 33800, 33801, 4096, 4096, 4096, 4096, 4096, 4096, 4096, 33034, 33035, 33036, 33037, 33038, 33039, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 4096, 4096, 4096, 4096, 69632, 4096, 33290, 33291, 33292, 33293, 33294, 33295, 528, 529, 530, 531, 532, 533, 534, 535, 536, 537, 538, 539, 540, 541, 542, 543, 544, 545, 546, 547, 4096, 4096, 4096, 4096, 8192};

        ASCII() {
        }

        static int getType(int ch) {
            return (ch & 0xFFFFFF80) == 0 ? ctype[ch] : 0;
        }

        static boolean isType(int ch, int type) {
            return (org.apache.jackrabbit.vault.validation.spi.impl.OverlappingFilterValidator$ASCII.getType(ch) & type) != 0;
        }

        static boolean isAscii(int ch) {
            return (ch & 0xFFFFFF80) == 0;
        }

        static boolean isAlpha(int ch) {
            return org.apache.jackrabbit.vault.validation.spi.impl.OverlappingFilterValidator$ASCII.isType(ch, 768);
        }

        static boolean isDigit(int ch) {
            return (ch - 48 | 57 - ch) >= 0;
        }
    }

    static final class PatternMatchPredicate
    implements Predicate<FilterSet.Entry<PathFilter>> {
        private final String pattern;
        private final String otherRoot;

        public PatternMatchPredicate(String pattern, String otherRoot) {
            this.pattern = pattern;
            this.otherRoot = otherRoot;
        }

        @Override
        public boolean test(FilterSet.Entry<PathFilter> t) {
            String testPath = OverlappingFilterValidator.getUnescapedPattern(this.pattern);
            if (testPath.startsWith(this.otherRoot) && ((PathFilter)t.getFilter()).matches(testPath)) {
                return true;
            }
            String otherPattern = OverlappingFilterValidator.getNormalizedPattern((PathFilter)t.getFilter(), this.otherRoot);
            if (otherPattern.endsWith(OverlappingFilterValidator.PATTERN_ALLOW_ALL)) {
                otherPattern = otherPattern.substring(0, otherPattern.length() - OverlappingFilterValidator.PATTERN_ALLOW_ALL.length());
                return Text.isDescendantOrEqual((String)otherPattern, (String)this.pattern);
            }
            return otherPattern.equals(this.pattern);
        }
    }

    private static final class NestedPathPredicate
    implements Predicate<PathFilterSet> {
        private final String path;

        NestedPathPredicate(PathFilterSet filterSet) {
            this.path = filterSet.getRoot();
        }

        @Override
        public boolean test(PathFilterSet t) {
            String path2 = t.getRoot();
            return Text.isDescendantOrEqual((String)this.path, (String)path2) || Text.isDescendant((String)path2, (String)this.path);
        }
    }
}

