/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.spi.impl;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.jackrabbit.vault.fs.api.SerializationType;
import org.apache.jackrabbit.vault.fs.impl.io.XmlAnalyzer;
import org.apache.jackrabbit.vault.validation.ValidationExecutor;
import org.apache.jackrabbit.vault.validation.ValidationViolation;
import org.apache.jackrabbit.vault.validation.impl.util.DocumentViewXmlContentHandler;
import org.apache.jackrabbit.vault.validation.impl.util.EnhancedBufferedInputStream;
import org.apache.jackrabbit.vault.validation.spi.DocumentViewXmlValidator;
import org.apache.jackrabbit.vault.validation.spi.GenericJcrDataValidator;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessage;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessageSeverity;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class DocumentViewParserValidator
implements GenericJcrDataValidator {
    public static final String EXTENDED_FILE_AGGREGATE_FOLDER_SUFFIX = ".dir";
    private final Map<String, DocumentViewXmlValidator> docViewValidators = new HashMap<String, DocumentViewXmlValidator>();
    private final SAXParser saxParser;
    @NotNull
    private final ValidationMessageSeverity severity;

    public DocumentViewParserValidator(SAXParser saxParser, @NotNull ValidationMessageSeverity severity) {
        this.saxParser = saxParser;
        this.severity = severity;
    }

    public void setDocumentViewXmlValidators(Map<String, DocumentViewXmlValidator> documentViewXmlValidators) {
        this.docViewValidators.putAll(documentViewXmlValidators);
    }

    @Override
    public Collection<ValidationMessage> done() {
        return null;
    }

    @Override
    public boolean shouldValidateJcrData(@NotNull Path filePath, @NotNull Path basePath) {
        return filePath.toString().endsWith(".xml");
    }

    @Override
    public Collection<ValidationMessage> validateJcrData(@NotNull InputStream input, @NotNull Path filePath, @NotNull Path basePath, @NotNull Map<String, Integer> nodePathsAndLineNumbers) throws IOException {
        LinkedList<ValidationMessage> messages = new LinkedList<ValidationMessage>();
        EnhancedBufferedInputStream bufferedInput = new EnhancedBufferedInputStream(input);
        Path documentViewXmlRootPath = DocumentViewParserValidator.getDocumentViewXmlRootPath(bufferedInput, filePath);
        if (documentViewXmlRootPath != null) {
            try {
                messages.addAll(this.validateDocumentViewXml(bufferedInput, filePath, basePath, ValidationExecutor.filePathToNodePath(documentViewXmlRootPath), nodePathsAndLineNumbers));
            }
            catch (SAXException e) {
                throw new IOException("Could not parse xml", e);
            }
        } else {
            messages.add(new ValidationMessage(ValidationMessageSeverity.INFO, "This file is not detected as docview xml file and therefore treated as binary"));
            nodePathsAndLineNumbers.put(ValidationExecutor.filePathToNodePath(filePath), 0);
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Path getDocumentViewXmlRootPath(BufferedInputStream input, Path path) throws IOException {
        Path name = path.getFileName();
        Path rootPath = null;
        int nameCount = path.getNameCount();
        if (name.equals(Paths.get(".content.xml", new String[0]))) {
            if (nameCount > 1) {
                rootPath = path.subpath(0, nameCount - 1);
                if (rootPath.toString().endsWith(EXTENDED_FILE_AGGREGATE_FOLDER_SUFFIX)) {
                    rootPath = Paths.get(rootPath.toString().substring(0, rootPath.toString().length() - EXTENDED_FILE_AGGREGATE_FOLDER_SUFFIX.length()), new String[0]);
                }
            } else {
                rootPath = Paths.get("", new String[0]);
            }
        } else if (name.toString().endsWith(".xml")) {
            input.mark(1024);
            try {
                SerializationType type = XmlAnalyzer.analyze((InputSource)new InputSource((InputStream)new CloseShieldInputStream((InputStream)input)));
                if (type == SerializationType.XML_DOCVIEW) {
                    String fileName = path.getFileName().toString();
                    fileName = fileName.substring(0, fileName.length() - ".xml".length());
                    rootPath = nameCount > 1 ? path.subpath(0, nameCount - 1).resolve(fileName) : Paths.get(fileName, new String[0]);
                }
            }
            finally {
                input.reset();
            }
        }
        return rootPath;
    }

    protected Collection<ValidationMessage> validateDocumentViewXml(InputStream input, @NotNull Path filePath, @NotNull Path basePath, String rootNodePath, Map<String, Integer> nodePathsAndLineNumbers) throws IOException, SAXException {
        LinkedList<ValidationMessage> enrichedMessages = new LinkedList<ValidationMessage>();
        XMLReader xr = this.saxParser.getXMLReader();
        DocumentViewXmlContentHandler handler = new DocumentViewXmlContentHandler(filePath, basePath, rootNodePath, this.docViewValidators);
        enrichedMessages.add(new ValidationMessage(ValidationMessageSeverity.DEBUG, "Detected DocView..."));
        xr.setContentHandler(handler);
        try {
            xr.parse(new InputSource((InputStream)new CloseShieldInputStream(input)));
            enrichedMessages.addAll(ValidationViolation.wrapMessages(null, handler.getViolations(), filePath, basePath, rootNodePath, 0, 0));
        }
        catch (SAXException e) {
            enrichedMessages.add(new ValidationViolation(this.severity, "Invalid XML found: " + e.getMessage(), filePath, basePath, rootNodePath, 0, 0, (Throwable)e));
        }
        nodePathsAndLineNumbers.putAll(handler.getNodePaths());
        return enrichedMessages;
    }
}

