/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.secondary;

import com.google.common.collect.EvictingQueue;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.document.AbstractDocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStateCache;
import org.apache.jackrabbit.oak.plugins.document.NodeStateDiffer;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.secondary.DelegatingDocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.secondary.SecondaryStoreRootObserver;
import org.apache.jackrabbit.oak.spi.filter.PathFilter;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecondaryStoreCache
implements DocumentNodeStateCache,
SecondaryStoreRootObserver {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final AbstractDocumentNodeState[] EMPTY = new AbstractDocumentNodeState[0];
    private final NodeStore store;
    private final PathFilter pathFilter;
    private final NodeStateDiffer differ;
    private final MeterStats unknownPaths;
    private final MeterStats knownMissed;
    private final MeterStats knownMissedOld;
    private final MeterStats knownMissedNew;
    private final MeterStats knownMissedInRange;
    private final MeterStats headRevMatched;
    private final MeterStats prevRevMatched;
    private final int maxSize = 10000;
    private final EvictingQueue<AbstractDocumentNodeState> queue;
    private volatile AbstractDocumentNodeState[] previousRoots = EMPTY;

    public SecondaryStoreCache(NodeStore nodeStore, NodeStateDiffer differ, PathFilter pathFilter, StatisticsProvider statisticsProvider) {
        this.differ = differ;
        this.store = nodeStore;
        this.pathFilter = pathFilter;
        this.unknownPaths = statisticsProvider.getMeter("DOCUMENT_CACHE_SEC_UNKNOWN", StatsOptions.DEFAULT);
        this.knownMissed = statisticsProvider.getMeter("DOCUMENT_CACHE_SEC_KNOWN_MISSED", StatsOptions.DEFAULT);
        this.knownMissedOld = statisticsProvider.getMeter("DOCUMENT_CACHE_SEC_KNOWN_MISSED_OLD", StatsOptions.DEFAULT);
        this.knownMissedNew = statisticsProvider.getMeter("DOCUMENT_CACHE_SEC_KNOWN_MISSED_NEW", StatsOptions.DEFAULT);
        this.knownMissedInRange = statisticsProvider.getMeter("DOCUMENT_CACHE_SEC_KNOWN_MISSED_IN_RANGE", StatsOptions.DEFAULT);
        this.headRevMatched = statisticsProvider.getMeter("DOCUMENT_CACHE_SEC_HEAD", StatsOptions.DEFAULT);
        this.prevRevMatched = statisticsProvider.getMeter("DOCUMENT_CACHE_SEC_OLD", StatsOptions.DEFAULT);
        this.queue = EvictingQueue.create((int)10000);
    }

    @Override
    @Nullable
    public AbstractDocumentNodeState getDocumentNodeState(String path, RevisionVector rootRevision, RevisionVector lastRev) {
        NodeState state;
        PathFilter.Result result = this.pathFilter.filter(path);
        if (result != PathFilter.Result.INCLUDE) {
            this.unknownPaths.mark();
            return null;
        }
        if (!DelegatingDocumentNodeState.hasMetaProps(this.store.getRoot())) {
            return null;
        }
        AbstractDocumentNodeState currentRoot = DelegatingDocumentNodeState.wrap(this.store.getRoot(), this.differ);
        if (lastRev.compareTo(currentRoot.getLastRevision()) > 0) {
            return null;
        }
        AbstractDocumentNodeState nodeState = this.findByMatchingLastRev(currentRoot, path, lastRev);
        if (nodeState != null) {
            this.headRevMatched.mark();
            return nodeState;
        }
        AbstractDocumentNodeState matchingRoot = this.findMatchingRoot(rootRevision);
        if (matchingRoot != null && (state = NodeStateUtils.getNode((NodeState)matchingRoot, (String)path)).exists()) {
            AbstractDocumentNodeState docState = SecondaryStoreCache.asDocState(state);
            this.prevRevMatched.mark();
            return docState;
        }
        this.knownMissed.mark();
        return null;
    }

    @Override
    public boolean isCached(String path) {
        return this.pathFilter.filter(path) == PathFilter.Result.INCLUDE;
    }

    @Nullable
    private AbstractDocumentNodeState findByMatchingLastRev(AbstractDocumentNodeState root, String path, RevisionVector lastRev) {
        AbstractDocumentNodeState state = root;
        for (String name : PathUtils.elements((String)path)) {
            if (!(state = state.getChildNode(name)).exists()) {
                return null;
            }
            if (lastRev.compareTo(SecondaryStoreCache.asDocState((NodeState)state).getLastRevision()) <= 0) continue;
            return null;
        }
        AbstractDocumentNodeState docState = SecondaryStoreCache.asDocState((NodeState)state);
        if (lastRev.equals(docState.getLastRevision())) {
            this.headRevMatched.mark();
            return docState;
        }
        return null;
    }

    @Nullable
    private AbstractDocumentNodeState findMatchingRoot(RevisionVector rr) {
        if (this.isEmpty()) {
            return null;
        }
        AbstractDocumentNodeState[] roots = this.previousRoots;
        AbstractDocumentNodeState latest = roots[roots.length - 1];
        AbstractDocumentNodeState oldest = roots[0];
        if (rr.compareTo(latest.getRootRevision()) > 0) {
            this.knownMissedNew.mark();
            return null;
        }
        if (rr.compareTo(oldest.getRootRevision()) < 0) {
            this.knownMissedOld.mark();
            return null;
        }
        AbstractDocumentNodeState result = SecondaryStoreCache.findMatchingRoot(roots, rr);
        if (result != null) {
            return result;
        }
        this.knownMissedInRange.mark();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void contentChanged(@NotNull AbstractDocumentNodeState root) {
        EvictingQueue<AbstractDocumentNodeState> evictingQueue = this.queue;
        synchronized (evictingQueue) {
            this.queue.add((Object)root);
            this.previousRoots = (AbstractDocumentNodeState[])this.queue.toArray((Object[])EMPTY);
        }
    }

    private boolean isEmpty() {
        return this.previousRoots.length == 0;
    }

    static AbstractDocumentNodeState findMatchingRoot(AbstractDocumentNodeState[] roots, RevisionVector key) {
        int low = 0;
        int high = roots.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            AbstractDocumentNodeState midVal = roots[mid];
            int cmp = midVal.getRootRevision().compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return midVal;
        }
        return null;
    }

    private static AbstractDocumentNodeState asDocState(NodeState state) {
        return (AbstractDocumentNodeState)state;
    }
}

