/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.rdb;

import com.google.common.base.Suppliers;
import javax.sql.DataSource;
import org.apache.jackrabbit.oak.plugins.blob.ReferencedBlob;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreBuilder;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.VersionGCSupport;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBBlobReferenceIterator;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBBlobStore;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBOptions;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBVersionGCSupport;
import org.apache.jackrabbit.oak.spi.blob.GarbageCollectableBlobStore;

public class RDBDocumentNodeStoreBuilder
extends DocumentNodeStoreBuilder<RDBDocumentNodeStoreBuilder> {
    public static RDBDocumentNodeStoreBuilder newRDBDocumentNodeStoreBuilder() {
        return new RDBDocumentNodeStoreBuilder();
    }

    public RDBDocumentNodeStoreBuilder setRDBConnection(DataSource ds) {
        this.setRDBConnection(ds, new RDBOptions());
        return (RDBDocumentNodeStoreBuilder)this.thisBuilder();
    }

    public RDBDocumentNodeStoreBuilder setRDBConnection(DataSource ds, RDBOptions options) {
        this.documentStoreSupplier = Suppliers.ofInstance((Object)new RDBDocumentStore(ds, this, options));
        if (this.blobStore == null) {
            RDBBlobStore s = new RDBBlobStore(ds, options);
            this.setGCBlobStore((GarbageCollectableBlobStore)s);
        }
        return (RDBDocumentNodeStoreBuilder)this.thisBuilder();
    }

    public RDBDocumentNodeStoreBuilder setRDBConnection(DataSource documentStoreDataSource, DataSource blobStoreDataSource) {
        this.documentStoreSupplier = Suppliers.ofInstance((Object)new RDBDocumentStore(documentStoreDataSource, this));
        if (this.blobStore == null) {
            RDBBlobStore s = new RDBBlobStore(blobStoreDataSource);
            this.setGCBlobStore((GarbageCollectableBlobStore)s);
        }
        return (RDBDocumentNodeStoreBuilder)this.thisBuilder();
    }

    @Override
    public VersionGCSupport createVersionGCSupport() {
        DocumentStore store = this.getDocumentStore();
        if (store instanceof RDBDocumentStore) {
            return new RDBVersionGCSupport((RDBDocumentStore)store);
        }
        return super.createVersionGCSupport();
    }

    @Override
    public Iterable<ReferencedBlob> createReferencedBlobs(DocumentNodeStore ns) {
        DocumentStore store = this.getDocumentStore();
        if (store instanceof RDBDocumentStore) {
            return () -> new RDBBlobReferenceIterator(ns, (RDBDocumentStore)store);
        }
        return super.createReferencedBlobs(ns);
    }
}

