/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.persistentCache.broadcast;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.MessageDigest;
import java.util.ArrayList;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.broadcast.Broadcaster;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.broadcast.DynamicBroadcastConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDPBroadcaster
implements Broadcaster,
Runnable {
    static final Logger LOG = LoggerFactory.getLogger(UDPBroadcaster.class);
    private final byte[] key;
    private final ArrayList<Broadcaster.Listener> listeners = new ArrayList();
    private final MulticastSocket socket;
    private final int port;
    private final InetAddress group;
    private final InetAddress sendTo;
    private final Thread thread;
    private final int messageLength = 32768;
    private final Cipher encryptCipher;
    private final Cipher decryptCipher;
    private volatile boolean stop;

    public UDPBroadcaster(String config) {
        LOG.info("init " + config);
        try {
            String[] parts = config.split(";");
            String group = "FF78:230::1234";
            int port = 9876;
            String key = "";
            boolean aes = false;
            String sendTo = null;
            for (String p : parts) {
                if (p.startsWith("port ")) {
                    port = Integer.parseInt(p.split(" ")[1]);
                    continue;
                }
                if (p.startsWith("group ")) {
                    group = p.split(" ")[1];
                    continue;
                }
                if (p.startsWith("key ")) {
                    key = p.split(" ")[1];
                    continue;
                }
                if (p.equals("aes")) {
                    aes = true;
                    continue;
                }
                if (!p.startsWith("sendTo ")) continue;
                sendTo = p.split(" ")[1];
            }
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            this.key = messageDigest.digest(key.getBytes());
            if (aes) {
                KeyGenerator kgen = KeyGenerator.getInstance("AES");
                kgen.init(128);
                SecretKey aesKey = kgen.generateKey();
                this.encryptCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
                this.encryptCipher.init(1, aesKey);
                this.decryptCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
                IvParameterSpec ivParameterSpec = new IvParameterSpec(aesKey.getEncoded());
                this.decryptCipher.init(2, (Key)aesKey, ivParameterSpec);
            } else {
                this.encryptCipher = null;
                this.decryptCipher = null;
            }
            this.socket = new MulticastSocket(port);
            this.group = InetAddress.getByName(group);
            this.sendTo = sendTo == null ? this.group : InetAddress.getByName(sendTo);
            this.port = port;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.thread = new Thread((Runnable)this, "Oak UDPBroadcaster listener");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    @Override
    public void run() {
        block11: {
            byte[] receiveData = new byte[32768];
            try {
                this.socket.joinGroup(this.group);
            }
            catch (IOException e) {
                if (!this.stop) {
                    LOG.warn("join group failed", (Throwable)e);
                }
                this.stop = true;
                return;
            }
            while (!this.stop) {
                try {
                    DatagramPacket receivePacket = new DatagramPacket(receiveData, receiveData.length);
                    this.socket.receive(receivePacket);
                    int len = receivePacket.getLength();
                    if (len < this.key.length) {
                        LOG.debug("too short");
                        continue;
                    }
                    if (!this.checkKey(receiveData)) {
                        LOG.debug("key mismatch");
                        continue;
                    }
                    ByteBuffer buff = ByteBuffer.wrap(receiveData);
                    buff.limit(len);
                    int start = this.key.length;
                    for (Broadcaster.Listener l : this.listeners) {
                        buff.position(start);
                        l.receive(buff);
                    }
                }
                catch (IOException e) {
                    if (this.stop) continue;
                    LOG.warn("receive failed", (Throwable)e);
                }
            }
            try {
                this.socket.leaveGroup(this.group);
                this.socket.close();
            }
            catch (IOException e) {
                if (this.stop) break block11;
                LOG.warn("leave group failed", (Throwable)e);
            }
        }
    }

    private boolean checkKey(byte[] data) {
        for (int i = 0; i < this.key.length; ++i) {
            if (this.key[i] == data[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void send(ByteBuffer buff) {
        block3: {
            int len = this.key.length + buff.limit();
            if (len >= 32768) {
                return;
            }
            try {
                byte[] sendData = new byte[len];
                System.arraycopy(this.key, 0, sendData, 0, this.key.length);
                buff.get(sendData, this.key.length, buff.limit());
                DatagramPacket sendPacket = new DatagramPacket(sendData, sendData.length, this.sendTo, this.port);
                this.socket.send(sendPacket);
            }
            catch (IOException e) {
                if (this.stop) break block3;
                LOG.debug("send failed", (Throwable)e);
            }
        }
    }

    @Override
    public void addListener(Broadcaster.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(Broadcaster.Listener listener) {
        this.listeners.remove(listener);
    }

    byte[] encrypt(byte[] data) {
        if (this.encryptCipher == null) {
            return data;
        }
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            CipherOutputStream cipherOutputStream = new CipherOutputStream(outputStream, this.encryptCipher);
            cipherOutputStream.write(data);
            cipherOutputStream.flush();
            cipherOutputStream.close();
            byte[] encryptedBytes = outputStream.toByteArray();
            return encryptedBytes;
        }
        catch (IOException e) {
            LOG.debug("encrypt failed", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    byte[] decrypt(byte[] data) {
        if (this.decryptCipher == null) {
            return data;
        }
        try {
            int bytesRead;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ByteArrayInputStream inStream = new ByteArrayInputStream(data);
            CipherInputStream cipherInputStream = new CipherInputStream(inStream, this.decryptCipher);
            byte[] buf = new byte[1024];
            while ((bytesRead = cipherInputStream.read(buf)) >= 0) {
                outputStream.write(buf, 0, bytesRead);
            }
            return outputStream.toByteArray();
        }
        catch (IOException e) {
            LOG.debug("decrypt failed", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        if (!this.stop) {
            this.stop = true;
            this.socket.close();
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public boolean isRunning() {
        return !this.stop;
    }

    @Override
    public void setBroadcastConfig(DynamicBroadcastConfig broadcastConfig) {
    }
}

