/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Range;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.StableRevisionComparator;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PropertyHistory
implements Iterable<NodeDocument> {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyHistory.class);
    private final NodeDocument doc;
    private final String property;
    private final String mainPath;

    public PropertyHistory(@NotNull NodeDocument doc, @NotNull String property) {
        this.doc = (NodeDocument)Preconditions.checkNotNull((Object)doc);
        this.property = (String)Preconditions.checkNotNull((Object)property);
        this.mainPath = doc.getMainPath();
    }

    @Override
    public Iterator<NodeDocument> iterator() {
        return this.ensureOrder(Iterables.filter((Iterable)Iterables.transform(this.doc.getPreviousRanges().entrySet(), (Function)new Function<Map.Entry<Revision, Range>, Map.Entry<Revision, NodeDocument>>(){

            @Nullable
            public Map.Entry<Revision, NodeDocument> apply(Map.Entry<Revision, Range> input) {
                Revision r = input.getKey();
                int h = input.getValue().height;
                String prevId = Utils.getPreviousIdFor(PropertyHistory.this.mainPath, r, h);
                NodeDocument prev = PropertyHistory.this.doc.getPreviousDocument(prevId);
                if (prev == null) {
                    LOG.debug("Document with previous revisions not found: " + prevId);
                    return null;
                }
                return new AbstractMap.SimpleImmutableEntry<Revision, NodeDocument>(r, prev);
            }
        }), (Predicate)Predicates.notNull()));
    }

    private Iterator<NodeDocument> ensureOrder(final Iterable<Map.Entry<Revision, NodeDocument>> docs) {
        return new AbstractIterator<NodeDocument>(){
            PeekingIterator<Map.Entry<Revision, NodeDocument>> input;
            TreeMap<Revision, NodeDocument> queue;
            {
                this.input = Iterators.peekingIterator(docs.iterator());
                this.queue = new TreeMap(StableRevisionComparator.INSTANCE);
            }

            protected NodeDocument computeNext() {
                this.refillQueue();
                if (this.queue.isEmpty()) {
                    return (NodeDocument)this.endOfData();
                }
                return this.queue.remove(this.queue.lastKey());
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private void refillQueue() {
                while (true) {
                    Map<Revision, String> values;
                    Iterator<Revision> revs;
                    NodeDocument doc;
                    if (this.queue.isEmpty()) {
                        if (!this.input.hasNext()) return;
                        doc = (NodeDocument)((Map.Entry)this.input.next()).getValue();
                    } else {
                        if (!this.input.hasNext()) return;
                        if (this.queue.comparator().compare(this.queue.lastKey(), (Revision)((Map.Entry)this.input.peek()).getKey()) >= 0) return;
                        doc = (NodeDocument)((Map.Entry)this.input.next()).getValue();
                    }
                    if (doc == null || !(revs = (values = doc.getValueMap(PropertyHistory.this.property)).keySet().iterator()).hasNext()) continue;
                    this.queue.put(revs.next(), doc);
                }
            }
        };
    }
}

