/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.plugins.document.BackgroundReadStats;
import org.apache.jackrabbit.oak.plugins.document.BackgroundWriteStats;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreStatsCollector;
import org.apache.jackrabbit.oak.stats.HistogramStats;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.apache.jackrabbit.oak.stats.TimerStats;

public class DocumentNodeStoreStats
implements DocumentNodeStoreStatsCollector {
    private static final String BGR_READ_HEAD = "DOCUMENT_NS_BGR_READ_HEAD";
    private static final String BGR_CACHE_INVALIDATE = "DOCUMENT_NS_BGR_CACHE_INVALIDATE";
    private static final String BGR_DIFF_CACHE = "DOCUMENT_NS_BGR_DIFF_CACHE";
    private static final String BGR_LOCK = "DOCUMENT_NS_BGR_LOCK";
    private static final String BGR_DISPATCH = "DOCUMENT_NS_BGR_DISPATCH";
    private static final String BGR_TOTAL_TIME = "DOCUMENT_NS_BGR_TOTAL_TIME";
    static final String BGR_NUM_CHANGES_RATE = "DOCUMENT_NS_BGR_NUM_CHANGES_RATE";
    private static final String BGR_NUM_CHANGES_HISTO = "DOCUMENT_NS_BGR_NUM_CHANGES_HISTO";
    static final String BGR_LAG = "DOCUMENT_NS_BGR_LAG";
    private static final String BGW_CLEAN = "DOCUMENT_NS_BGW_CLEAN";
    private static final String BGW_SPLIT = "DOCUMENT_NS_BGW_SPLIT";
    private static final String BGW_WRITE = "DOCUMENT_NS_BGW_LOCK";
    private static final String BGW_SWEEP = "DOCUMENT_NS_BGW_SWEEP";
    static final String BGW_NUM = "DOCUMENT_NS_BGW_NUM";
    static final String BGW_NUM_WRITES_RATE = "DOCUMENT_NS_BGW_NUM_WRITE_RATE";
    private static final String BGW_TOTAL = "DOCUMENT_NS_BGW_TOTAL_TIME";
    static final String LEASE_UPDATE = "DOCUMENT_NS_LEASE_UPDATE";
    private static final String MERGE_SUCCESS_NUM_RETRY = "DOCUMENT_NS_MERGE_SUCCESS_RETRY";
    static final String MERGE_SUCCESS_COUNT = "DOCUMENT_NS_MERGE_SUCCESS_COUNT";
    private static final String MERGE_SUCCESS_TIME = "DOCUMENT_NS_MERGE_SUCCESS_TIME";
    private static final String MERGE_SUCCESS_SUSPENDED = "DOCUMENT_NS_MERGE_SUCCESS_SUSPENDED";
    private static final String MERGE_SUCCESS_EXCLUSIVE = "DOCUMENT_NS_MERGE_SUCCESS_EXCLUSIVE";
    static final String MERGE_FAILED_EXCLUSIVE = "DOCUMENT_NS_MERGE_FAILED_EXCLUSIVE";
    static final String BRANCH_COMMIT_COUNT = "DOCUMENT_NS_BRANCH_COMMIT_COUNT";
    static final String MERGE_BRANCH_COMMIT_COUNT = "DOCUMENT_NS_MERGE_BRANCH_COMMIT_COUNT";
    private final TimerStats readHead;
    private final TimerStats readCacheInvalidate;
    private final TimerStats readDiffCache;
    private final TimerStats readLock;
    private final TimerStats readDispatch;
    private final TimerStats readTotalTime;
    private final MeterStats numChangesRate;
    private final HistogramStats numChangesHisto;
    private final MeterStats changesLag;
    private final TimerStats writeClean;
    private final TimerStats writeSplit;
    private final TimerStats writeSweep;
    private final HistogramStats writeNum;
    private final TimerStats writeWrite;
    private final TimerStats writeTotal;
    private final MeterStats numWritesRate;
    private final TimerStats leaseUpdate;
    private final HistogramStats mergeSuccessRetries;
    private final MeterStats mergeSuccessRate;
    private final TimerStats mergeSuccessTime;
    private final MeterStats mergeSuccessExclusive;
    private final MeterStats mergeSuccessSuspended;
    private final MeterStats mergeFailedExclusive;
    private final MeterStats branchCommitRate;
    private final MeterStats mergeBranchCommitRate;

    public DocumentNodeStoreStats(StatisticsProvider sp) {
        this.readHead = sp.getTimer(BGR_READ_HEAD, StatsOptions.METRICS_ONLY);
        this.readCacheInvalidate = sp.getTimer(BGR_CACHE_INVALIDATE, StatsOptions.METRICS_ONLY);
        this.readDiffCache = sp.getTimer(BGR_DIFF_CACHE, StatsOptions.METRICS_ONLY);
        this.readLock = sp.getTimer(BGR_LOCK, StatsOptions.METRICS_ONLY);
        this.readDispatch = sp.getTimer(BGR_DISPATCH, StatsOptions.METRICS_ONLY);
        this.readTotalTime = sp.getTimer(BGR_TOTAL_TIME, StatsOptions.METRICS_ONLY);
        this.numChangesRate = sp.getMeter(BGR_NUM_CHANGES_RATE, StatsOptions.DEFAULT);
        this.numChangesHisto = sp.getHistogram(BGR_NUM_CHANGES_HISTO, StatsOptions.METRICS_ONLY);
        this.changesLag = sp.getMeter(BGR_LAG, StatsOptions.METRICS_ONLY);
        this.writeClean = sp.getTimer(BGW_CLEAN, StatsOptions.METRICS_ONLY);
        this.writeSplit = sp.getTimer(BGW_SPLIT, StatsOptions.METRICS_ONLY);
        this.writeSweep = sp.getTimer(BGW_SWEEP, StatsOptions.METRICS_ONLY);
        this.writeWrite = sp.getTimer(BGW_WRITE, StatsOptions.METRICS_ONLY);
        this.writeTotal = sp.getTimer(BGW_TOTAL, StatsOptions.METRICS_ONLY);
        this.writeNum = sp.getHistogram(BGW_NUM, StatsOptions.METRICS_ONLY);
        this.numWritesRate = sp.getMeter(BGW_NUM_WRITES_RATE, StatsOptions.DEFAULT);
        this.leaseUpdate = sp.getTimer(LEASE_UPDATE, StatsOptions.METRICS_ONLY);
        this.mergeSuccessRetries = sp.getHistogram(MERGE_SUCCESS_NUM_RETRY, StatsOptions.METRICS_ONLY);
        this.mergeSuccessRate = sp.getMeter(MERGE_SUCCESS_COUNT, StatsOptions.DEFAULT);
        this.mergeSuccessTime = sp.getTimer(MERGE_SUCCESS_TIME, StatsOptions.METRICS_ONLY);
        this.mergeSuccessExclusive = sp.getMeter(MERGE_SUCCESS_EXCLUSIVE, StatsOptions.METRICS_ONLY);
        this.mergeSuccessSuspended = sp.getMeter(MERGE_SUCCESS_SUSPENDED, StatsOptions.METRICS_ONLY);
        this.mergeFailedExclusive = sp.getMeter(MERGE_FAILED_EXCLUSIVE, StatsOptions.DEFAULT);
        this.branchCommitRate = sp.getMeter(BRANCH_COMMIT_COUNT, StatsOptions.DEFAULT);
        this.mergeBranchCommitRate = sp.getMeter(MERGE_BRANCH_COMMIT_COUNT, StatsOptions.DEFAULT);
    }

    @Override
    public void doneBackgroundRead(BackgroundReadStats stats) {
        this.readHead.update(stats.readHead, TimeUnit.MILLISECONDS);
        this.readCacheInvalidate.update(stats.cacheInvalidationTime, TimeUnit.MILLISECONDS);
        this.readDiffCache.update(stats.populateDiffCache, TimeUnit.MILLISECONDS);
        this.readLock.update(stats.lock, TimeUnit.MILLISECONDS);
        this.readDispatch.update(stats.dispatchChanges, TimeUnit.MILLISECONDS);
        this.readTotalTime.update(stats.totalReadTime, TimeUnit.MILLISECONDS);
        this.numChangesRate.mark(stats.numExternalChanges);
        this.numChangesHisto.update(stats.numExternalChanges);
        this.changesLag.mark(stats.externalChangesLag);
    }

    @Override
    public void doneBackgroundUpdate(BackgroundWriteStats stats) {
        this.writeClean.update(stats.clean, TimeUnit.MILLISECONDS);
        this.writeSplit.update(stats.split, TimeUnit.MILLISECONDS);
        this.writeSweep.update(stats.sweep, TimeUnit.MILLISECONDS);
        this.writeWrite.update(stats.write, TimeUnit.MILLISECONDS);
        this.writeTotal.update(stats.totalWriteTime, TimeUnit.MILLISECONDS);
        this.writeNum.update(stats.num);
        this.numWritesRate.mark(stats.num);
    }

    @Override
    public void doneLeaseUpdate(long timeMicros) {
        this.leaseUpdate.update(timeMicros, TimeUnit.MICROSECONDS);
    }

    @Override
    public void doneBranchCommit() {
        this.branchCommitRate.mark();
    }

    @Override
    public void doneMergeBranch(int numCommits) {
        this.mergeBranchCommitRate.mark((long)numCommits);
    }

    @Override
    public void doneMerge(int numRetries, long time, boolean suspended, boolean exclusive) {
        this.mergeSuccessRate.mark();
        this.mergeSuccessRetries.update((long)numRetries);
        this.mergeSuccessTime.update(time, TimeUnit.MILLISECONDS);
        if (exclusive) {
            this.mergeSuccessExclusive.mark();
        }
        if (suspended) {
            this.mergeSuccessSuspended.mark();
        }
    }

    @Override
    public void failedMerge(int numRetries, long timeMillis, boolean suspended, boolean exclusive) {
        if (exclusive) {
            this.mergeFailedExclusive.mark();
        }
    }
}

