/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.TreeTraverser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.cache.CacheValue;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.StringUtils;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;
import org.apache.jackrabbit.oak.commons.json.JsopWriter;
import org.apache.jackrabbit.oak.json.JsonSerializer;
import org.apache.jackrabbit.oak.plugins.document.AbstractDocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentBranchRootNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreBranch;
import org.apache.jackrabbit.oak.plugins.document.DocumentPropertyState;
import org.apache.jackrabbit.oak.plugins.document.DocumentRootBuilder;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.NodeStateDiffer;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.bundlor.BundlorUtils;
import org.apache.jackrabbit.oak.plugins.document.bundlor.DocumentBundlor;
import org.apache.jackrabbit.oak.plugins.document.bundlor.Matcher;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeBuilder;
import org.apache.jackrabbit.oak.spi.state.AbstractChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentNodeState
extends AbstractDocumentNodeState
implements CacheValue {
    private static final Logger log = LoggerFactory.getLogger(DocumentNodeState.class);
    public static final Children NO_CHILDREN = new Children();
    static final int INITIAL_FETCH_SIZE = 100;
    static final int MAX_FETCH_SIZE = 1600;
    private final String path;
    private final RevisionVector lastRevision;
    private final RevisionVector rootRevision;
    private final boolean fromExternalChange;
    private final Map<String, PropertyState> properties;
    private final boolean hasChildren;
    private final DocumentNodeStore store;
    private final BundlingContext bundlingContext;
    private AbstractDocumentNodeState cachedSecondaryState;

    DocumentNodeState(@NotNull DocumentNodeStore store, @NotNull String path, @NotNull RevisionVector rootRevision) {
        this(store, path, rootRevision, Collections.emptyList(), false, null);
    }

    DocumentNodeState(@NotNull DocumentNodeStore store, @NotNull String path, @NotNull RevisionVector rootRevision, Iterable<? extends PropertyState> properties, boolean hasChildren, @Nullable RevisionVector lastRevision) {
        this(store, path, rootRevision, DocumentNodeState.asMap(properties), hasChildren, lastRevision, false);
    }

    private DocumentNodeState(@NotNull DocumentNodeStore store, @NotNull String path, @NotNull RevisionVector rootRevision, @NotNull Map<String, PropertyState> properties, boolean hasChildren, @Nullable RevisionVector lastRevision, boolean fromExternalChange) {
        this(store, path, lastRevision, rootRevision, fromExternalChange, DocumentNodeState.createBundlingContext((Map)Preconditions.checkNotNull(properties), hasChildren));
    }

    protected DocumentNodeState(@NotNull DocumentNodeStore store, @NotNull String path, @Nullable RevisionVector lastRevision, @Nullable RevisionVector rootRevision, boolean fromExternalChange, BundlingContext bundlingContext) {
        this.store = (DocumentNodeStore)Preconditions.checkNotNull((Object)store);
        this.path = (String)Preconditions.checkNotNull((Object)path);
        this.rootRevision = (RevisionVector)Preconditions.checkNotNull((Object)rootRevision);
        this.lastRevision = lastRevision;
        this.fromExternalChange = fromExternalChange;
        this.properties = bundlingContext.getProperties();
        this.bundlingContext = bundlingContext;
        this.hasChildren = bundlingContext.hasChildren();
    }

    @Override
    public DocumentNodeState withRootRevision(@NotNull RevisionVector root, boolean externalChange) {
        if (this.rootRevision.equals(root) && this.fromExternalChange == externalChange) {
            return this;
        }
        return new DocumentNodeState(this.store, this.path, this.lastRevision, root, externalChange, this.bundlingContext);
    }

    @NotNull
    public DocumentNodeState fromExternalChange() {
        return new DocumentNodeState(this.store, this.path, this.lastRevision, this.rootRevision, true, this.bundlingContext);
    }

    @NotNull
    DocumentNodeState asBranchRootState(@NotNull DocumentNodeStoreBranch branch) {
        Preconditions.checkState((boolean)PathUtils.denotesRoot((String)this.path));
        Preconditions.checkState((boolean)this.getRootRevision().isBranch());
        return new DocumentBranchRootNodeState(this.store, branch, this.path, this.rootRevision, this.lastRevision, this.bundlingContext);
    }

    @Override
    public boolean isFromExternalChange() {
        return this.fromExternalChange;
    }

    @Override
    @NotNull
    public RevisionVector getRootRevision() {
        return this.rootRevision;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public RevisionVector getLastRevision() {
        return this.lastRevision;
    }

    public boolean exists() {
        return true;
    }

    public PropertyState getProperty(@NotNull String name) {
        return this.properties.get(name);
    }

    public boolean hasProperty(@NotNull String name) {
        return this.properties.containsKey(name);
    }

    @NotNull
    public Iterable<? extends PropertyState> getProperties() {
        if (this.bundlingContext.isBundled()) {
            return Iterables.filter(this.properties.values(), BundlorUtils.NOT_BUNDLOR_PROPS);
        }
        return this.properties.values();
    }

    public boolean hasChildNode(@NotNull String name) {
        if (!this.hasChildren || !DocumentNodeState.isValidName((String)name)) {
            return false;
        }
        return this.getChildNodeDoc(name) != null;
    }

    @NotNull
    public NodeState getChildNode(@NotNull String name) {
        if (!this.hasChildren) {
            DocumentNodeState.checkValidName((String)name);
            return EmptyNodeState.MISSING_NODE;
        }
        AbstractDocumentNodeState child = this.getChildNodeDoc(name);
        if (child == null) {
            DocumentNodeState.checkValidName((String)name);
            return EmptyNodeState.MISSING_NODE;
        }
        return child.withRootRevision(this.rootRevision, this.fromExternalChange);
    }

    public long getChildNodeCount(long max) {
        if (!this.hasChildren) {
            return 0L;
        }
        int bundledChildCount = this.bundlingContext.getBundledChildNodeNames().size();
        if (this.bundlingContext.hasOnlyBundledChildren()) {
            return bundledChildCount;
        }
        String name = null;
        long count = 0L;
        int fetchSize = 100;
        Children c = NO_CHILDREN;
        for (long remaining = Math.max(max, 1L); remaining > 0L; remaining -= (long)c.children.size()) {
            c = this.store.getChildren(this, name, fetchSize);
            count += (long)c.children.size();
            if (!c.hasMore) break;
            name = c.children.get(c.children.size() - 1);
            fetchSize = Math.min(fetchSize << 1, 1600);
        }
        if (!c.hasMore) {
            return count + (long)bundledChildCount;
        }
        return Long.MAX_VALUE;
    }

    public long getPropertyCount() {
        if (this.bundlingContext.isBundled()) {
            return Iterables.size(this.getProperties());
        }
        return this.properties.size();
    }

    @NotNull
    public Iterable<? extends ChildNodeEntry> getChildNodeEntries() {
        if (!this.hasChildren) {
            return Collections.emptyList();
        }
        AbstractDocumentNodeState secondaryState = this.getSecondaryNodeState();
        if (secondaryState != null) {
            return secondaryState.getChildNodeEntries();
        }
        return new Iterable<ChildNodeEntry>(){

            @Override
            public Iterator<ChildNodeEntry> iterator() {
                if (DocumentNodeState.this.bundlingContext.isBundled()) {
                    if (DocumentNodeState.this.bundlingContext.hasOnlyBundledChildren()) {
                        return DocumentNodeState.this.getBundledChildren();
                    }
                    return Iterators.concat((Iterator)DocumentNodeState.this.getBundledChildren(), (Iterator)new ChildNodeEntryIterator());
                }
                return new ChildNodeEntryIterator();
            }
        };
    }

    @NotNull
    public NodeBuilder builder() {
        if ("/".equals(this.getPath())) {
            if (this.getRootRevision().isBranch()) {
                throw new IllegalStateException("Cannot create builder from branched DocumentNodeState");
            }
            return new DocumentRootBuilder(this, this.store, this.store.createBranch(this));
        }
        return new MemoryNodeBuilder((NodeState)this);
    }

    public Set<String> getBundledChildNodeNames() {
        return this.bundlingContext.getBundledChildNodeNames();
    }

    public boolean hasOnlyBundledChildren() {
        if (this.bundlingContext.isBundled()) {
            return this.bundlingContext.hasOnlyBundledChildren();
        }
        return false;
    }

    String getPropertyAsString(String propertyName) {
        return this.asString(this.properties.get(propertyName));
    }

    private String asString(PropertyState prop) {
        if (prop == null) {
            return null;
        }
        if (prop instanceof DocumentPropertyState) {
            return ((DocumentPropertyState)prop).getValue();
        }
        JsopBuilder builder = new JsopBuilder();
        new JsonSerializer((JsopWriter)builder, this.store.getBlobSerializer()).serialize(prop);
        return builder.toString();
    }

    Set<String> getPropertyNames() {
        return this.properties.keySet();
    }

    @Override
    public boolean hasNoChildren() {
        return !this.hasChildren;
    }

    @Override
    protected NodeStateDiffer getNodeStateDiffer() {
        return this.store;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append("{ path: '").append(this.path).append("', ");
        buff.append("rootRevision: '").append(this.rootRevision).append("', ");
        buff.append("lastRevision: '").append(this.lastRevision).append("', ");
        buff.append("properties: '").append(this.properties.values()).append("' }");
        return buff.toString();
    }

    UpdateOp asOperation(@NotNull Revision revision) {
        String id = Utils.getIdFromPath(this.path);
        UpdateOp op = new UpdateOp(id, true);
        if (Utils.isLongPath(this.path)) {
            op.set("_path", this.path);
        }
        NodeDocument.setModified(op, revision);
        NodeDocument.setDeleted(op, revision, false);
        for (String p : this.properties.keySet()) {
            String key = Utils.escapePropertyName(p);
            op.setMapEntry(key, revision, this.getPropertyAsString(p));
        }
        return op;
    }

    String getId() {
        return this.path + "@" + this.lastRevision;
    }

    public int getMemory() {
        long size = 40 + (this.lastRevision != null ? this.lastRevision.getMemory() : 0) + this.rootRevision.getMemory() + StringUtils.estimateMemoryUsage((String)this.path);
        for (Map.Entry<String, PropertyState> entry : this.bundlingContext.getAllProperties().entrySet()) {
            size += (long)StringUtils.estimateMemoryUsage((String)entry.getKey());
            PropertyState propState = entry.getValue();
            if (propState.getType() != Type.BINARY && propState.getType() != Type.BINARIES) {
                for (int i = 0; i < propState.count(); ++i) {
                    size += (56L + propState.size(i) * 2L) * 2L;
                }
                continue;
            }
            size += (long)StringUtils.estimateMemoryUsage((String)this.asString(entry.getValue())) * 2L;
        }
        if (size > Integer.MAX_VALUE) {
            log.debug("Estimated memory footprint larger than Integer.MAX_VALUE: {}.", (Object)size);
            size = Integer.MAX_VALUE;
        }
        return (int)size;
    }

    public Iterable<DocumentNodeState> getAllBundledNodesStates() {
        return new TreeTraverser<DocumentNodeState>(){

            public Iterable<DocumentNodeState> children(DocumentNodeState root) {
                return Iterables.transform(() -> root.getBundledChildren(), ce -> (DocumentNodeState)ce.getNodeState());
            }
        }.preOrderTraversal((Object)this).filter(dns -> !dns.getPath().equals(this.getPath()));
    }

    @Nullable
    private AbstractDocumentNodeState getChildNodeDoc(String childNodeName) {
        AbstractDocumentNodeState secondaryState = this.getSecondaryNodeState();
        if (secondaryState != null) {
            NodeState result = secondaryState.getChildNode(childNodeName);
            if (result.exists()) {
                return (AbstractDocumentNodeState)result;
            }
            return null;
        }
        Matcher child = this.bundlingContext.matcher.next(childNodeName);
        if (child.isMatch()) {
            if (this.bundlingContext.hasChildNode(child.getMatchedPath())) {
                return this.createBundledState(childNodeName, child);
            }
            return null;
        }
        if (this.bundlingContext.hasOnlyBundledChildren()) {
            return null;
        }
        return this.store.getNode(PathUtils.concat((String)this.getPath(), (String)childNodeName), this.lastRevision);
    }

    @Nullable
    private AbstractDocumentNodeState getSecondaryNodeState() {
        if (this.cachedSecondaryState == null) {
            this.cachedSecondaryState = this.store.getSecondaryNodeState(this.getPath(), this.rootRevision, this.lastRevision);
        }
        return this.cachedSecondaryState;
    }

    @NotNull
    private Iterable<ChildNodeEntry> getChildNodeEntries(@Nullable String name, int limit) {
        Iterable<DocumentNodeState> children = this.store.getChildNodes(this, name, limit);
        return Iterables.transform(children, (Function)new Function<AbstractDocumentNodeState, ChildNodeEntry>(){

            public ChildNodeEntry apply(final AbstractDocumentNodeState input) {
                return new AbstractChildNodeEntry(){

                    @NotNull
                    public String getName() {
                        return PathUtils.getName((String)input.getPath());
                    }

                    @NotNull
                    public NodeState getNodeState() {
                        return input;
                    }
                };
            }
        });
    }

    private static Map<String, PropertyState> asMap(Iterable<? extends PropertyState> props) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (PropertyState propertyState : props) {
            builder.put((Object)propertyState.getName(), (Object)propertyState);
        }
        return builder.build();
    }

    public String asString() {
        JsopBuilder json = new JsopBuilder();
        json.key("path").value(this.path);
        json.key("rev").value(this.rootRevision.toString());
        if (this.lastRevision != null) {
            json.key("lastRev").value(this.lastRevision.toString());
        }
        if (this.hasChildren) {
            json.key("hasChildren").value(true);
        }
        if (this.properties.size() > 0) {
            json.key("prop").object();
            for (Map.Entry<String, PropertyState> e : this.bundlingContext.getAllProperties().entrySet()) {
                json.key(e.getKey()).value(this.asString(e.getValue()));
            }
            json.endObject();
        }
        return json.toString();
    }

    public static DocumentNodeState fromString(DocumentNodeStore store, String s) {
        JsopTokenizer json = new JsopTokenizer(s);
        String path = null;
        RevisionVector rootRev = null;
        RevisionVector lastRev = null;
        boolean hasChildren = false;
        HashMap<String, String> map = new HashMap<String, String>();
        while (true) {
            String k = json.readString();
            json.read(58);
            if ("path".equals(k)) {
                path = json.readString();
            } else if ("rev".equals(k)) {
                rootRev = RevisionVector.fromString(json.readString());
            } else if ("lastRev".equals(k)) {
                lastRev = RevisionVector.fromString(json.readString());
            } else if ("hasChildren".equals(k)) {
                hasChildren = json.read() == 3;
            } else if ("prop".equals(k)) {
                json.read(123);
                while (!json.matches(125)) {
                    k = json.readString();
                    json.read(58);
                    String v = json.readString();
                    map.put(k, v);
                    json.matches(44);
                }
            }
            if (json.matches(0)) break;
            json.read(44);
        }
        ArrayList props = Lists.newArrayListWithCapacity((int)map.size());
        for (Map.Entry e : map.entrySet()) {
            String value = (String)e.getValue();
            if (value == null) continue;
            props.add(store.createPropertyState((String)e.getKey(), value));
        }
        return new DocumentNodeState(store, path, rootRev, props, hasChildren, lastRev);
    }

    private AbstractDocumentNodeState createBundledState(String childNodeName, Matcher child) {
        return new DocumentNodeState(this.store, PathUtils.concat((String)this.path, (String)childNodeName), this.lastRevision, this.rootRevision, this.fromExternalChange, this.bundlingContext.childContext(child));
    }

    private Iterator<ChildNodeEntry> getBundledChildren() {
        return Iterators.transform(this.bundlingContext.getBundledChildNodeNames().iterator(), (Function)new Function<String, ChildNodeEntry>(){

            public ChildNodeEntry apply(final String childNodeName) {
                return new AbstractChildNodeEntry(){

                    @NotNull
                    public String getName() {
                        return childNodeName;
                    }

                    @NotNull
                    public NodeState getNodeState() {
                        return DocumentNodeState.this.createBundledState(childNodeName, ((DocumentNodeState)DocumentNodeState.this).bundlingContext.matcher.next(childNodeName));
                    }
                };
            }
        });
    }

    private static BundlingContext createBundlingContext(Map<String, PropertyState> properties, boolean hasNonBundledChildren) {
        PropertyState bundlorConfig = properties.get(":doc-pattern");
        Matcher matcher = Matcher.NON_MATCHING;
        boolean hasBundledChildren = false;
        if (bundlorConfig != null) {
            matcher = DocumentBundlor.from(bundlorConfig).createMatcher();
            hasBundledChildren = DocumentNodeState.hasBundledProperty(properties, matcher, ":doc-has-child-bundled");
        }
        return new BundlingContext(matcher, properties, hasBundledChildren, hasNonBundledChildren);
    }

    private static boolean hasBundledProperty(Map<String, PropertyState> props, Matcher matcher, String propName) {
        String key = PathUtils.concat((String)matcher.getMatchedPath(), (String)propName);
        return props.containsKey(key);
    }

    protected static class BundlingContext {
        final Matcher matcher;
        final Map<String, PropertyState> rootProperties;
        final boolean hasBundledChildren;
        final boolean hasNonBundledChildren;

        public BundlingContext(Matcher matcher, Map<String, PropertyState> rootProperties, boolean hasBundledChildren, boolean hasNonBundledChildren) {
            this.matcher = matcher;
            this.rootProperties = ImmutableMap.copyOf(rootProperties);
            this.hasBundledChildren = hasBundledChildren;
            this.hasNonBundledChildren = hasNonBundledChildren;
        }

        public BundlingContext childContext(Matcher childMatcher) {
            return new BundlingContext(childMatcher, this.rootProperties, this.hasBundledChildren(childMatcher), this.hasNonBundledChildren(childMatcher));
        }

        public Map<String, PropertyState> getProperties() {
            if (this.matcher.isMatch()) {
                return BundlorUtils.getMatchingProperties(this.rootProperties, this.matcher);
            }
            return this.rootProperties;
        }

        public boolean isBundled() {
            return this.matcher.isMatch();
        }

        public Map<String, PropertyState> getAllProperties() {
            return this.rootProperties;
        }

        public boolean hasChildNode(String relativePath) {
            String key = PathUtils.concat((String)relativePath, (String)":doc-self-path");
            return this.rootProperties.containsKey(key);
        }

        public boolean hasChildren() {
            return this.hasNonBundledChildren || this.hasBundledChildren;
        }

        public boolean hasOnlyBundledChildren() {
            return !this.hasNonBundledChildren;
        }

        public Set<String> getBundledChildNodeNames() {
            if (this.isBundled()) {
                return BundlorUtils.getChildNodeNames(this.rootProperties.keySet(), this.matcher);
            }
            return Collections.emptySet();
        }

        private boolean hasBundledChildren(Matcher matcher) {
            if (this.isBundled()) {
                return DocumentNodeState.hasBundledProperty(this.rootProperties, matcher, ":doc-has-child-bundled");
            }
            return false;
        }

        private boolean hasNonBundledChildren(Matcher matcher) {
            if (this.isBundled()) {
                return DocumentNodeState.hasBundledProperty(this.rootProperties, matcher, ":doc-has-child-non-bundled");
            }
            return false;
        }
    }

    private class ChildNodeEntryIterator
    implements Iterator<ChildNodeEntry> {
        private String previousName;
        private Iterator<ChildNodeEntry> current;
        private int fetchSize;
        private int currentRemaining;

        ChildNodeEntryIterator() {
            this.currentRemaining = this.fetchSize = 100;
            this.fetchMore();
        }

        @Override
        public boolean hasNext() {
            while (this.current != null) {
                if (this.current.hasNext()) {
                    return true;
                }
                if (this.currentRemaining > 0) {
                    return false;
                }
                this.fetchMore();
            }
            return false;
        }

        @Override
        public ChildNodeEntry next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ChildNodeEntry entry = this.current.next();
            this.previousName = entry.getName();
            --this.currentRemaining;
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void fetchMore() {
            Iterator entries = DocumentNodeState.this.getChildNodeEntries(this.previousName, this.fetchSize).iterator();
            this.currentRemaining = this.fetchSize;
            this.fetchSize = Math.min(this.fetchSize * 2, 1600);
            this.current = entries.hasNext() ? entries : null;
        }
    }

    public static class Children
    implements CacheValue {
        final ArrayList<String> children = new ArrayList();
        long cachedMemory;
        boolean hasMore;

        public int getMemory() {
            if (this.cachedMemory == 0L) {
                long size = 48L;
                if (!this.children.isEmpty()) {
                    size = 114L;
                    for (String c : this.children) {
                        size += (long)StringUtils.estimateMemoryUsage((String)c) + 8L;
                    }
                }
                this.cachedMemory = size;
            }
            if (this.cachedMemory > Integer.MAX_VALUE) {
                log.debug("Estimated memory footprint larger than Integer.MAX_VALUE: {}.", (Object)this.cachedMemory);
                return Integer.MAX_VALUE;
            }
            return (int)this.cachedMemory;
        }

        public String toString() {
            return this.children.toString();
        }

        public String asString() {
            JsopBuilder json = new JsopBuilder();
            if (this.hasMore) {
                json.key("hasMore").value(true);
            }
            if (this.children.size() > 0) {
                json.key("children").array();
                for (String c : this.children) {
                    json.value(c);
                }
                json.endArray();
            }
            return json.toString();
        }

        public static Children fromString(String s) {
            JsopTokenizer json = new JsopTokenizer(s);
            Children children = new Children();
            while (!json.matches(0)) {
                String k = json.readString();
                json.read(58);
                if ("hasMore".equals(k)) {
                    children.hasMore = json.read() == 3;
                } else if ("children".equals(k)) {
                    json.read(91);
                    while (!json.matches(93)) {
                        String value = json.readString();
                        children.children.add(value);
                        json.matches(44);
                    }
                }
                if (json.matches(0)) break;
                json.read(44);
            }
            return children;
        }
    }
}

