/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.persistentCache.async;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.async.CacheAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheActionDispatcher
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(CacheActionDispatcher.class);
    static final int MAX_SIZE = 16384;
    final BlockingQueue<CacheAction<?, ?>> queue = new ArrayBlockingQueue(16384);
    private volatile boolean isRunning = true;

    @Override
    public void run() {
        while (this.isRunning) {
            try {
                CacheAction<?, ?> action = this.queue.poll(10L, TimeUnit.MILLISECONDS);
                if (action == null || !this.isRunning) continue;
                action.execute();
            }
            catch (InterruptedException e) {
                LOG.debug("Interrupted the queue.poll()", (Throwable)e);
            }
        }
    }

    public void stop() {
        this.isRunning = false;
    }

    boolean add(CacheAction<?, ?> action) {
        return this.queue.offer(action);
    }
}

