/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import com.mongodb.ReadPreference;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.SplitDocumentCleanUp;
import org.apache.jackrabbit.oak.plugins.document.VersionGCSupport;
import org.apache.jackrabbit.oak.plugins.document.VersionGarbageCollector;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.util.CloseableIterable;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.stats.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoVersionGCSupport
extends VersionGCSupport {
    private static final Logger LOG = LoggerFactory.getLogger(MongoVersionGCSupport.class);
    private static final DBObject SD_TYPE_HINT = QueryBuilder.start((String)"_sdType").is((Object)1).get();
    private final MongoDocumentStore store;
    private final int batchSize = Integer.getInteger("oak.mongo.queryDeletedDocsBatchSize", 1000);

    public MongoVersionGCSupport(MongoDocumentStore store) {
        super(store);
        this.store = store;
    }

    public CloseableIterable<NodeDocument> getPossiblyDeletedDocs(long fromModified, long toModified) {
        DBObject query = QueryBuilder.start((String)"_deletedOnce").is((Object)Boolean.TRUE).put("_modified").greaterThanEquals((Object)NodeDocument.getModifiedInSecs(fromModified)).lessThan((Object)NodeDocument.getModifiedInSecs(toModified)).get();
        DBCursor cursor = this.getNodeCollection().find(query).setReadPreference(ReadPreference.secondaryPreferred());
        cursor.batchSize(this.batchSize);
        return CloseableIterable.wrap(Iterables.transform((Iterable)cursor, (Function)new Function<DBObject, NodeDocument>(){

            public NodeDocument apply(DBObject input) {
                return MongoVersionGCSupport.this.store.convertFromDBObject(Collection.NODES, input);
            }
        }), (Closeable)cursor);
    }

    @Override
    public long getDeletedOnceCount() {
        DBObject query = QueryBuilder.start((String)"_deletedOnce").is((Object)Boolean.TRUE).get();
        return this.getNodeCollection().count(query, ReadPreference.secondaryPreferred());
    }

    @Override
    protected SplitDocumentCleanUp createCleanUp(Set<NodeDocument.SplitDocType> gcTypes, RevisionVector sweepRevs, long oldestRevTimeStamp, VersionGarbageCollector.VersionGCStats stats) {
        return new MongoSplitDocCleanUp(gcTypes, sweepRevs, oldestRevTimeStamp, stats);
    }

    @Override
    protected Iterable<NodeDocument> identifyGarbage(Set<NodeDocument.SplitDocType> gcTypes, final RevisionVector sweepRevs, long oldestRevTimeStamp) {
        return Iterables.filter((Iterable)Iterables.transform((Iterable)this.getNodeCollection().find(this.createQuery(gcTypes, sweepRevs, oldestRevTimeStamp)), (Function)new Function<DBObject, NodeDocument>(){

            public NodeDocument apply(DBObject input) {
                return MongoVersionGCSupport.this.store.convertFromDBObject(Collection.NODES, input);
            }
        }), (Predicate)new Predicate<NodeDocument>(){

            public boolean apply(NodeDocument input) {
                return !MongoVersionGCSupport.isDefaultNoBranchSplitNewerThan(input, sweepRevs);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getOldestDeletedOnceTimestamp(Clock clock, long precisionMs) {
        LOG.debug("getOldestDeletedOnceTimestamp() <- start");
        DBObject query = QueryBuilder.start((String)"_deletedOnce").is((Object)Boolean.TRUE).get();
        DBCursor cursor = this.getNodeCollection().find(query).sort(QueryBuilder.start((String)"_modified").is((Object)1).get()).limit(1);
        CloseableIterable results = CloseableIterable.wrap(Iterables.transform((Iterable)cursor, (Function)new Function<DBObject, NodeDocument>(){

            public NodeDocument apply(DBObject input) {
                return MongoVersionGCSupport.this.store.convertFromDBObject(Collection.NODES, input);
            }
        }), (Closeable)cursor);
        try {
            Iterator i = results.iterator();
            if (i.hasNext()) {
                NodeDocument doc = (NodeDocument)i.next();
                long modifiedMs = doc.getModified() * TimeUnit.SECONDS.toMillis(1L);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("getOldestDeletedOnceTimestamp() -> {}", (Object)Utils.timestampToString(modifiedMs));
                }
                long l = modifiedMs;
                return l;
            }
        }
        finally {
            Utils.closeIfCloseable(results);
        }
        LOG.debug("getOldestDeletedOnceTimestamp() -> none found, return current time");
        return clock.getTime();
    }

    private DBObject createQuery(Set<NodeDocument.SplitDocType> gcTypes, RevisionVector sweepRevs, long oldestRevTimeStamp) {
        ArrayList gcTypeCodes = Lists.newArrayList();
        QueryBuilder orClause = QueryBuilder.start();
        for (NodeDocument.SplitDocType type : gcTypes) {
            gcTypeCodes.add(type.typeCode());
            for (DBObject query : this.queriesForType(type, sweepRevs)) {
                orClause.or(new DBObject[]{query});
            }
        }
        return QueryBuilder.start().and(new DBObject[]{QueryBuilder.start((String)"_sdType").in((Object)gcTypeCodes).get(), orClause.get(), QueryBuilder.start((String)"_sdMaxRevTime").lessThan((Object)NodeDocument.getModifiedInSecs(oldestRevTimeStamp)).get()}).get();
    }

    @Nonnull
    private Iterable<DBObject> queriesForType(NodeDocument.SplitDocType type, RevisionVector sweepRevs) {
        if (type != NodeDocument.SplitDocType.DEFAULT_NO_BRANCH) {
            return Collections.singletonList(QueryBuilder.start((String)"_sdType").is((Object)type.typeCode()).get());
        }
        ArrayList queries = Lists.newArrayList();
        for (Revision r : sweepRevs) {
            String idSuffix = Utils.getPreviousIdFor("/", r, 0);
            idSuffix = idSuffix.substring(idSuffix.lastIndexOf(45));
            QueryBuilder idPathClause = QueryBuilder.start();
            idPathClause.or(new DBObject[]{QueryBuilder.start((String)"_id").regex(Pattern.compile(".*" + idSuffix)).get()});
            idPathClause.or(new DBObject[]{QueryBuilder.start((String)"_id").regex(Pattern.compile("[^-]*")).and("_path").regex(Pattern.compile(".*" + idSuffix)).get()});
            queries.add(QueryBuilder.start((String)"_sdType").is((Object)type.typeCode()).and(new DBObject[]{idPathClause.get()}).and("_sdMaxRevTime").lessThan((Object)NodeDocument.getModifiedInSecs(r.getTimestamp())).get());
        }
        return queries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logSplitDocIdsTobeDeleted(DBObject query) {
        ImmutableList ids;
        BasicDBObject keys = new BasicDBObject("_id", (Object)1);
        try (DBCursor cursor = this.getNodeCollection().find(query, (DBObject)keys).setReadPreference(this.store.getConfiguredReadPreference(Collection.NODES));){
            ids = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)cursor, (Function)new Function<DBObject, String>(){

                public String apply(DBObject input) {
                    return (String)input.get("_id");
                }
            }));
        }
        StringBuilder sb = new StringBuilder("Split documents with following ids were deleted as part of GC \n");
        Joiner.on((String)StandardSystemProperty.LINE_SEPARATOR.value()).appendTo(sb, (Iterable)ids);
        LOG.debug(sb.toString());
    }

    private DBCollection getNodeCollection() {
        return this.store.getDBCollection(Collection.NODES);
    }

    private class MongoSplitDocCleanUp
    extends SplitDocumentCleanUp {
        final Set<NodeDocument.SplitDocType> gcTypes;
        final RevisionVector sweepRevs;
        final long oldestRevTimeStamp;

        MongoSplitDocCleanUp(Set<NodeDocument.SplitDocType> gcTypes, RevisionVector sweepRevs, long oldestRevTimeStamp, VersionGarbageCollector.VersionGCStats stats) {
            super(MongoVersionGCSupport.this.store, stats, MongoVersionGCSupport.this.identifyGarbage(gcTypes, sweepRevs, oldestRevTimeStamp));
            this.gcTypes = gcTypes;
            this.sweepRevs = sweepRevs;
            this.oldestRevTimeStamp = oldestRevTimeStamp;
        }

        @Override
        protected void collectIdToBeDeleted(String id) {
        }

        @Override
        protected int deleteSplitDocuments() {
            DBObject query = MongoVersionGCSupport.this.createQuery(this.gcTypes, this.sweepRevs, this.oldestRevTimeStamp);
            if (LOG.isDebugEnabled()) {
                MongoVersionGCSupport.this.logSplitDocIdsTobeDeleted(query);
            }
            return MongoVersionGCSupport.this.getNodeCollection().remove(query).getN();
        }
    }
}

