/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.google.common.base.Suppliers;
import com.mongodb.DB;
import com.mongodb.MongoClientOptions;
import com.mongodb.ReadConcernLevel;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.plugins.blob.ReferencedBlob;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreBuilder;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.MissingLastRevSeeker;
import org.apache.jackrabbit.oak.plugins.document.VersionGCSupport;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoBlobReferenceIterator;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoBlobStore;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentNodeStoreBuilder;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoMissingLastRevSeeker;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoStatus;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoVersionGCSupport;
import org.apache.jackrabbit.oak.plugins.document.util.MongoConnection;
import org.apache.jackrabbit.oak.spi.blob.GarbageCollectableBlobStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MongoDocumentNodeStoreBuilderBase<T extends MongoDocumentNodeStoreBuilderBase<T>>
extends DocumentNodeStoreBuilder<T> {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDocumentNodeStoreBuilder.class);
    private String mongoUri;
    private boolean socketKeepAlive;
    private MongoStatus mongoStatus;
    private long maxReplicationLagMillis = TimeUnit.HOURS.toMillis(6L);

    public T setMongoDB(@Nonnull String uri, @Nonnull String name, int blobCacheSizeMB) throws UnknownHostException {
        this.mongoUri = uri;
        MongoClientOptions.Builder options = MongoConnection.getDefaultBuilder();
        options.socketKeepAlive(this.socketKeepAlive);
        DB db = new MongoConnection(uri, options).getDB(name);
        MongoStatus status = new MongoStatus(db);
        if (!MongoConnection.hasWriteConcern(uri)) {
            db.setWriteConcern(MongoConnection.getDefaultWriteConcern(db));
        }
        if (status.isMajorityReadConcernSupported() && status.isMajorityReadConcernEnabled() && !MongoConnection.hasReadConcern(uri)) {
            db.setReadConcern(MongoConnection.getDefaultReadConcern(db));
        }
        this.setMongoDB(db, status, blobCacheSizeMB);
        return (T)((MongoDocumentNodeStoreBuilderBase)this.thisBuilder());
    }

    public T setMongoDB(@Nonnull DB db, int blobCacheSizeMB) {
        return this.setMongoDB(db, new MongoStatus(db), blobCacheSizeMB);
    }

    public T setMongoDB(@Nonnull DB db) {
        return this.setMongoDB(db, 16);
    }

    public T setSocketKeepAlive(boolean enable) {
        this.socketKeepAlive = enable;
        return (T)((MongoDocumentNodeStoreBuilderBase)this.thisBuilder());
    }

    public T setMaxReplicationLag(long duration, TimeUnit unit) {
        this.maxReplicationLagMillis = unit.toMillis(duration);
        return (T)((MongoDocumentNodeStoreBuilderBase)this.thisBuilder());
    }

    @Override
    public VersionGCSupport createVersionGCSupport() {
        DocumentStore store = this.getDocumentStore();
        if (store instanceof MongoDocumentStore) {
            return new MongoVersionGCSupport((MongoDocumentStore)store);
        }
        return super.createVersionGCSupport();
    }

    @Override
    public Iterable<ReferencedBlob> createReferencedBlobs(DocumentNodeStore ns) {
        DocumentStore store = this.getDocumentStore();
        if (store instanceof MongoDocumentStore) {
            return () -> new MongoBlobReferenceIterator(ns, (MongoDocumentStore)store);
        }
        return super.createReferencedBlobs(ns);
    }

    @Override
    public MissingLastRevSeeker createMissingLastRevSeeker() {
        DocumentStore store = this.getDocumentStore();
        if (store instanceof MongoDocumentStore) {
            return new MongoMissingLastRevSeeker((MongoDocumentStore)store, this.getClock());
        }
        return super.createMissingLastRevSeeker();
    }

    String getMongoUri() {
        return this.mongoUri;
    }

    MongoStatus getMongoStatus() {
        return this.mongoStatus;
    }

    long getMaxReplicationLagMillis() {
        return this.maxReplicationLagMillis;
    }

    private T setMongoDB(@Nonnull DB db, MongoStatus status, int blobCacheSizeMB) {
        if (!MongoConnection.hasSufficientWriteConcern(db)) {
            LOG.warn("Insufficient write concern: " + db.getWriteConcern() + " At least " + MongoConnection.getDefaultWriteConcern(db) + " is recommended.");
        }
        if (status.isMajorityReadConcernSupported() && !status.isMajorityReadConcernEnabled()) {
            LOG.warn("The read concern should be enabled on mongod using --enableMajorityReadConcern");
        } else if (status.isMajorityReadConcernSupported() && !MongoConnection.hasSufficientReadConcern(db)) {
            ReadConcernLevel currentLevel = MongoConnection.readConcernLevel(db.getReadConcern());
            ReadConcernLevel recommendedLevel = MongoConnection.readConcernLevel(MongoConnection.getDefaultReadConcern(db));
            if (currentLevel == null) {
                LOG.warn("Read concern hasn't been set. At least " + recommendedLevel + " is recommended.");
            } else {
                LOG.warn("Insufficient read concern: " + currentLevel + ". At least " + recommendedLevel + " is recommended.");
            }
        }
        this.mongoStatus = status;
        this.documentStoreSupplier = Suppliers.memoize(() -> new MongoDocumentStore(db, this));
        if (this.blobStore == null) {
            MongoBlobStore s = new MongoBlobStore(db, (long)(blobCacheSizeMB * 1024) * 1024L);
            this.setGCBlobStore((GarbageCollectableBlobStore)s);
        }
        return (T)((MongoDocumentNodeStoreBuilderBase)this.thisBuilder());
    }
}

