/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.commons.sort.StringSort;
import org.apache.jackrabbit.oak.plugins.document.AbstractDocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.Branch;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.DiffCache;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.JournalEntry;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.util.StringValue;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JournalDiffLoader
implements DiffCache.Loader {
    private static final Logger LOG = LoggerFactory.getLogger(JournalDiffLoader.class);
    private final AbstractDocumentNodeState base;
    private final AbstractDocumentNodeState node;
    private final DocumentNodeStore ns;
    private Stats stats;

    JournalDiffLoader(@Nonnull AbstractDocumentNodeState base, @Nonnull AbstractDocumentNodeState node, @Nonnull DocumentNodeStore ns) {
        this.base = (AbstractDocumentNodeState)((Object)Preconditions.checkNotNull((Object)((Object)base)));
        this.node = (AbstractDocumentNodeState)((Object)Preconditions.checkNotNull((Object)((Object)node)));
        this.ns = (DocumentNodeStore)Preconditions.checkNotNull((Object)ns);
        Preconditions.checkArgument((boolean)base.getPath().equals(node.getPath()), (String)"nodes must have matching paths: {} != {}", (Object[])new Object[]{base.getPath(), node.getPath()});
    }

    @Override
    public String call() {
        String path = this.node.getPath();
        RevisionVector afterRev = this.node.getRootRevision();
        RevisionVector beforeRev = this.base.getRootRevision();
        this.stats = new Stats(path, beforeRev, afterRev);
        StringSort changes = JournalEntry.newSorter();
        try {
            this.readTrunkChanges(path, beforeRev, afterRev, changes);
            this.readBranchChanges(path, beforeRev, changes);
            this.readBranchChanges(path, afterRev, changes);
            changes.sort();
            DiffCache df = this.ns.getDiffCache();
            WrappedDiffCache wrappedCache = new WrappedDiffCache(this.node.getPath(), df, this.stats);
            JournalEntry.applyTo((Iterable<String>)changes, wrappedCache, path, beforeRev, afterRev);
            String string = wrappedCache.changes;
            return string;
        }
        catch (IOException e) {
            throw DocumentStoreException.convert(e);
        }
        finally {
            Utils.closeIfCloseable(changes);
            this.logStats();
        }
    }

    private void readBranchChanges(String path, RevisionVector rv, StringSort changes) throws IOException {
        if (!rv.isBranch() || this.ns.isDisableBranches()) {
            return;
        }
        Branch b = this.ns.getBranches().getBranch(rv);
        if (b == null) {
            if (!this.ns.getBranches().isBranchBase(rv)) {
                JournalDiffLoader.missingBranch(rv);
            }
            return;
        }
        DocumentStore store = this.ns.getDocumentStore();
        for (Revision br : b.getCommits()) {
            Branch.BranchCommit bc = b.getCommit(br);
            if (bc.isRebase()) continue;
            JournalEntry entry = store.find(Collection.JOURNAL, JournalEntry.asId(br));
            if (entry != null) {
                entry.addTo(changes, path);
                this.stats.numJournalEntries++;
                continue;
            }
            LOG.warn("Missing journal entry for {}", (Object)JournalEntry.asId(br));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readTrunkChanges(String path, RevisionVector beforeRev, RevisionVector afterRev, StringSort changes) throws IOException {
        JournalEntry localPending = this.ns.getCurrentJournalEntry();
        DocumentStore store = this.ns.getDocumentStore();
        NodeDocument root = Utils.getRootDocument(store);
        int clusterId = this.ns.getClusterId();
        Map<Integer, Revision> lastRevs = root.getLastRev();
        Revision localLastRev = clusterId == 0 ? afterRev.getRevision(clusterId) : lastRevs.get(clusterId);
        if (localLastRev == null) {
            throw new IllegalStateException("Root document does not have a lastRev entry for local clusterId " + clusterId);
        }
        if (this.ns.isDisableBranches()) {
            beforeRev = beforeRev.asTrunkRevision();
            afterRev = afterRev.asTrunkRevision();
        } else {
            beforeRev = this.getBaseRevision(beforeRev);
            afterRev = this.getBaseRevision(afterRev);
        }
        if (beforeRev.equals(afterRev)) {
            return;
        }
        RevisionVector max = beforeRev.pmax(afterRev);
        RevisionVector min = beforeRev.pmin(afterRev);
        if (!max.isRevisionNewer(localLastRev) && !localLastRev.equals(max.getRevision(clusterId))) {
            localPending.addTo(changes, path);
            this.stats.numJournalEntries++;
        }
        for (Revision to : max) {
            Revision from = min.getRevision(to.getClusterId());
            if (from == null) {
                from = new Revision(0L, 0, to.getClusterId());
            }
            try (StringSort invalidateOnly = JournalEntry.newSorter();){
                Stats stats = this.stats;
                stats.numJournalEntries = stats.numJournalEntries + (long)JournalEntry.fillExternalChanges(changes, invalidateOnly, path, from, to, this.ns.getDocumentStore(), null, null);
            }
        }
    }

    @Nonnull
    private RevisionVector getBaseRevision(RevisionVector rv) {
        if (!rv.isBranch()) {
            return rv;
        }
        Branch b = this.ns.getBranches().getBranch(rv);
        if (b != null) {
            rv = b.getBase(rv.getBranchRevision());
        } else if (this.ns.getBranches().isBranchBase(rv)) {
            rv = rv.asTrunkRevision();
        } else {
            JournalDiffLoader.missingBranch(rv);
        }
        return rv;
    }

    private static void missingBranch(RevisionVector rv) {
        throw new IllegalStateException("Missing branch for revision " + rv);
    }

    private void logStats() {
        this.stats.sw.stop();
        long timeInSec = this.stats.sw.elapsed(TimeUnit.SECONDS);
        if (timeInSec > 60L) {
            LOG.warn(this.stats.toString());
        } else if (timeInSec > 10L) {
            LOG.info(this.stats.toString());
        } else {
            LOG.debug(this.stats.toString());
        }
    }

    private static class WrappedDiffCache
    extends DiffCache {
        private final String path;
        private String changes = "";
        private final DiffCache cache;
        private Stats stats;

        WrappedDiffCache(String path, DiffCache cache, Stats stats) {
            this.path = path;
            this.cache = cache;
            this.stats = stats;
        }

        @CheckForNull
        String getChanges() {
            return this.changes;
        }

        @Override
        String getChanges(@Nonnull RevisionVector from, @Nonnull RevisionVector to, @Nonnull String path, @Nullable DiffCache.Loader loader) {
            return this.cache.getChanges(from, to, path, loader);
        }

        @Override
        @Nonnull
        DiffCache.Entry newEntry(final @Nonnull RevisionVector from, final @Nonnull RevisionVector to, boolean local) {
            final DiffCache.Entry entry = this.cache.newEntry(from, to, local);
            return new DiffCache.Entry(){

                @Override
                public void append(@Nonnull String path, @Nonnull String changes) {
                    this.trackStats(path, from, to, changes);
                    entry.append(path, changes);
                    if (path.equals(path)) {
                        changes = changes;
                    }
                }

                @Override
                public boolean done() {
                    return entry.done();
                }
            };
        }

        private void trackStats(String path, RevisionVector from, RevisionVector to, String changes) {
            this.stats.numDiffEntries++;
            Stats stats = this.stats;
            stats.keyMemory = stats.keyMemory + (long)new StringValue(path).getMemory();
            stats = this.stats;
            stats.keyMemory = stats.keyMemory + (long)from.getMemory();
            stats = this.stats;
            stats.keyMemory = stats.keyMemory + (long)to.getMemory();
            stats = this.stats;
            stats.valueMemory = stats.valueMemory + (long)new StringValue(changes).getMemory();
        }

        @Override
        @Nonnull
        Iterable<CacheStats> getStats() {
            return this.cache.getStats();
        }
    }

    private static class Stats {
        private final Stopwatch sw = Stopwatch.createStarted();
        private final String path;
        private final RevisionVector from;
        private final RevisionVector to;
        private long numJournalEntries;
        private long numDiffEntries;
        private long keyMemory;
        private long valueMemory;

        Stats(String path, RevisionVector from, RevisionVector to) {
            this.path = path;
            this.from = from;
            this.to = to;
        }

        public String toString() {
            String msg = "%d diffs for %s (%s/%s) loaded from %d journal entries in %s. Keys: %s, values: %s, total: %s";
            return String.format(msg, this.numDiffEntries, this.path, this.from, this.to, this.numJournalEntries, this.sw, FileUtils.byteCountToDisplaySize((long)this.keyMemory), FileUtils.byteCountToDisplaySize((long)this.valueMemory), FileUtils.byteCountToDisplaySize((long)(this.keyMemory + this.valueMemory)));
        }
    }
}

