/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;

abstract class DiffCache {
    DiffCache() {
    }

    @CheckForNull
    abstract String getChanges(@Nonnull RevisionVector var1, @Nonnull RevisionVector var2, @Nonnull String var3, @Nullable Loader var4);

    @Nonnull
    abstract Entry newEntry(@Nonnull RevisionVector var1, @Nonnull RevisionVector var2, boolean var3);

    @Nonnull
    abstract Iterable<CacheStats> getStats();

    static boolean parseJsopDiff(@Nonnull String jsop, @Nonnull Diff diff) {
        int r;
        if (jsop.trim().isEmpty()) {
            return true;
        }
        JsopTokenizer t = new JsopTokenizer(jsop);
        boolean continueComparison = true;
        block5: while (continueComparison && (r = t.read()) != 0) {
            switch (r) {
                case 43: {
                    String name = t.readString();
                    t.read(58);
                    t.read(123);
                    while (t.read() != 125) {
                    }
                    continueComparison = diff.childNodeAdded(name);
                    continue block5;
                }
                case 45: {
                    String name = t.readString();
                    continueComparison = diff.childNodeDeleted(name);
                    continue block5;
                }
                case 94: {
                    String name = t.readString();
                    t.read(58);
                    t.read(123);
                    t.read(125);
                    continueComparison = diff.childNodeChanged(name);
                    continue block5;
                }
            }
            throw new IllegalArgumentException("jsonDiff: illegal token '" + t.getToken() + "' at pos: " + t.getLastPos() + ' ' + jsop);
        }
        return continueComparison;
    }

    static interface Diff {
        public boolean childNodeAdded(String var1);

        public boolean childNodeChanged(String var1);

        public boolean childNodeDeleted(String var1);
    }

    static interface Loader {
        public String call();
    }

    static interface Entry {
        public void append(@Nonnull String var1, @Nonnull String var2);

        public boolean done();
    }
}

