/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.management.openmbean.CompositeData;
import org.apache.jackrabbit.api.stats.TimeSeries;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreStatsCollector;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreStatsMBean;
import org.apache.jackrabbit.oak.plugins.document.util.CreateMetricUpdater;
import org.apache.jackrabbit.oak.plugins.document.util.ModifyMetricUpdater;
import org.apache.jackrabbit.oak.plugins.document.util.RemoveMetricUpdater;
import org.apache.jackrabbit.oak.plugins.document.util.StatsCollectorUtil;
import org.apache.jackrabbit.oak.plugins.document.util.UpsertMetricUpdater;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.apache.jackrabbit.oak.stats.TimerStats;
import org.apache.jackrabbit.stats.TimeSeriesStatsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentStoreStats
implements DocumentStoreStatsCollector,
DocumentStoreStatsMBean {
    private final Logger perfLog = LoggerFactory.getLogger((String)(DocumentStoreStats.class.getName() + ".perf"));
    public static final int PERF_LOG_THRESHOLD = 1;
    static final String NODES_FIND_CACHED = "DOCUMENT_NODES_FIND_CACHED";
    static final String NODES_FIND_SPLIT = "DOCUMENT_NODES_FIND_SPLIT";
    static final String NODES_FIND_SLAVE = "DOCUMENT_NODES_FIND_SLAVE";
    static final String NODES_FIND_PRIMARY = "DOCUMENT_NODES_FIND_PRIMARY";
    static final String NODES_FIND_MISSING = "DOCUMENT_NODES_FIND_MISSING";
    static final String NODES_FIND_MISSING_TIMER = "DOCUMENT_NODES_FIND_MISSING_TIMER";
    static final String NODES_FIND_TIMER = "DOCUMENT_NODES_FIND";
    static final String NODES_QUERY_FIND_READ_COUNT = "DOCUMENT_NODES_QUERY_FIND";
    static final String NODES_QUERY_FILTER = "DOCUMENT_NODES_QUERY_FILTER";
    static final String NODES_QUERY_TIMER = "DOCUMENT_NODES_QUERY";
    static final String NODES_QUERY_SLAVE = "DOCUMENT_NODES_QUERY_SLAVE";
    static final String NODES_QUERY_PRIMARY = "DOCUMENT_NODES_QUERY_PRIMARY";
    static final String NODES_QUERY_LOCK = "DOCUMENT_NODES_QUERY_LOCK";
    static final String NODES_QUERY_LOCK_TIMER = "DOCUMENT_NODES_QUERY_LOCK_TIMER";
    static final String NODES_CREATE = "DOCUMENT_NODES_CREATE";
    static final String NODES_CREATE_UPSERT = "DOCUMENT_NODES_CREATE_UPSERT";
    static final String NODES_CREATE_SPLIT = "DOCUMENT_NODES_CREATE_SPLIT";
    static final String NODES_CREATE_UPSERT_TIMER = "DOCUMENT_NODES_CREATE_UPSERT_TIMER";
    static final String NODES_CREATE_TIMER = "DOCUMENT_NODES_CREATE_TIMER";
    static final String NODES_UPDATE = "DOCUMENT_NODES_UPDATE";
    static final String NODES_UPDATE_FAILURE = "DOCUMENT_NODES_UPDATE_FAILURE";
    static final String NODES_UPDATE_RETRY_COUNT = "DOCUMENT_NODES_UPDATE_RETRY";
    static final String NODES_UPDATE_TIMER = "DOCUMENT_NODES_UPDATE_TIMER";
    static final String NODES_REMOVE = "DOCUMENT_NODES_REMOVE";
    static final String NODES_REMOVE_TIMER = "DOCUMENT_NODES_REMOVE_TIMER";
    static final String NODES_PREFETCH = "DOCUMENT_NODES_PREFETCH";
    static final String NODES_PREFETCH_TIMER = "DOCUMENT_NODES_PREFETCH_TIMER";
    static final String JOURNAL_QUERY = "DOCUMENT_JOURNAL_QUERY";
    static final String JOURNAL_CREATE = "DOCUMENT_JOURNAL_CREATE";
    static final String JOURNAL_QUERY_TIMER = "DOCUMENT_JOURNAL_QUERY_TIMER";
    static final String JOURNAL_CREATE_TIMER = "DOCUMENT_JOURNAL_CREATE_TIMER";
    private final MeterStats findNodesCachedMeter;
    private final MeterStats findNodesMissing;
    private final TimerStats findNodesMissingTimer;
    private final MeterStats findNodesSlave;
    private final TimerStats findNodesTimer;
    private final MeterStats findNodesPrimary;
    private final MeterStats queryNodesSlave;
    private final MeterStats queryNodesPrimary;
    private final MeterStats queryNodesResult;
    private final TimerStats queryNodesWithFilterTimer;
    private final TimerStats queryNodesTimer;
    private final MeterStats queryJournal;
    private final TimerStats queryJournalTimer;
    private final TimerStats createNodeUpsertTimer;
    private final TimerStats createNodeTimer;
    private final TimerStats updateNodeTimer;
    private final MeterStats createNodeUpsertMeter;
    private final MeterStats createNodeMeter;
    private final MeterStats updateNodeMeter;
    private final MeterStats createJournal;
    private final TimerStats createJournalTimer;
    private final MeterStats findSplitNodes;
    private final StatisticsProvider statisticsProvider;
    private final MeterStats queryNodesLock;
    private final TimerStats queryNodesLockTimer;
    private final MeterStats createSplitNodeMeter;
    private final MeterStats updateNodeFailureMeter;
    private final MeterStats updateNodeRetryCountMeter;
    private final MeterStats removeNodes;
    private final TimerStats removeNodesTimer;
    private final MeterStats prefetchNodes;
    private final TimerStats prefetchNodesTimer;
    private final RemoveMetricUpdater removeMetricUpdater;
    private final CreateMetricUpdater createMetricUpdater;
    private final UpsertMetricUpdater upsertMetricUpdater;
    private final ModifyMetricUpdater modifyMetricUpdater;

    public DocumentStoreStats(StatisticsProvider provider) {
        this.statisticsProvider = (StatisticsProvider)Preconditions.checkNotNull((Object)provider);
        this.findNodesCachedMeter = provider.getMeter(NODES_FIND_CACHED, StatsOptions.DEFAULT);
        this.findNodesMissing = provider.getMeter(NODES_FIND_MISSING, StatsOptions.DEFAULT);
        this.findNodesMissingTimer = provider.getTimer(NODES_FIND_MISSING_TIMER, StatsOptions.METRICS_ONLY);
        this.findNodesTimer = provider.getTimer(NODES_FIND_TIMER, StatsOptions.METRICS_ONLY);
        this.findSplitNodes = provider.getMeter(NODES_FIND_SPLIT, StatsOptions.DEFAULT);
        this.findNodesSlave = provider.getMeter(NODES_FIND_SLAVE, StatsOptions.DEFAULT);
        this.findNodesPrimary = provider.getMeter(NODES_FIND_PRIMARY, StatsOptions.DEFAULT);
        this.queryNodesSlave = provider.getMeter(NODES_QUERY_SLAVE, StatsOptions.DEFAULT);
        this.queryNodesPrimary = provider.getMeter(NODES_QUERY_PRIMARY, StatsOptions.DEFAULT);
        this.queryNodesResult = provider.getMeter(NODES_QUERY_FIND_READ_COUNT, StatsOptions.DEFAULT);
        this.queryNodesWithFilterTimer = provider.getTimer(NODES_QUERY_FILTER, StatsOptions.METRICS_ONLY);
        this.queryNodesTimer = provider.getTimer(NODES_QUERY_TIMER, StatsOptions.METRICS_ONLY);
        this.queryJournal = provider.getMeter(JOURNAL_QUERY, StatsOptions.DEFAULT);
        this.queryJournalTimer = provider.getTimer(JOURNAL_QUERY_TIMER, StatsOptions.METRICS_ONLY);
        this.createJournal = provider.getMeter(JOURNAL_CREATE, StatsOptions.DEFAULT);
        this.createJournalTimer = provider.getTimer(JOURNAL_CREATE_TIMER, StatsOptions.METRICS_ONLY);
        this.createNodeUpsertTimer = provider.getTimer(NODES_CREATE_UPSERT_TIMER, StatsOptions.METRICS_ONLY);
        this.createNodeTimer = provider.getTimer(NODES_CREATE_TIMER, StatsOptions.METRICS_ONLY);
        this.updateNodeTimer = provider.getTimer(NODES_UPDATE_TIMER, StatsOptions.METRICS_ONLY);
        this.createNodeMeter = provider.getMeter(NODES_CREATE, StatsOptions.DEFAULT);
        this.createNodeUpsertMeter = provider.getMeter(NODES_CREATE_UPSERT, StatsOptions.DEFAULT);
        this.createSplitNodeMeter = provider.getMeter(NODES_CREATE_SPLIT, StatsOptions.DEFAULT);
        this.updateNodeMeter = provider.getMeter(NODES_UPDATE, StatsOptions.DEFAULT);
        this.updateNodeFailureMeter = provider.getMeter(NODES_UPDATE_FAILURE, StatsOptions.DEFAULT);
        this.updateNodeRetryCountMeter = provider.getMeter(NODES_UPDATE_RETRY_COUNT, StatsOptions.DEFAULT);
        this.queryNodesLock = provider.getMeter(NODES_QUERY_LOCK, StatsOptions.DEFAULT);
        this.queryNodesLockTimer = provider.getTimer(NODES_QUERY_LOCK_TIMER, StatsOptions.METRICS_ONLY);
        this.removeNodes = provider.getMeter(NODES_REMOVE, StatsOptions.DEFAULT);
        this.removeNodesTimer = provider.getTimer(NODES_REMOVE_TIMER, StatsOptions.METRICS_ONLY);
        this.prefetchNodes = provider.getMeter(NODES_PREFETCH, StatsOptions.DEFAULT);
        this.prefetchNodesTimer = provider.getTimer(NODES_PREFETCH_TIMER, StatsOptions.METRICS_ONLY);
        this.removeMetricUpdater = new RemoveMetricUpdater(this.removeNodes, this.removeNodesTimer);
        this.createMetricUpdater = new CreateMetricUpdater(this.createNodeMeter, this.createSplitNodeMeter, this.createNodeTimer, this.createJournal, this.createJournalTimer);
        this.upsertMetricUpdater = new UpsertMetricUpdater(this.createNodeUpsertMeter, this.createSplitNodeMeter, this.createNodeUpsertTimer);
        this.modifyMetricUpdater = new ModifyMetricUpdater(this.createNodeUpsertMeter, this.createNodeUpsertTimer, this.updateNodeMeter, this.updateNodeTimer, this.updateNodeRetryCountMeter, this.updateNodeFailureMeter);
    }

    @Override
    public void doneFindCached(Collection<? extends Document> collection, String key) {
        if (collection == Collection.NODES) {
            this.findNodesCachedMeter.mark();
        }
    }

    @Override
    public void doneFindUncached(long timeTakenNanos, Collection<? extends Document> collection, String key, boolean docFound, boolean isSlaveOk) {
        if (collection == Collection.NODES) {
            TimerStats timer;
            if (docFound) {
                timer = this.findNodesTimer;
            } else {
                timer = this.findNodesMissingTimer;
                this.findNodesMissing.mark();
            }
            timer.update(timeTakenNanos, TimeUnit.NANOSECONDS);
            if (isSlaveOk) {
                this.findNodesSlave.mark();
            } else {
                this.findNodesPrimary.mark();
            }
            if (Utils.isPreviousDocId(key)) {
                this.findSplitNodes.mark();
            }
        }
        StatsCollectorUtil.perfLog(this.perfLog, 1, timeTakenNanos, "findUncached on key={}, isSlaveOk={}", key, isSlaveOk);
    }

    @Override
    public void doneQuery(long timeTakenNanos, Collection<? extends Document> collection, String fromKey, String toKey, boolean indexedProperty, int resultSize, long lockTime, boolean isSlaveOk) {
        if (collection == Collection.NODES) {
            TimerStats timer = indexedProperty ? this.queryNodesWithFilterTimer : this.queryNodesTimer;
            timer.update(timeTakenNanos, TimeUnit.NANOSECONDS);
            this.queryNodesResult.mark((long)resultSize);
            if (isSlaveOk) {
                this.queryNodesSlave.mark();
            } else {
                this.queryNodesPrimary.mark();
            }
            if (lockTime > 0L) {
                this.queryNodesLock.mark();
                this.queryNodesLockTimer.update(lockTime, TimeUnit.NANOSECONDS);
            }
        } else if (collection == Collection.JOURNAL) {
            this.queryJournal.mark((long)resultSize);
            this.queryJournalTimer.update(timeTakenNanos, TimeUnit.NANOSECONDS);
        }
        StatsCollectorUtil.perfLog(this.perfLog, 1, timeTakenNanos, "query for children from [{}] to [{}], lock:{}", fromKey, toKey, lockTime);
    }

    @Override
    public void doneCreate(long timeTakenNanos, Collection<? extends Document> collection, List<String> ids, boolean insertSuccess) {
        this.createMetricUpdater.update(collection, timeTakenNanos, ids, insertSuccess, StatsCollectorUtil.isNodesCollectionUpdated(), StatsCollectorUtil.getCreateStatsConsumer(), c -> c == Collection.JOURNAL, StatsCollectorUtil.getJournalStatsConsumer());
        StatsCollectorUtil.perfLog(this.perfLog, 1, timeTakenNanos, "create", new Object[0]);
    }

    @Override
    public void doneCreateOrUpdate(long timeTakenNanos, Collection<? extends Document> collection, List<String> ids) {
        this.upsertMetricUpdater.update(collection, timeTakenNanos, ids, StatsCollectorUtil.isNodesCollectionUpdated(), StatsCollectorUtil.getCreateStatsConsumer());
        StatsCollectorUtil.perfLog(this.perfLog, 1, timeTakenNanos, "createOrUpdate {}", ids);
    }

    @Override
    public void doneFindAndModify(long timeTakenNanos, Collection<? extends Document> collection, String key, boolean newEntry, boolean success, int retryCount) {
        this.modifyMetricUpdater.update(collection, retryCount, timeTakenNanos, success, newEntry, List.of(key), StatsCollectorUtil.isNodesCollectionUpdated(), StatsCollectorUtil.getStatsConsumer(), StatsCollectorUtil.getStatsConsumer(), MeterStats::mark, MeterStats::mark);
        StatsCollectorUtil.perfLog(this.perfLog, 1, timeTakenNanos, "findAndModify [{}]", key);
    }

    @Override
    public void doneFindAndModify(long timeTakenNanos, Collection<? extends Document> collection, List<String> ids, boolean success, int retryCount) {
        this.modifyMetricUpdater.update(collection, retryCount, timeTakenNanos, success, false, ids, StatsCollectorUtil.isNodesCollectionUpdated(), StatsCollectorUtil.getStatsConsumer(), StatsCollectorUtil.getStatsConsumer(), MeterStats::mark, MeterStats::mark);
        StatsCollectorUtil.perfLog(this.perfLog, 1, timeTakenNanos, "findAndModify {}", ids);
    }

    @Override
    public void doneRemove(long timeTakenNanos, Collection<? extends Document> collection, int removeCount) {
        this.removeMetricUpdater.update(collection, removeCount, timeTakenNanos, StatsCollectorUtil.isNodesCollectionUpdated(), StatsCollectorUtil.getStatsConsumer());
        StatsCollectorUtil.perfLog(this.perfLog, 1, timeTakenNanos, "remove [{}]", removeCount);
    }

    @Override
    public void donePrefetch(long timeTakenNanos, Collection<? extends Document> collection, List<String> ids) {
        if (collection == Collection.NODES) {
            this.prefetchNodes.mark((long)ids.size());
            this.prefetchNodesTimer.update(timeTakenNanos, TimeUnit.NANOSECONDS);
        }
        StatsCollectorUtil.perfLog(this.perfLog, 1, timeTakenNanos, "prefetch {}", ids);
    }

    @Override
    public long getNodesFindCount() {
        return this.findNodesSlave.getCount() + this.queryNodesPrimary.getCount();
    }

    @Override
    public long getNodesFindQueryCount() {
        return this.queryNodesSlave.getCount() + this.queryNodesPrimary.getCount();
    }

    @Override
    public long getNodesFindMissingCount() {
        return this.findNodesMissing.getCount();
    }

    @Override
    public long getNodesReadByQueryCount() {
        return this.queryNodesResult.getCount();
    }

    @Override
    public long getNodesCreateCount() {
        return this.createNodeMeter.getCount() + this.createNodeUpsertMeter.getCount();
    }

    @Override
    public long getNodesUpdateCount() {
        return this.updateNodeMeter.getCount();
    }

    @Override
    public long getNodesRemoveCount() {
        return this.removeNodes.getCount();
    }

    @Override
    public long getJournalCreateCount() {
        return this.createJournal.getCount();
    }

    @Override
    public long getJournalReadCount() {
        return this.queryJournal.getCount();
    }

    @Override
    public long getNodesPrefetchCount() {
        return this.prefetchNodes.getCount();
    }

    @Override
    public CompositeData getFindCachedNodesHistory() {
        return this.getTimeSeriesData(NODES_FIND_CACHED, "Number of find node document calls served from the cache.");
    }

    @Override
    public CompositeData getFindSplitNodesHistory() {
        return this.getTimeSeriesData(NODES_FIND_SPLIT, "Number of un-cached find calls for split document.");
    }

    @Override
    public CompositeData getFindNodesFromPrimaryHistory() {
        return this.getTimeSeriesData(NODES_FIND_PRIMARY, "Number of un-cached find node document calls targeting the primary.");
    }

    @Override
    public CompositeData getFindNodesFromSlaveHistory() {
        return this.getTimeSeriesData(NODES_FIND_SLAVE, "Number of un-cached find node document calls targeting a slave/secondary.");
    }

    @Override
    public CompositeData getFindNodesMissingHistory() {
        return this.getTimeSeriesData(NODES_FIND_MISSING, "Number of un-cached find node document calls that returned no document.");
    }

    @Override
    public CompositeData getQueryNodesFromSlaveHistory() {
        return this.getTimeSeriesData(NODES_QUERY_SLAVE, "Number of queries for node documents targeting a slave/secondary.");
    }

    @Override
    public CompositeData getQueryNodesFromPrimaryHistory() {
        return this.getTimeSeriesData(NODES_QUERY_PRIMARY, "Number of queries for node documents targeting the primary.");
    }

    @Override
    public CompositeData getQueryNodesLockHistory() {
        return this.getTimeSeriesData(NODES_QUERY_LOCK, "Number of queries for node documents done while holding a lock.");
    }

    @Override
    public CompositeData getQueryJournalHistory() {
        return this.getTimeSeriesData(JOURNAL_QUERY, "Number of queries for journal documents.");
    }

    @Override
    public CompositeData getCreateJournalHistory() {
        return this.getTimeSeriesData(JOURNAL_CREATE, "Number of journal documents created.");
    }

    @Override
    public CompositeData getCreateNodesHistory() {
        return this.getTimeSeriesData(NODES_CREATE, "Number of node documents created.");
    }

    @Override
    public CompositeData getUpdateNodesHistory() {
        return this.getTimeSeriesData(NODES_UPDATE, "Number of node documents updated.");
    }

    @Override
    public CompositeData getUpdateNodesRetryHistory() {
        return this.getTimeSeriesData(NODES_UPDATE_RETRY_COUNT, "Number of times a node document update had to be retried.");
    }

    @Override
    public CompositeData getUpdateNodesFailureHistory() {
        return this.getTimeSeriesData(NODES_UPDATE_FAILURE, "Number of times a node document update failed.");
    }

    @Override
    public CompositeData getRemoveNodesHistory() {
        return this.getTimeSeriesData(NODES_REMOVE, "Number of removed node documents.");
    }

    @Override
    public CompositeData getPrefetchNodesHistory() {
        return this.getTimeSeriesData(NODES_PREFETCH, "Number of prefetched node documents.");
    }

    private CompositeData getTimeSeriesData(String name, String desc) {
        return TimeSeriesStatsUtil.asCompositeData((TimeSeries)this.getTimeSeries(name), (String)desc);
    }

    private TimeSeries getTimeSeries(String name) {
        return this.statisticsProvider.getStats().getTimeSeries(name, true);
    }
}

