/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Path;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.VersionGarbageCollector;
import org.apache.jackrabbit.oak.plugins.document.util.LogSilencer;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitDocumentCleanUp
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(SplitDocumentCleanUp.class);
    private static final LogSilencer LOG_SILENCER = new LogSilencer();
    private static final int DELETE_BATCH_SIZE = 100;
    protected final DocumentStore store;
    protected final Iterable<NodeDocument> splitDocGarbage;
    protected final VersionGarbageCollector.VersionGCStats stats;
    protected final List<String> idsToBeDeleted = Lists.newArrayList();
    protected int deleteCount;

    protected SplitDocumentCleanUp(DocumentStore store, VersionGarbageCollector.VersionGCStats stats, Iterable<NodeDocument> splitDocGarbage) {
        this.store = store;
        this.stats = stats;
        this.splitDocGarbage = splitDocGarbage;
    }

    protected SplitDocumentCleanUp disconnect() {
        for (NodeDocument splitDoc : this.splitDocGarbage) {
            this.disconnect(splitDoc);
            this.collectIdToBeDeleted(splitDoc.getId());
        }
        return this;
    }

    protected void collectIdToBeDeleted(String id) {
        this.idsToBeDeleted.add(id);
        if (this.idsToBeDeleted.size() >= 100) {
            this.removeFromDocumentStore(this.idsToBeDeleted);
            this.deleteCount += this.idsToBeDeleted.size();
            this.idsToBeDeleted.clear();
        }
    }

    protected int deleteSplitDocuments() {
        this.removeFromDocumentStore(this.idsToBeDeleted);
        return this.idsToBeDeleted.size() + this.deleteCount;
    }

    private void removeFromDocumentStore(List<String> ids) {
        try {
            this.stats.deleteSplitDocs.start();
            this.store.remove(Collection.NODES, ids);
        }
        finally {
            this.stats.deleteSplitDocs.stop();
        }
    }

    private void removeFromDocumentStore(String id) {
        try {
            this.stats.deleteSplitDocs.start();
            this.store.remove(Collection.NODES, id);
        }
        finally {
            this.stats.deleteSplitDocs.stop();
        }
    }

    private void disconnect(NodeDocument splitDoc) {
        String splitId = splitDoc.getId();
        String mainId = Utils.getIdFromPath(splitDoc.getMainPath());
        NodeDocument doc = this.store.find(Collection.NODES, mainId);
        if (doc == null) {
            LOG.warn("Main document {} already removed. Split document is {}", (Object)mainId, (Object)splitId);
            return;
        }
        Path splitDocPath = splitDoc.getPath();
        int height = Integer.parseInt(splitDocPath.getName());
        Revision rev = Revision.fromString(splitDocPath.getParent().getName());
        if ((doc = doc.findPrevReferencingDoc(rev, height)) == null) {
            LOG.warn("Split document {} for path {} not referenced anymore. Main document is {}", new Object[]{splitId, splitDocPath, mainId});
            return;
        }
        if (doc.getSplitDocType() == NodeDocument.SplitDocType.INTERMEDIATE) {
            this.disconnectFromIntermediate(doc, rev);
        } else {
            this.markStaleOnMain(doc, rev, height);
        }
    }

    private void disconnectFromIntermediate(NodeDocument splitDoc, Revision rev) {
        Preconditions.checkArgument((splitDoc.getSplitDocType() == NodeDocument.SplitDocType.INTERMEDIATE ? 1 : 0) != 0, (String)"Illegal type: %s", (Object[])new Object[]{splitDoc.getSplitDocType()});
        String splitDocId = splitDoc.getId();
        UpdateOp update = new UpdateOp(splitDocId, false);
        NodeDocument.removePrevious(update, rev);
        NodeDocument old = this.store.findAndUpdate(Collection.NODES, update);
        if (old != null && old.getPreviousRanges().size() == 1 && old.getPreviousRanges().containsKey(rev)) {
            this.disconnect(old);
            this.removeFromDocumentStore(old.getId());
            ++this.stats.intermediateSplitDocGCCount;
        } else if (old == null) {
            if (!LOG_SILENCER.silence(splitDocId)) {
                LOG.warn("Split document reference could not be removed from intermediate {} -{}", (Object)splitDocId, (Object)" (similar log silenced for a while)");
            } else {
                LOG.debug("Split document reference could not be removed from intermediate {}", (Object)splitDocId);
            }
        }
    }

    final void markStaleOnMain(NodeDocument main, Revision rev, int height) {
        Preconditions.checkArgument((main.getSplitDocType() == NodeDocument.SplitDocType.NONE ? 1 : 0) != 0, (String)"Illegal type: %s", (Object[])new Object[]{main.getSplitDocType()});
        UpdateOp update = new UpdateOp(main.getId(), false);
        NodeDocument.setStalePrevious(update, rev, height);
        this.store.findAndUpdate(Collection.NODES, update);
    }

    @Override
    public void close() throws IOException {
        Utils.closeIfCloseable(this.splitDocGarbage);
    }
}

