/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.jackrabbit.oak.commons.TimeDurationFormatter;
import org.apache.jackrabbit.oak.plugins.document.CommitValueResolver;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.NodeDocumentSweepListener;
import org.apache.jackrabbit.oak.plugins.document.Path;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionContext;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MissingBcSweeper2 {
    private static final Logger LOG = LoggerFactory.getLogger(MissingBcSweeper2.class);
    private static final int YIELD_SIZE = 500;
    private static final int INVALIDATE_BATCH_SIZE = 100;
    private static final long LOGINTERVALMS = TimeUnit.MINUTES.toMillis(1L);
    private final RevisionContext context;
    private final CommitValueResolver commitValueResolver;
    private final int executingClusterId;
    private final List<Integer> includedClusterIds;
    private final RevisionVector headRevision;
    private final AtomicBoolean isDisposed;
    private long totalCount;
    private long lastCount;
    private long startOfScan;
    private long lastLog;

    MissingBcSweeper2(RevisionContext context, CommitValueResolver commitValueResolver, List<Integer> includedClusterIds, AtomicBoolean isDisposed) {
        this.context = (RevisionContext)Preconditions.checkNotNull((Object)context);
        this.commitValueResolver = (CommitValueResolver)Preconditions.checkNotNull((Object)commitValueResolver);
        this.executingClusterId = context.getClusterId();
        this.includedClusterIds = includedClusterIds == null ? new LinkedList() : Collections.unmodifiableList(includedClusterIds);
        this.headRevision = context.getHeadRevision();
        this.isDisposed = isDisposed;
    }

    void sweep2(@NotNull Iterable<NodeDocument> documents, @NotNull NodeDocumentSweepListener listener) throws DocumentStoreException {
        this.performSweep2(documents, (NodeDocumentSweepListener)Preconditions.checkNotNull((Object)listener));
    }

    private void performSweep2(Iterable<NodeDocument> documents, NodeDocumentSweepListener listener) throws DocumentStoreException {
        this.totalCount = 0L;
        this.lastCount = 0L;
        this.lastLog = this.startOfScan = this.context.getClock().getTime();
        Iterable<Map.Entry<Path, UpdateOp>> ops = this.sweepOperations(documents);
        for (List batch : Iterables.partition(ops, (int)100)) {
            HashMap updates = Maps.newHashMap();
            for (Map.Entry entry : batch) {
                updates.put((Path)entry.getKey(), (UpdateOp)entry.getValue());
            }
            listener.sweepUpdate(updates);
            if (!this.isDisposed.get()) continue;
            throw new DocumentStoreException("sweep2 interrupted by shutdown");
        }
        LOG.debug("Document sweep2 finished");
    }

    private Iterable<Map.Entry<Path, UpdateOp>> sweepOperations(Iterable<NodeDocument> docs) {
        return Iterables.filter((Iterable)Iterables.transform(docs, (Function)new Function<NodeDocument, Map.Entry<Path, UpdateOp>>(){
            int yieldCnt = 0;
            long lastYield = MissingBcSweeper2.access$000(MissingBcSweeper2.this).getClock().getTime();

            public Map.Entry<Path, UpdateOp> apply(NodeDocument doc) {
                if (++this.yieldCnt >= 500) {
                    try {
                        long now = MissingBcSweeper2.this.context.getClock().getTime();
                        long timeSinceLastYield = now - this.lastYield;
                        long waitUntil = now + Math.max(1L, timeSinceLastYield);
                        MissingBcSweeper2.this.context.getClock().waitUntil(waitUntil);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.lastYield = MissingBcSweeper2.this.context.getClock().getTime();
                    this.yieldCnt = 0;
                }
                return Maps.immutableEntry((Object)doc.getPath(), (Object)MissingBcSweeper2.this.sweepOne(doc));
            }
        }), (Predicate)new Predicate<Map.Entry<Path, UpdateOp>>(){

            public boolean apply(Map.Entry<Path, UpdateOp> input) {
                return input.getValue() != null;
            }
        });
    }

    private UpdateOp sweepOne(NodeDocument doc) throws DocumentStoreException {
        UpdateOp op = null;
        for (String property : Iterables.filter(doc.keySet(), Utils.COMMITROOT_OR_REVISIONS)) {
            SortedMap<Revision, String> valueMap = doc.getLocalMap(property);
            for (Map.Entry entry : valueMap.entrySet()) {
                Revision cRev;
                Revision rev = (Revision)entry.getKey();
                if (!this.includedClusterIds.isEmpty() && !this.includedClusterIds.contains(rev.getClusterId()) || (cRev = this.getCommitRevision(doc, rev)) == null || cRev.equals(rev)) continue;
                if (op == null) {
                    op = MissingBcSweeper2.createUpdateOp(doc);
                }
                this.committedBranch(doc, property, rev, cRev, op);
            }
        }
        ++this.totalCount;
        ++this.lastCount;
        long now = this.context.getClock().getTime();
        long lastElapsed = now - this.lastLog;
        if (lastElapsed >= LOGINTERVALMS) {
            TimeDurationFormatter df = TimeDurationFormatter.forLogging();
            long totalElapsed = now - this.startOfScan;
            long totalRateMin = this.totalCount * TimeUnit.MINUTES.toMillis(1L) / totalElapsed;
            long lastRateMin = this.lastCount * TimeUnit.MINUTES.toMillis(1L) / lastElapsed;
            String restrictionMsg = this.includedClusterIds.isEmpty() ? "unrestricted, ie for all clusterIds" : "restricted to clusterIds " + this.includedClusterIds;
            String message = String.format("Sweep2 executed by cluster node [%d] (%s): %d nodes scanned in %s (~%d/m) - last interval %d nodes in %s (~%d/m)", this.executingClusterId, restrictionMsg, this.totalCount, df.format(totalElapsed, TimeUnit.MILLISECONDS), totalRateMin, this.lastCount, df.format(lastElapsed, TimeUnit.MILLISECONDS), lastRateMin);
            LOG.info(message);
            this.lastLog = now;
            this.lastCount = 0L;
        }
        return op == null ? null : (op.hasChanges() ? op : null);
    }

    private boolean isV18BranchCommit(Revision rev, NodeDocument doc) {
        return doc.getLocalBranchCommits().contains(rev);
    }

    private void committedBranch(NodeDocument doc, String property, Revision rev, Revision cRev, UpdateOp op) {
        boolean newerThanHead = this.headRevision.isRevisionNewer(cRev);
        if (LOG.isDebugEnabled()) {
            String msg = newerThanHead ? " (newer than head)" : "";
            LOG.debug("Committed branch change on {}, {} @ {}/{}{}", new Object[]{op.getId(), property, rev, cRev, msg});
        }
        if (!this.isV18BranchCommit(rev, doc)) {
            NodeDocument.setBranchCommit(op, rev);
        }
    }

    private static UpdateOp createUpdateOp(NodeDocument doc) {
        return new UpdateOp(doc.getId(), false);
    }

    private String getCommitValue(@NotNull Revision changeRevision, @NotNull NodeDocument doc) {
        return this.commitValueResolver.resolve(changeRevision, doc);
    }

    @Nullable
    private Revision getCommitRevision(NodeDocument doc, Revision rev) throws DocumentStoreException {
        String cv = this.getCommitValue(rev, doc);
        if (cv == null) {
            return null;
        }
        return Utils.resolveCommitRevision(rev, cv);
    }
}

