/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.cache.Cache;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.cache.CacheValue;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;
import org.apache.jackrabbit.oak.plugins.document.DiffCache;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreBuilder;
import org.apache.jackrabbit.oak.plugins.document.Path;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.util.RevisionsKey;
import org.apache.jackrabbit.oak.plugins.document.util.StringValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDiffCache
extends DiffCache {
    private static final Logger LOG = LoggerFactory.getLogger(LocalDiffCache.class);
    private static int MAX_ENTRY_SIZE = 0x1000000;
    private final Cache<RevisionsKey, Diff> diffCache;
    private final CacheStats diffCacheStats;

    LocalDiffCache(DocumentNodeStoreBuilder<?> builder) {
        this.diffCache = builder.buildLocalDiffCache();
        this.diffCacheStats = new CacheStats(this.diffCache, "Document-LocalDiff", builder.getWeigher(), builder.getLocalDiffCacheSize());
    }

    @Override
    public String getChanges(@NotNull RevisionVector from, @NotNull RevisionVector to, @NotNull Path path, @Nullable DiffCache.Loader loader) {
        RevisionsKey key = new RevisionsKey(from, to);
        Diff diff = (Diff)this.diffCache.getIfPresent((Object)key);
        if (diff != null) {
            String result = diff.get(path);
            return result != null ? result : "";
        }
        if (loader != null) {
            return loader.call();
        }
        return null;
    }

    @Override
    @NotNull
    public DiffCache.Entry newEntry(final @NotNull RevisionVector from, final @NotNull RevisionVector to, boolean local) {
        return new DiffCache.Entry(){
            private final Map<Path, String> changesPerPath = Maps.newHashMap();
            private long size;

            @Override
            public void append(@NotNull Path path, @NotNull String changes) {
                if (this.exceedsSize()) {
                    return;
                }
                this.size += (long)path.getMemory() + LocalDiffCache.size(changes);
                this.changesPerPath.put(path, changes);
            }

            @Override
            public boolean done() {
                if (this.exceedsSize()) {
                    return false;
                }
                LocalDiffCache.this.diffCache.put((Object)new RevisionsKey(from, to), (Object)new Diff(this.changesPerPath, this.size));
                LOG.debug("Adding cache entry from {} to {}", (Object)from, (Object)to);
                return true;
            }

            private boolean exceedsSize() {
                return this.size > (long)MAX_ENTRY_SIZE;
            }
        };
    }

    @Override
    @NotNull
    public Iterable<CacheStats> getStats() {
        return Collections.singleton(this.diffCacheStats);
    }

    @Override
    public void invalidateAll() {
        this.diffCache.invalidateAll();
    }

    private static long size(String s) {
        return StringValue.getMemory(s);
    }

    public static final class Diff
    implements CacheValue {
        private final Map<Path, String> changes;
        private long memory;

        public Diff(Map<Path, String> changes, long memory) {
            this.changes = changes;
            this.memory = memory;
        }

        public static Diff fromString(String value) {
            HashMap map = Maps.newHashMap();
            JsopTokenizer reader = new JsopTokenizer(value);
            while (!reader.matches(0)) {
                String k = reader.readString();
                reader.read(58);
                String v = reader.readString();
                map.put(Path.fromString(k), v);
                if (reader.matches(0)) break;
                reader.read(44);
            }
            return new Diff(map, 0L);
        }

        public String asString() {
            JsopBuilder builder = new JsopBuilder();
            for (Map.Entry<Path, String> entry : this.changes.entrySet()) {
                builder.key(entry.getKey().toString());
                builder.value(entry.getValue());
            }
            return builder.toString();
        }

        public Map<Path, String> getChanges() {
            return Collections.unmodifiableMap(this.changes);
        }

        public int getMemory() {
            if (this.memory == 0L) {
                long m = 0L;
                for (Map.Entry<Path, String> e : this.changes.entrySet()) {
                    m += (long)e.getKey().getMemory() + LocalDiffCache.size(e.getValue());
                }
                this.memory = m;
            }
            if (this.memory > Integer.MAX_VALUE) {
                LOG.debug("Estimated memory footprint larger than Integer.MAX_VALUE: {}.", (Object)this.memory);
                return Integer.MAX_VALUE;
            }
            return (int)this.memory;
        }

        String get(Path path) {
            return this.changes.get(path);
        }

        public String toString() {
            return this.asString();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Diff) {
                Diff other = (Diff)obj;
                return this.changes.equals(other.changes);
            }
            return false;
        }
    }
}

