/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.plugins.document.AbstractDocumentNodeBuilder;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeBuilder;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreBranch;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.state.ConflictAnnotatingRebaseDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DocumentRootBuilder
extends AbstractDocumentNodeBuilder {
    private static final Logger log = LoggerFactory.getLogger(DocumentRootBuilder.class);
    protected final DocumentNodeStore store;
    @NotNull
    private NodeState base;
    private DocumentNodeStoreBranch branch;
    private final int updateLimit;
    private int updates;

    DocumentRootBuilder(@NotNull NodeState base, @NotNull DocumentNodeStore store, @NotNull DocumentNodeStoreBranch branch) {
        super((NodeState)Preconditions.checkNotNull((Object)base));
        this.store = (DocumentNodeStore)Preconditions.checkNotNull((Object)store);
        this.base = base;
        this.branch = (DocumentNodeStoreBranch)Preconditions.checkNotNull((Object)branch);
        this.updateLimit = store.getUpdateLimit();
    }

    @NotNull
    public NodeState getBaseState() {
        return this.base;
    }

    public void reset(@NotNull NodeState newBase) {
        this.base = (NodeState)Preconditions.checkNotNull((Object)newBase);
        super.reset(newBase);
    }

    @Override
    protected DocumentNodeBuilder createChildBuilder(String name) {
        return new DocumentNodeBuilder(this, name, this);
    }

    protected void updated() {
        if (++this.updates > this.updateLimit) {
            this.purge();
        }
    }

    @NotNull
    public NodeState getNodeState() {
        if (this.updates > 0) {
            this.purge();
        }
        return this.branch.getHead();
    }

    public Blob createBlob(InputStream stream) throws IOException {
        return this.store.createBlob(stream);
    }

    NodeState rebase() {
        NodeState head = super.getNodeState();
        NodeState inMemBase = super.getBaseState();
        this.branch.rebase();
        super.reset(this.branch.getHead());
        this.updates = 0;
        head.compareAgainstBaseState(inMemBase, (NodeStateDiff)new ConflictAnnotatingRebaseDiff((NodeBuilder)this));
        this.base = this.branch.getBase();
        return super.getNodeState();
    }

    NodeState reset() {
        this.branch = this.store.createBranch(this.store.getRoot());
        NodeState head = this.branch.getHead();
        this.reset(head);
        return head;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NodeState merge(CommitHook hook, CommitInfo info) throws CommitFailedException {
        try {
            this.purge();
        }
        catch (DocumentStoreException e) {
            String msg = "Merge failed to purge changes: " + e.getMessage();
            throw new CommitFailedException("Oak", 1, msg, (Throwable)e);
        }
        boolean success = false;
        try {
            this.branch.merge(hook, info);
            success = true;
        }
        finally {
            if (!success) {
                super.reset(this.branch.getHead());
                this.base = this.branch.getBase();
            }
        }
        return this.reset();
    }

    void purge() {
        this.branch.setRoot(super.getNodeState());
        super.reset(this.branch.getHead());
        this.updates = 0;
    }

    void persist() {
        this.purge();
        this.branch.persist();
    }
}

