/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import javax.management.openmbean.CompositeData;
import org.apache.jackrabbit.oak.api.jmx.Description;
import org.apache.jackrabbit.oak.api.jmx.Name;

public interface DocumentNodeStoreMBean {
    public static final String TYPE = "DocumentNodeStore";

    @Deprecated
    public String getRevisionComparatorState();

    public String getHead();

    public int getClusterId();

    public int getUnmergedBranchCount();

    public String[] getInactiveClusterNodes();

    public String[] getActiveClusterNodes();

    public String[] getLastKnownRevisions();

    public String formatRevision(@Name(value="revision") String var1, @Name(value="UTC") boolean var2);

    @Description(value="Return the estimated time difference in milliseconds between\nthe local instance and the (typically common, shared) document server system.\nThe value can be zero if the times are estimated to be equal,\npositive when the local instance is ahead of the remote server\nand negative when the local instance is behind the remote server. An invocation is not cached\nand typically requires a round-trip to the server (but that is not a requirement).")
    public long determineServerTimeDifferenceMillis();

    public CompositeData getMergeSuccessHistory();

    public CompositeData getMergeFailureHistory();

    public CompositeData getExternalChangeCountHistory();

    public CompositeData getBackgroundUpdateCountHistory();

    public CompositeData getBranchCommitHistory();

    public CompositeData getMergeBranchCommitHistory();

    @Description(value="Triggers last revision recovery of nodes, below a given path and clusterId.\nReturns number of records updated after performing recovery.\nNote: Recovery can only be performed on inactive clusterIds. If the clusterNode is in ReadOnly mode,\nit will return the no. of documents which needs update and won't perform recovery")
    public int recover(@Description(value="The absolute path of a node.") @Name(value="path") String var1, @Description(value="The id of an inactive cluster node.") @Name(value="clusterId") int var2);

    @Description(value="Invalidates all the caches used by the DocumentNodeStore: DiffCache, NodeCache and NodeChildrenCache.")
    public String cleanAllCaches();

    @Description(value="Invalidates the specified cache: DiffCache, NodeCache or NodeChildrenCache.\nNote: The values are case insensitive.")
    public String cleanIndividualCache(@Description(value="Possible values are: DIFF, NODE, NODECHILDREN") @Name(value="name") String var1);
}

